/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.heap;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.jdk.StringInternSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.heap.JSBootImageHeapLowerer;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.util.metrics.CodeSizeCollector;
import com.oracle.svm.webimage.JSKeyword;
import com.oracle.svm.webimage.Labeler;
import com.oracle.svm.webimage.functionintrinsics.JSGenericFunctionDefinition;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import com.oracle.svm.webimage.object.ObjectInspector;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.Keyword;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public class ConstantMap {
    public final ConstantIdentityMapping identityMapping = new ConstantIdentityMapping();
    private final WebImageJSProviders providers;
    private Object defaultReason = null;
    public static final JSGenericFunctionDefinition WEB_IMAGE_CONST_PROPERTY_INIT_F_NAME = new JSGenericFunctionDefinition("generateConstantProperties", 0, false, null, false);

    public ConstantMap(WebImageJSProviders providers) {
        this.providers = providers;
    }

    public String resolveConstantNode(ConstantNode cNode) {
        assert (cNode != null);
        JavaConstant c = cNode.asJavaConstant();
        assert (c != null);
        return this.resolveConstant(c);
    }

    public String resolveConstant(JavaConstant c) {
        return this.saveObject(c);
    }

    private ObjectInspector.ObjectDefinition saveConstantObject(JavaConstant c) {
        return this.providers.objectInspector().inspectObject(c, this.defaultReason, this.identityMapping);
    }

    public String saveObject(JavaConstant c) {
        return this.saveObjectGetNode(c).requestName();
    }

    public ConstantIdentityMapping.IdentityNode saveHubGetNode(ResolvedJavaType t) {
        return this.saveObjectGetNode((JavaConstant)this.providers.getConstantReflection().asObjectHub(t));
    }

    public ConstantIdentityMapping.IdentityNode saveObjectGetNode(JavaConstant c) {
        this.saveConstantObject(c);
        return this.identityMapping.getIdentityNode(c);
    }

    public void processInternedStrings() {
        HostedMetaAccess metaAccess = (HostedMetaAccess)this.providers.getMetaAccess();
        HostedField internedStringsField = metaAccess.optionalLookupJavaField(StringInternSupport.getInternedStringsField());
        boolean usesInternedStrings = internedStringsField != null && internedStringsField.isReachable();
        JavaConstant imageInternedStringsConstant = this.providers.getSnippetReflection().forObject(StringInternSupport.getImageInternedStrings());
        if (!usesInternedStrings || !this.identityMapping.hasMappingForObject(imageInternedStringsConstant)) {
            return;
        }
        String[] internedStrings = this.identityMapping.getInternedStrings();
        this.identityMapping.disallowInternStrings();
        if (internedStrings.length == 0) {
            return;
        }
        ObjectInspector.ObjectType imageInternedStringsObject = (ObjectInspector.ObjectType)this.identityMapping.getDefByObject(imageInternedStringsConstant);
        StringInternSupport.setImageInternedStrings((String[])internedStrings);
        int imageInternedStringsFieldIndex = -1;
        for (int i = 0; i < imageInternedStringsObject.fields.fields.size(); ++i) {
            if (!imageInternedStringsObject.fields.fields.get(i).getName().equals("imageInternedStrings")) continue;
            imageInternedStringsFieldIndex = i;
            break;
        }
        assert (imageInternedStringsFieldIndex >= 0) : "The ImageInternedStrings singleton must have the 'imageInternedStrings' field";
        assert (((ObjectInspector.ObjectType)imageInternedStringsObject.members.get(imageInternedStringsFieldIndex)).isNull()) : "The ImageInternedStrings singleton must have the 'imageInternedStrings' field set to null";
        ((AnalysisMetaAccess)metaAccess.getWrapped()).getUniverse().getHeapScanner().rescanObject((Object)internedStrings, ObjectScanner.OtherReason.LATE_SCAN);
        JavaConstant internedStringsConstant = this.providers.getSnippetReflection().forObject((Object)internedStrings);
        ObjectInspector.ArrayType internedStringsNew = (ObjectInspector.ArrayType)this.saveConstantObject(internedStringsConstant);
        imageInternedStringsObject.members.set(imageInternedStringsFieldIndex, internedStringsNew);
    }

    public void lower(JSCodeGenTool jsLTools) {
        Labeler.Injection injection;
        this.processInternedStrings();
        this.providers.objectInspector().freeze();
        CodeBuffer masm = jsLTools.getCodeBuffer();
        Labeler labeler = this.providers.labeler();
        masm.emitNewLine();
        JSBootImageHeapLowerer heapLowerer = WebImageHostedConfiguration.get().createBootImageHeapLowerer(this.providers, jsLTools, this.identityMapping);
        try (CodeSizeCollector collector = new CodeSizeCollector(ImageBreakdownMetricKeys.CONSTANT_DEFS_SIZE, () -> ((JSCodeGenTool)jsLTools).getCodeSize());){
            injection = labeler.injectMetricLabel(jsLTools.getCodeBuffer(), ImageBreakdownMetricKeys.CONSTANT_DEFS_SIZE);
            try {
                heapLowerer.emitSetup();
            }
            finally {
                if (injection != null) {
                    injection.close();
                }
            }
        }
        masm.emitNewLine();
        masm.emitNewLine();
        masm.emitKeyword((Keyword)JSKeyword.FUNCTION);
        masm.emitWhiteSpace();
        WEB_IMAGE_CONST_PROPERTY_INIT_F_NAME.emitReference(jsLTools);
        masm.emitText("() ");
        masm.emitScopeBegin();
        collector = new CodeSizeCollector(ImageBreakdownMetricKeys.CONSTANT_INITS_SIZE, () -> ((JSCodeGenTool)jsLTools).getCodeSize());
        try {
            injection = labeler.injectMetricLabel(jsLTools.getCodeBuffer(), ImageBreakdownMetricKeys.CONSTANT_INITS_SIZE);
            try {
                heapLowerer.lowerInitialization();
            }
            finally {
                if (injection != null) {
                    injection.close();
                }
            }
        }
        finally {
            collector.close();
        }
        jsLTools.genScopeEnd();
        collector = new CodeSizeCollector(ImageBreakdownMetricKeys.CONSTANT_DEFS_SIZE, () -> ((JSCodeGenTool)jsLTools).getCodeSize());
        try {
            injection = labeler.injectMetricLabel(jsLTools.getCodeBuffer(), ImageBreakdownMetricKeys.CONSTANT_DEFS_SIZE);
            try {
                heapLowerer.lowerDeclarations();
            }
            finally {
                if (injection != null) {
                    injection.close();
                }
            }
        }
        finally {
            collector.close();
        }
    }

    public void setDefaultReason(Object defaultReason) {
        this.defaultReason = defaultReason;
    }
}

