/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.compatibility;

import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.LowerableResources;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.options.OptionValues;

public class JSBenchmarkingCode {
    private static int timeBenchIndexS;
    private final List<Timer> timers = new ArrayList<Timer>();
    private final JSCodeGenTool jsLTools;
    private final boolean genTimer;

    public JSBenchmarkingCode(JSCodeGenTool jsLTools, OptionValues options) {
        this.jsLTools = jsLTools;
        this.genTimer = (Boolean)WebImageOptions.DebugOptions.GenTimingCode.getValue(options);
    }

    public Timer getTimer(String name) {
        Timer t = this.genTimer ? new RealTimer(this.jsLTools, name) : new NopTimer();
        this.timers.add(t);
        return t;
    }

    public void lowerMeasuringResult() {
        this.timers.forEach(t -> t.lowerMeasuringResult("console.error"));
    }

    public void lowerInitialDefinition() {
        if (this.genTimer) {
            this.jsLTools.lowerFile(LowerableResources.TIMER);
        }
    }

    public static final class RealTimer
    extends Timer {
        public static final String TIME_BENCH_VAR = "timeBench_";
        public final String name;
        public final String varName;
        private final JSCodeGenTool jsLTools;

        private RealTimer(JSCodeGenTool jsLTools, String name) {
            this.jsLTools = jsLTools;
            this.name = name;
            this.varName = TIME_BENCH_VAR + timeBenchIndexS++;
        }

        private void lowerMeasuringStart() {
            CodeBuffer masm = this.jsLTools.getCodeBuffer();
            masm.emitText("let " + this.varName + " = new Timer(");
            masm.emitStringLiteral(this.name);
            masm.emitText(");");
            masm.emitNewLine();
            masm.emitText(this.varName + ".start();\n");
        }

        private void lowerMeasuringEnd() {
            this.jsLTools.getCodeBuffer().emitText(this.varName + ".stop();\n");
        }

        @Override
        public void lowerMeasuringResult(String logfunName) {
            this.jsLTools.getCodeBuffer().emitText(this.varName + ".print(" + logfunName + ");\n");
        }

        @Override
        public Timer start() {
            this.lowerMeasuringStart();
            return this;
        }

        @Override
        public void close() {
            this.lowerMeasuringEnd();
        }
    }

    public static final class NopTimer
    extends Timer {
        @Override
        public Timer start() {
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void lowerMeasuringResult(String logfunName) {
        }
    }

    public static abstract class Timer
    implements AutoCloseable {
        public abstract Timer start();

        @Override
        public abstract void close();

        public abstract void lowerMeasuringResult(String var1);
    }
}

