/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.arithm;

import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.wrappers.JSEmitter;
import com.oracle.svm.webimage.JSKeyword;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.vm.ci.meta.JavaKind;

public class BinaryIntOperationLowerer {
    public static void binaryOp(ValueNode node, ValueNode lOp, ValueNode rOp, JSCodeGenTool jsLTools, JSKeyword operatorSymbol, boolean intPaladin) {
        assert (node.getStackKind() == JavaKind.Int) : node.getStackKind();
        assert (lOp.getStackKind() == JavaKind.Int) : lOp.getStackKind();
        assert (rOp.getStackKind() == JavaKind.Int) : rOp.getStackKind();
        if (node instanceof MulNode) {
            JSCallNode.MATH_IMUL.emitCall((CodeGenTool)jsLTools, new IEmitter[]{Emitter.of((ValueNode)lOp), Emitter.of((ValueNode)rOp)});
        } else {
            JSEmitter emitter = JSEmitter.of(t -> t.genBinaryOperation(operatorSymbol, lOp, rOp));
            if (intPaladin) {
                emitter = JSEmitter.intPaladin(emitter);
            }
            emitter.lower(jsLTools);
        }
    }
}

