/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.webimage.js.JSBody;
import java.util.Collection;
import java.util.HashSet;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.variables.VariableAllocation;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.java.AbstractNewArrayNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;

public class WebImageVariableAllocation
extends VariableAllocation {
    private static final long LOWER_INLINING_THRESHOLD = -10L;
    private static final long UPPER_INLINING_THRESHOLD = 100L;

    public Collection<VariableAllocation.SafetyPolicy> getSafeInliningPolicies(ValueNode node, CodeGenTool codeGenTool) {
        HashSet<VariableAllocation.SafetyPolicy> policies = new HashSet<VariableAllocation.SafetyPolicy>();
        if (node.inputs().filter(PhiNode.class).isNotEmpty()) {
            policies.add(VariableAllocation.SafetyPolicy.InBlockNoMerge);
        }
        if (node instanceof StateSplit) {
            policies.add(VariableAllocation.SafetyPolicy.SingleUsage);
        }
        if (node instanceof AbstractNewArrayNode) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof BoxNode) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof JSBody) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof PhiNode) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof FloatingNode) {
            policies.add(VariableAllocation.SafetyPolicy.Always);
        } else if (node instanceof FixedWithNextNode) {
            policies.add(VariableAllocation.SafetyPolicy.SingleUsageAtNext);
        } else if (node instanceof FixedNode) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        } else {
            policies.add(VariableAllocation.SafetyPolicy.SingleUsage);
        }
        return policies;
    }

    protected boolean shouldInline(ValueNode node, int numUsages, CodeGenTool codeGenTool) {
        if (node instanceof ParameterNode) {
            return true;
        }
        if (node instanceof ValueProxyNode) {
            return true;
        }
        if (node instanceof PiNode) {
            return true;
        }
        if (node instanceof ConstantNode) {
            Constant value = ((ConstantNode)node).getValue();
            if (value.isDefaultForKind()) {
                return true;
            }
            if (value instanceof PrimitiveConstant) {
                long val;
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)value;
                JavaKind kind = primitiveConstant.getJavaKind();
                if (kind == JavaKind.Boolean) {
                    return true;
                }
                if (kind.isNumericInteger() && -10L < (val = primitiveConstant.asLong()) && val < 100L) {
                    return true;
                }
            }
        }
        return numUsages == 1;
    }
}

