/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.heap.ConstantMap;
import com.oracle.svm.webimage.NamingConvention;
import com.oracle.svm.webimage.type.TypeControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public class WebImageTypeControl
implements Iterator<HostedType>,
TypeControl {
    private final HostedUniverse hostedUniverse;
    private final WebImageJSProviders providers;
    private final NamingConvention namingConvention;
    private final ConstantMap constantMap;
    private final List<HostedType> emittedTypes;
    private final DependencyGraph graph;
    private Object defaultReason = null;
    private HostedType lastType = null;

    public ConstantMap getConstantMap() {
        return this.constantMap;
    }

    public void postProcess(JSCodeGenTool jsLTools) {
        assert (jsLTools != null);
        this.constantMap.lower(jsLTools);
    }

    public Collection<HostedType> queryOmittedTypes() {
        HashSet<HostedType> hostedTypes = new HashSet<HostedType>(this.hostedUniverse.getTypes());
        this.emittedTypes.forEach(hostedTypes::remove);
        return hostedTypes;
    }

    public Collection<HostedType> queryEmittedTypes() {
        return Collections.unmodifiableList(this.emittedTypes);
    }

    public Iterable<Object> getReasons(HostedType type) {
        return this.graph.getReasons(type);
    }

    public WebImageTypeControl(HostedUniverse hostedUniverse, WebImageJSProviders providers, ConstantMap constantMap, NamingConvention namingConvention) {
        assert (hostedUniverse != null);
        this.hostedUniverse = hostedUniverse;
        this.providers = providers;
        this.constantMap = constantMap;
        this.namingConvention = namingConvention;
        int numTypes = hostedUniverse.getTypes().size();
        this.emittedTypes = new ArrayList<HostedType>(numTypes);
        this.graph = new DependencyGraph(numTypes);
    }

    public List<HostedType> emittedTypes() {
        return this.emittedTypes;
    }

    public HostedUniverse getHUniverse() {
        return this.hostedUniverse;
    }

    @Override
    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    @Override
    public String requestTypeName(ResolvedJavaType t, Object reason) {
        assert (!t.isArray()) : t;
        this.graph.insertType((HostedType)t, reason);
        return this.namingConvention.identForType(t);
    }

    @Override
    public String requestTypeName(ResolvedJavaType t) {
        return this.requestTypeName(t, this.defaultReason);
    }

    @Override
    public String requestHubName(ResolvedJavaType t) {
        return this.getConstantMap().saveHubGetNode(t).requestName();
    }

    @Override
    public String requestFieldName(ResolvedJavaField f) {
        return this.namingConvention.identForProperty(f);
    }

    @Override
    public String requestMethodName(ResolvedJavaMethod m) {
        return this.namingConvention.identForMethod(m);
    }

    @Override
    public boolean hasNext() {
        if (!this.graph.hasTypeToEmit()) {
            this.setLastType(null);
            return false;
        }
        return true;
    }

    @Override
    public HostedType next() {
        HostedType t = this.graph.getTypeToEmit();
        this.emittedTypes.add(t);
        this.setLastType(t);
        return t;
    }

    private void setLastType(HostedType t) {
        this.lastType = t;
        this.resetDefaultReason();
    }

    public void setDefaultReason(Object defaultReason) {
        this.defaultReason = defaultReason == null ? this.lastType : defaultReason;
        this.constantMap.setDefaultReason(this.defaultReason);
    }

    public void resetDefaultReason() {
        this.setDefaultReason(null);
    }

    private static final class DependencyGraph {
        private final EconomicMap<HostedType, TypeNode> typeMap;
        private final Queue<TypeNode> toEmit = new LinkedList<TypeNode>();
        private boolean isFrozen = false;

        private DependencyGraph(int numTypes) {
            this.typeMap = EconomicMap.create((int)numTypes);
        }

        private void freeze() {
            this.isFrozen = true;
        }

        public boolean isFrozen() {
            return this.isFrozen;
        }

        public Iterable<Object> getReasons(HostedType type) {
            return ((TypeNode)this.typeMap.get((Object)type)).reasons;
        }

        public HostedType getTypeToEmit() {
            TypeNode n = this.toEmit.remove();
            assert (n.dependencies.isEmpty()) : n.dependencies;
            assert (!n.emitted) : "TypeNode " + String.valueOf(n) + " was already emitted";
            n.emitted = true;
            this.removeDependencies(n);
            return n.type;
        }

        public boolean hasTypeToEmit() {
            boolean hasNext;
            boolean bl = hasNext = !this.toEmit.isEmpty();
            if (!hasNext) {
                assert (StreamSupport.stream(this.typeMap.getValues().spliterator(), false).allMatch(n -> n.emitted)) : StreamSupport.stream(this.typeMap.getValues().spliterator(), false).toList();
                this.freeze();
            }
            return hasNext;
        }

        private TypeNode insertType(HostedType t, Object reason) {
            TypeNode existing = (TypeNode)this.typeMap.get((Object)t);
            if (existing != null) {
                assert (!existing.isConstructing) : "Circular dependency in type control: " + String.valueOf(t);
                existing.addReason(reason);
                return existing;
            }
            assert (!this.isFrozen()) : "No more new types allowed.";
            TypeNode n = new TypeNode(t, reason);
            this.typeMap.put((Object)t, (Object)n);
            HostedClass superClass = t.getSuperclass();
            if (superClass != null) {
                this.addDependency(n, (HostedType)superClass);
            }
            if (!t.getWrapped().getJavaClass().equals(Object.class)) {
                for (HostedMethod m : t.getVTable()) {
                    HostedType declaring = m.getDeclaringClass();
                    if (declaring.equals(t)) continue;
                    this.addDependency(n, declaring);
                }
            }
            n.isConstructing = false;
            if (n.hasNoDependency()) {
                this.toEmit.offer(n);
            }
            return n;
        }

        private void addDependency(TypeNode from, HostedType to) {
            assert (from.isConstructing) : "You can only add dependencies while constructing the node";
            TypeNode n = this.insertType(to, from.type);
            if (n.emitted) {
                return;
            }
            n.requiredBy.add((Object)from);
            from.dependencies.add((Object)n);
        }

        private void removeDependencies(TypeNode to) {
            for (TypeNode from : to.requiredBy) {
                from.dependencies.remove((Object)to);
                if (!from.hasNoDependency()) continue;
                this.toEmit.offer(from);
            }
            to.requiredBy.clear();
        }

        private static class TypeNode {
            final HostedType type;
            private final EconomicSet<TypeNode> dependencies = EconomicSet.create();
            private final EconomicSet<TypeNode> requiredBy = EconomicSet.create();
            private final EconomicSet<Object> reasons = EconomicSet.create();
            private boolean emitted = false;
            private boolean isConstructing = true;

            TypeNode(HostedType type, Object reason) {
                this.type = type;
                this.addReason(reason);
            }

            public boolean hasNoDependency() {
                return this.dependencies.isEmpty();
            }

            public void addReason(Object reason) {
                if (reason != null) {
                    this.reasons.add(reason);
                }
            }

            public String toString() {
                return "TypeNode{type=" + this.type.toJavaName() + ", dependencies=" + this.dependencies.size() + ", requiredBy=" + this.requiredBy.size() + ", emitted=" + this.emitted + ", isConstructing=" + this.isConstructing + "}";
            }
        }
    }
}

