/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.webimage.Labeler;
import java.io.PrintStream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.CoreProvidersDelegate;

public abstract class WebImageProviders
extends CoreProvidersDelegate {
    private final PrintStream out;
    private final DebugContext debug;
    private final Labeler labeler;

    protected WebImageProviders(CoreProviders underlyingProviders, PrintStream out, DebugContext debug) {
        super(underlyingProviders);
        this.out = out;
        this.debug = debug;
        this.labeler = WebImageProviders.getLabelInjector();
    }

    public PrintStream stdout() {
        return this.out;
    }

    public DebugContext debug() {
        return this.debug;
    }

    public Labeler labeler() {
        return this.labeler;
    }

    private static Labeler getLabelInjector() {
        if (WebImageProviders.isLabelInjectionEnabled()) {
            return new Labeler();
        }
        return new Labeler.NoOpLabeler();
    }

    public static boolean isLabelInjectionEnabled() {
        return (Boolean)WebImageOptions.ClosureCompiler.getValue() != false && (Boolean)WebImageOptions.ReportImageSizeBreakdown.getValue() != false;
    }

    public static HostedMethod findMethod(HostedType type, String name) {
        for (HostedMethod meth : type.getAllDeclaredMethods()) {
            if (!meth.getName().equals(name)) continue;
            return meth;
        }
        throw VMError.shouldNotReachHere((String)("method not found " + name));
    }
}

