/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.hosted.webimage.codegen.heap.ConstantMap;
import com.oracle.svm.hosted.webimage.codegen.heap.WebImageObjectInspector;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import java.io.PrintStream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.spi.CoreProviders;

public class WebImageJSProviders
extends WebImageProviders {
    private final WebImageObjectInspector objectInspector;
    private final WebImageTypeControl typeControl;
    private final ClassLoader classLoader;

    public WebImageJSProviders(CoreProviders underlyingProviders, PrintStream out, DebugContext debug) {
        super(underlyingProviders, out, debug);
        HostedUniverse hUniverse = ((HostedMetaAccess)underlyingProviders.getMetaAccess()).getUniverse();
        this.typeControl = new WebImageTypeControl(hUniverse, this, new ConstantMap(this), WebImageNamingConvention.getInstance());
        this.objectInspector = new WebImageObjectInspector(this);
        this.classLoader = hUniverse.hostVM().getClassLoader();
    }

    public WebImageTypeControl typeControl() {
        return this.typeControl;
    }

    public WebImageObjectInspector objectInspector() {
        return this.objectInspector;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

