/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.ReadReturnAddressNode;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.graal.thread.LoadVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.StoreVMThreadLocalNode;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.codegen.Array;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.Runtime;
import com.oracle.svm.hosted.webimage.codegen.RuntimeConstants;
import com.oracle.svm.hosted.webimage.codegen.WebImageImplicitExceptionsFeature;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.hosted.webimage.codegen.arithm.BinaryFloatOperationLowerer;
import com.oracle.svm.hosted.webimage.codegen.arithm.BinaryIntOperationLowerer;
import com.oracle.svm.hosted.webimage.codegen.heap.ConstantMap;
import com.oracle.svm.hosted.webimage.codegen.heap.JSBootImageHeapLowerer;
import com.oracle.svm.hosted.webimage.codegen.long64.Long64Lowerer;
import com.oracle.svm.hosted.webimage.codegen.node.CompoundConditionNode;
import com.oracle.svm.hosted.webimage.codegen.node.ReadIdentityHashCodeNode;
import com.oracle.svm.hosted.webimage.codegen.node.WriteIdentityHashCodeNode;
import com.oracle.svm.hosted.webimage.codegen.type.InvokeLoweringUtil;
import com.oracle.svm.hosted.webimage.codegen.value.ResolvedVarLowerer;
import com.oracle.svm.hosted.webimage.codegen.wrappers.JSEmitter;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.snippets.JSSnippets;
import com.oracle.svm.webimage.JSKeyword;
import com.oracle.svm.webimage.functionintrinsics.ImplicitExceptions;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionDefinition;
import com.oracle.svm.webimage.functionintrinsics.JSSystemFunction;
import com.oracle.svm.webimage.object.ObjectInspector;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.core.amd64.AMD64AddressNode;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.graph.iterators.NodePredicate;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.hightiercodegen.Keyword;
import jdk.graal.compiler.hightiercodegen.NodeLowerer;
import jdk.graal.compiler.hightiercodegen.lowerer.PhiResolveLowerer;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.BinaryOpLogicNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.UnreachableControlSinkNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.calc.AbsNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatConvertNode;
import jdk.graal.compiler.nodes.calc.FloatDivNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.calc.OrNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.RemNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.RoundNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerDivNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerRemNode;
import jdk.graal.compiler.nodes.calc.SignumNode;
import jdk.graal.compiler.nodes.calc.SqrtNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.calc.UnsignedDivNode;
import jdk.graal.compiler.nodes.calc.UnsignedRemNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.calc.XorNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.debug.BlackholeNode;
import jdk.graal.compiler.nodes.extended.AbstractBoxingNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ClassIsArrayNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.extended.LoadArrayComponentHubNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryLoadNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryStoreNode;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.java.AbstractUnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.FinalFieldBarrierNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.ReachabilityFenceNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.replacements.nodes.ArrayEqualsNode;
import jdk.graal.compiler.replacements.nodes.ArrayFillNode;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.graal.compiler.word.WordCastNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WebImageJSNodeLowerer
extends NodeLowerer {
    protected final JSCodeGenTool codeGenTool;
    public static final boolean INT_PALADIN = true;
    public static final Set<Class<?>> IGNORED_NODE_TYPES = new HashSet<Class>(Arrays.asList(MergeNode.class, StartNode.class, ValueAnchorNode.class, BeginNode.class, ExceptionObjectNode.LoweredExceptionObjectBegin.class, UnreachableBeginNode.class, LoopExitNode.class, UnreachableControlSinkNode.class, CallTargetNode.class, CFunctionPrologueNode.class, CFunctionEpilogueNode.class, FixedGuardNode.class, MonitorIdNode.class, MembarNode.class, VirtualState.class, VirtualObjectNode.class, FinalFieldBarrierNode.class));
    public static final Set<Class<?>> FORBIDDEN_NODE_TYPES = new HashSet<Class>(Arrays.asList(ReadCallerStackPointerNode.class, PhiNode.class, FormatObjectNode.class, FormatArrayNode.class, StackValueNode.class, ReadReturnAddressNode.class, LoadVMThreadLocalNode.class, StoreVMThreadLocalNode.class, CommitAllocationNode.class, AllocatedObjectNode.class, EnsureClassInitializedNode.class, ClassIsArrayNode.class));

    public WebImageJSNodeLowerer(JSCodeGenTool codeGenTool) {
        super((CodeGenTool)codeGenTool);
        this.codeGenTool = codeGenTool;
    }

    protected void lowerVarDeclPrefix(ResolvedVar resolvedVar) {
        this.codeGenTool.genResolvedVarDeclPrefix(resolvedVar.getName());
        resolvedVar.setDefinitionLowered();
    }

    protected void lower(ResolvedVar resolvedVar) {
        ResolvedVarLowerer.lower(resolvedVar, this.codeGenTool);
    }

    protected void dispatch(Node node) {
        if (node instanceof LoweredDeadEndNode) {
            this.lowerLoweredDeadEndNode();
        } else if (node instanceof ThrowBytecodeExceptionNode) {
            ThrowBytecodeExceptionNode throwBytecodeExceptionNode = (ThrowBytecodeExceptionNode)node;
            this.lower(throwBytecodeExceptionNode);
        } else if (node instanceof DeoptimizeNode) {
            this.lower((DeoptimizeNode)node);
        } else if (node instanceof JSCallNode) {
            this.lower((JSCallNode)node);
        } else if (node instanceof CompoundConditionNode) {
            this.lower((CompoundConditionNode)node);
        } else if (node instanceof JSBody) {
            JSBody jsBody = (JSBody)node;
            this.lower(jsBody);
        } else if (node instanceof StaticFieldsSupport.StaticFieldResolvedBaseNode) {
            StaticFieldsSupport.StaticFieldResolvedBaseNode resolvedBaseNode = (StaticFieldsSupport.StaticFieldResolvedBaseNode)node;
            this.lower(resolvedBaseNode);
        } else if (node instanceof ReadIdentityHashCodeNode) {
            ReadIdentityHashCodeNode readIdentityHashCodeNode = (ReadIdentityHashCodeNode)node;
            this.lower(readIdentityHashCodeNode);
        } else if (node instanceof WriteIdentityHashCodeNode) {
            WriteIdentityHashCodeNode writeIdentityHashCodeNode = (WriteIdentityHashCodeNode)node;
            this.lower(writeIdentityHashCodeNode);
        } else if (node instanceof FloatingWordCastNode) {
            FloatingWordCastNode floatingWordCastNode = (FloatingWordCastNode)node;
            this.lower(floatingWordCastNode);
        } else {
            super.dispatch(node);
        }
    }

    public boolean isIgnored(Node node) {
        for (Class<?> c : IGNORED_NODE_TYPES) {
            if (!c.isInstance(node)) continue;
            return true;
        }
        return false;
    }

    protected boolean isForbiddenNode(Node node) {
        for (Class<?> c : FORBIDDEN_NODE_TYPES) {
            if (!c.isInstance(node)) continue;
            return true;
        }
        return false;
    }

    protected String reportForbiddenNode(Node node) {
        return this.nodeDebugInfo(node);
    }

    protected void lower(ReadIdentityHashCodeNode readIdentityHashCodeNode) {
        JSEmitter.intPaladin(JSEmitter.of(t -> t.genPropertyAccess((IEmitter)Emitter.of((ValueNode)readIdentityHashCodeNode.getObject()), (IEmitter)Emitter.of((String)"__hc")))).lower(this.codeGenTool);
    }

    protected void lower(WriteIdentityHashCodeNode writeIdentityHashCodeNode) {
        this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ValueNode)writeIdentityHashCodeNode.getObject()), (IEmitter)Emitter.of((String)"__hc"));
        this.codeGenTool.genAssignment();
        this.lowerValue(writeIdentityHashCodeNode.getHashCode());
    }

    protected void lower(NegateNode node) {
        if (node.getValue().getStackKind() == JavaKind.Long) {
            Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, node.getValue(), this.codeGenTool);
        } else {
            JSEmitter emitter = JSEmitter.of(t -> {
                this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
                this.codeGenTool.getCodeBuffer().emitText("- ");
                this.lowerValue(node.getValue());
                this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
                if (node.getValue().stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                    this.codeGenTool.genInlineComment("Stamp bit size:" + ((IntegerStamp)node.stamp(NodeView.DEFAULT)).getBits() + " kind:" + node.getValue().getStackKind().toString());
                    this.codeGenTool.getCodeBuffer().emitText("&" + CodeUtil.mask((int)((IntegerStamp)node.stamp(NodeView.DEFAULT)).getBits()));
                }
            });
            if (node.getValue().stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                emitter = JSEmitter.intPaladin(emitter);
            }
            emitter.lower(this.codeGenTool);
        }
    }

    protected void lower(UnwindNode node) {
        this.codeGenTool.genThrow(node.exception());
    }

    protected void lower(Invoke invoke) {
        assert (invoke instanceof InvokeNode || invoke instanceof InvokeWithExceptionNode) : invoke;
        CallTargetNode callTarget = invoke.callTarget();
        HostedMethod targetMethod = (HostedMethod)callTarget.targetMethod();
        HostedType receiverType = null;
        if (invoke.getInvokeKind().hasReceiver()) {
            Stamp receiverStamp = invoke.getReceiver().stamp(NodeView.DEFAULT);
            assert (receiverStamp != null);
            receiverType = (HostedType)receiverStamp.javaType(this.codeGenTool.getProviders().getMetaAccess());
            assert (receiverType != null);
            this.codeGenTool.getProviders().debug().log("Receiver type: %s", (Object)receiverType);
            this.codeGenTool.getProviders().debug().log("Target method: %s", (Object)targetMethod);
            this.codeGenTool.getProviders().debug().log("Target type  : %s", (Object)targetMethod.getDeclaringClass());
            this.codeGenTool.genComment("Receiver type:" + String.valueOf(receiverType));
        }
        if (targetMethod != null) {
            this.codeGenTool.genComment("Target method:" + String.valueOf(targetMethod));
            this.codeGenTool.genComment("Target type  :" + targetMethod.getDeclaringClass().toString());
        }
        if (callTarget instanceof IndirectCallTargetNode) {
            assert (targetMethod == null) : "Indirect call target nodes are not expected to have target methods.";
            InvokeLoweringUtil.lowerIndirect(invoke, this.codeGenTool);
        } else if (invoke.getInvokeKind().hasReceiver()) {
            InvokeLoweringUtil.lowerOrPatchDynamic(targetMethod, receiverType, invoke, this.codeGenTool);
        } else {
            InvokeLoweringUtil.lowerOrPatchStatic(targetMethod, invoke, this.codeGenTool);
        }
    }

    protected void lower(IsNullNode node) {
        this.lowerValue(node.getValue());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.EQQ);
        this.codeGenTool.genNull();
    }

    protected void lower(ExceptionObjectNode node) {
        this.codeGenTool.getCodeBuffer().emitText(this.codeGenTool.getExceptionObjectId((Node)node));
    }

    protected void lower(ConstantNode node) {
        Constant c = node.asConstant();
        WebImageTypeControl typeControl = this.codeGenTool.getJSProviders().typeControl();
        ConstantMap constantMap = typeControl.getConstantMap();
        if (c instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind() == JavaKind.Long) {
            Long64Lowerer.lowerFromConstant(c, this.codeGenTool);
        } else if (c instanceof PrimitiveConstant) {
            WebImageJSNodeLowerer.lowerConstant((PrimitiveConstant)c, this.codeGenTool);
        } else {
            this.codeGenTool.genInlineComment(node.toString());
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
            if (JavaConstant.isNull((Constant)c)) {
                this.codeGenTool.genNull();
            } else {
                String varName = constantMap.resolveConstantNode(node);
                assert (varName != null);
                this.codeGenTool.getCodeBuffer().emitText(varName);
            }
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        }
    }

    protected void lower(LoadIndexedNode node) {
        if (node.elementKind() == JavaKind.Long) {
            Runtime.BigInt64ArrayLoad.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.array()), Emitter.of((ValueNode)node.index())});
        } else {
            this.codeGenTool.genArrayLoad(node.index(), node.array());
        }
    }

    protected void lower(NewArrayNode node) {
        ResolvedVar resolvedVar = this.codeGenTool.getAllocatedVariable((ValueNode)node);
        if (resolvedVar == null) {
            assert (this.actualUsageCount((Node)node) == 0) : this.nodeDebugInfo((Node)node);
            return;
        }
        HostedType t = (HostedType)node.elementType();
        Array.lowerNewArray(t, (IEmitter)Emitter.of((ValueNode)node.length()), this.codeGenTool);
        this.codeGenTool.genResolvedVarDeclPostfix(node.toString());
    }

    protected void lower(StoreIndexedNode node) {
        if (node.elementKind() == JavaKind.Long) {
            Runtime.BigInt64ArrayStore.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.array()), Emitter.of((ValueNode)node.index()), Emitter.of((ValueNode)node.value())});
        } else {
            this.codeGenTool.genArrayStore((IEmitter)Emitter.of((ValueNode)node.index()), node.array(), node.value());
        }
    }

    protected void lower(ParameterNode node) {
        this.codeGenTool.genResolvedVarAccess(JSCodeBuffer.getParamName(node.index()));
    }

    protected void lower(ConditionalNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue((ValueNode)node.condition());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeGenTool.getCodeBuffer().emitText("?");
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue(node.trueValue());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeGenTool.getCodeBuffer().emitText(":");
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue(node.falseValue());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(BoxNode node) {
        HostedMetaAccess metaAccess = (HostedMetaAccess)this.codeGenTool.getProviders().getMetaAccess();
        ResolvedVar resolvedVar = this.codeGenTool.getAllocatedVariable((ValueNode)node);
        if (resolvedVar == null) {
            assert (this.actualUsageCount((Node)node) == 0) : this.nodeDebugInfo((Node)node);
            return;
        }
        HostedType boxing = metaAccess.lookupJavaType(node.getBoxingKind().toBoxedJavaClass());
        this.codeGenTool.genObjectCreate((IEmitter)Emitter.of((ResolvedJavaType)boxing), new IEmitter[0]);
        this.codeGenTool.genResolvedVarDeclPostfix("Boxed");
        HostedField valueField = (HostedField)AbstractBoxingNode.getValueField((ResolvedJavaType)boxing);
        this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ResolvedVar)resolvedVar), (IEmitter)Emitter.of((ResolvedJavaField)valueField));
        this.codeGenTool.genAssignment();
        this.lowerValue(node.getValue());
    }

    protected void lower(FloatConvertNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        switch (node.getFloatConvert()) {
            case F2I: 
            case D2I: {
                Runtime.TO_INT.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
                break;
            }
            case F2L: 
            case D2L: {
                Runtime.TO_LONG.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
                break;
            }
            case D2F: 
            case I2F: {
                this.codeGenTool.getCodeBuffer().emitText("Math.fround(");
                this.lowerValue(node.getValue());
                this.codeGenTool.getCodeBuffer().emitText(")");
                break;
            }
            case I2D: {
                this.lowerValue(node.getValue());
                break;
            }
            case L2D: {
                Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, node.getValue(), this.codeGenTool);
                break;
            }
            case L2F: {
                this.codeGenTool.getCodeBuffer().emitText("Math.fround(");
                Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, node.getValue(), this.codeGenTool);
                this.codeGenTool.getCodeBuffer().emitText(")");
                break;
            }
            case F2D: {
                this.lowerValue(node.getValue());
                break;
            }
            default: {
                throw JVMCIError.shouldNotReachHere((String)node.getFloatConvert().toString());
            }
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(ArrayLengthNode node) {
        this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ValueNode)node.array()), (IEmitter)Emitter.of((String)"length"));
    }

    protected void lower(BasicArrayCopyNode node) {
        ArrayList<ValueNode> v = new ArrayList<ValueNode>();
        v.add(node.getSource());
        v.add(node.getSourcePosition());
        v.add(node.getDestination());
        v.add(node.getDestinationPosition());
        v.add(node.getLength());
        JSCallNode.ARRAY_COPY.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(v));
    }

    protected void lower(IntegerTestNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        if (node.getX().getStackKind() == JavaKind.Long || node.getY().getStackKind() == JavaKind.Long) {
            JVMCIError.guarantee((node.getX().getStackKind() == JavaKind.Long ? 1 : 0) != 0, (String)"P1 must be long %s", (Object[])new Object[]{node.getX().toString()});
            JVMCIError.guarantee((node.getY().getStackKind() == JavaKind.Long ? 1 : 0) != 0, (String)"P2 must be long %s", (Object[])new Object[]{node.getY().toString()});
            Long64Lowerer.genBinaryLogicNode((BinaryOpLogicNode)node, node.getX(), node.getY(), this.codeGenTool);
        } else {
            CodeBuffer masm = this.codeGenTool.getCodeBuffer();
            masm.emitText("(");
            this.lowerValue(node.getX());
            masm.emitText("&");
            this.lowerValue(node.getY());
            masm.emitText(") == 0 ");
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(ReturnNode node) {
        if (node.result() == null) {
            this.codeGenTool.genVoidReturn();
        } else {
            this.codeGenTool.genReturn(node.result());
        }
    }

    protected void lower(ObjectEqualsNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue(node.getX());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.EQQ);
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue(node.getY());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(CompareNode node) {
        assert (!(node instanceof ObjectEqualsNode)) : "this method only handles numeric compare nodes";
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        ValueNode lOp = node.getX();
        ValueNode rOp = node.getY();
        if (lOp.getStackKind() == JavaKind.Long) {
            assert (rOp.getStackKind() == JavaKind.Long) : rOp.getStackKind();
            Long64Lowerer.genBinaryLogicNode((BinaryOpLogicNode)node, node.getX(), node.getY(), this.codeGenTool);
        } else {
            assert (lOp.getStackKind() != JavaKind.Long) : lOp.getStackKind();
            assert (rOp.getStackKind() != JavaKind.Long) : rOp.getStackKind();
            if (node.condition() == CanonicalCondition.BT) {
                Runtime.UnsignedIClI32.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)lOp), Emitter.of((ValueNode)rOp)});
            } else {
                this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
                if (node.unorderedIsTrue()) {
                    this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
                }
                this.lowerValue(node.getX());
                this.codeGenTool.genCondition(node.condition());
                this.lowerValue(node.getY());
                this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
                if (node.unorderedIsTrue()) {
                    this.codeGenTool.getCodeBuffer().emitText("||");
                    this.codeGenTool.getCodeBuffer().emitText("isNaN");
                    this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
                    this.lowerValue(node.getX());
                    this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
                    this.codeGenTool.getCodeBuffer().emitText("||");
                    this.codeGenTool.getCodeBuffer().emitText("isNaN");
                    this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
                    this.lowerValue(node.getY());
                    this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
                    this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
                }
            }
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(DeadEndNode node) {
        this.codeGenTool.genShouldNotReachHere("Dead End");
    }

    protected void lowerLoweredDeadEndNode() {
        this.codeGenTool.genShouldNotReachHere("Lowered Dead End");
    }

    protected void lower(ShiftNode<?> node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        if (node.getStackKind() == JavaKind.Long) {
            Long64Lowerer.genBinaryArithmeticOperation(node, node.getX(), node.getY(), this.codeGenTool);
        } else if (node instanceof LeftShiftNode) {
            BinaryIntOperationLowerer.binaryOp(node, node.getX(), node.getY(), this.codeGenTool, JSKeyword.SL, true);
        } else if (node instanceof RightShiftNode) {
            BinaryIntOperationLowerer.binaryOp(node, node.getX(), node.getY(), this.codeGenTool, JSKeyword.SR, true);
        } else if (node instanceof UnsignedRightShiftNode) {
            BinaryIntOperationLowerer.binaryOp(node, node.getX(), node.getY(), this.codeGenTool, JSKeyword.USR, true);
        } else {
            throw GraalError.unimplemented((String)node.toString());
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(SignExtendNode node) {
        Object emitter;
        int inputBits = node.getInputBits();
        int resultBits = node.getResultBits();
        if (inputBits < 32) {
            ArrayList<Emitter> snippetArgs = new ArrayList<Emitter>();
            snippetArgs.add(Emitter.of((ValueNode)node.getValue()));
            snippetArgs.add(Emitter.of((Integer)inputBits));
            snippetArgs.add(Emitter.of((Integer)inputBits));
            emitter = JSSnippets.instantiateSignExtendSnippet(snippetArgs);
        } else {
            emitter = Emitter.of((ValueNode)node.getValue());
        }
        if (resultBits == 64) {
            Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, (IEmitter)emitter, this.codeGenTool);
        } else {
            emitter.lower((CodeGenTool)this.codeGenTool);
        }
    }

    protected void lower(ZeroExtendNode node) {
        CodeBuffer masm = this.codeGenTool.getCodeBuffer();
        int inputBits = node.getInputBits();
        int resultBits = node.getResultBits();
        assert (inputBits == 1 || inputBits == 8 || inputBits == 16 || inputBits == 32) : inputBits;
        Emitter emitter = inputBits < 32 ? Emitter.of((Emitter[])new Emitter[]{Emitter.of((ValueNode)node.getValue()), Emitter.of((String)(" & " + CodeUtil.mask((int)inputBits)))}) : Emitter.of((ValueNode)node.getValue());
        if (resultBits < 64) {
            masm.emitKeyword((Keyword)JSKeyword.LPAR);
            emitter.lower((CodeGenTool)this.codeGenTool);
            masm.emitKeyword((Keyword)JSKeyword.RPAR);
        } else {
            this.codeGenTool.genInlineComment("Zero Extend to 64 bit");
            Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, (IEmitter)emitter, this.codeGenTool);
        }
    }

    protected void lower(NarrowNode node) {
        int inbits = node.getInputBits();
        int outbits = node.getResultBits();
        this.codeGenTool.genInlineComment(String.format("Narrow Additional Info inbits:%d outbits:%d", inbits, outbits));
        JVMCIError.guarantee((inbits > outbits ? 1 : 0) != 0, (String)"Narrow node must decrease bit size %s, inbits:%d,outbits:%d", (Object[])new Object[]{node.toString(), inbits, outbits});
        if (inbits == 64) {
            JVMCIError.guarantee((outbits <= 32 ? 1 : 0) != 0, (String)"Narrow from Long must decrease bit size %s", (Object[])new Object[]{node.toString()});
            Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, node.getValue(), this.codeGenTool);
        } else {
            this.lowerValue(node.getValue());
        }
    }

    protected void lower(NotNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        ValueNode input = node.getValue();
        if (input.getStackKind() == JavaKind.Long) {
            Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, node.getValue(), this.codeGenTool);
        } else {
            JSEmitter emitter = JSEmitter.of(t -> t.genUnaryOperation(JSKeyword.NOT, input));
            emitter = JSEmitter.intPaladin(emitter);
            emitter.lower(this.codeGenTool);
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(SignumNode node) {
        Runtime.MATH_SIGN.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
    }

    protected void lower(NewInstanceNode node) {
        this.codeGenTool.genNewInstance(node.instanceClass());
    }

    protected void lower(DynamicNewInstanceNode node) {
        this.codeGenTool.genObjectCreate(t -> this.codeGenTool.genPropertyBracketAccessWithExpression((IEmitter)Emitter.of((ValueNode)node.getInstanceType()), (IEmitter)Emitter.of((String)RuntimeConstants.JS_CLASS_SYMBOL)), new IEmitter[0]);
    }

    protected void lower(LoadFieldNode node) {
        Emitter receiver = node.isStatic() ? Emitter.of((ResolvedJavaType)node.field().getDeclaringClass()) : Emitter.of((ValueNode)node.object());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.codeGenTool.genPropertyAccess((IEmitter)receiver, (IEmitter)Emitter.of((ResolvedJavaField)node.field()));
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(UnboxNode node) {
        HostedMetaAccess metaAccess = (HostedMetaAccess)this.codeGenTool.getProviders().getMetaAccess();
        Class boxing = node.getBoxingKind().toBoxedJavaClass();
        ResolvedJavaField valueField = AbstractBoxingNode.getValueField((ResolvedJavaType)metaAccess.lookupJavaType(boxing));
        this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ValueNode)node.getValue()), (IEmitter)Emitter.of((ResolvedJavaField)valueField));
    }

    protected void lower(ReinterpretNode node) {
        MetaAccessProvider metaAcces = this.codeGenTool.getProviders().getMetaAccess();
        HostedType toType = (HostedType)node.stamp(NodeView.DEFAULT).javaType(metaAcces);
        HostedType fromType = (HostedType)node.getValue().stamp(NodeView.DEFAULT).javaType(metaAcces);
        if (fromType.getJavaKind() == JavaKind.Long && toType.getJavaKind() == JavaKind.Double) {
            Runtime.LONG_BITS_TO_DOUBLE.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
        } else if (fromType.getJavaKind() == JavaKind.Double && toType.getJavaKind() == JavaKind.Long) {
            Runtime.DOUBLE_BITS_TO_LONG.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
        } else if (toType.getJavaKind() == JavaKind.Object || fromType.getJavaKind() == JavaKind.Object) {
            JVMCIError.shouldNotReachHere((String)"Cannot build javascript object from a binary base");
        } else if (fromType.getJavaKind() == JavaKind.Float && toType.getJavaKind() == JavaKind.Int) {
            Runtime.FLOAT_BITS_TO_INT.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
        } else if (fromType.getJavaKind() == JavaKind.Int && toType.getJavaKind() == JavaKind.Float) {
            Runtime.INT_BITS_TO_FLOAT.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
        } else {
            throw JVMCIError.unimplemented((String)("General reinterpretation not implemented currently from:" + String.valueOf(fromType) + " TO:" + String.valueOf(toType)));
        }
    }

    protected void lower(StoreFieldNode node) {
        ResolvedJavaField f = node.field();
        Emitter receiver = node.isStatic() ? Emitter.of((ResolvedJavaType)f.getDeclaringClass()) : Emitter.of((ValueNode)node.object());
        this.codeGenTool.genPropertyAccess((IEmitter)receiver, (IEmitter)Emitter.of((ResolvedJavaField)f));
        this.codeGenTool.genAssignment();
        this.lowerValue(node.value());
    }

    protected void lower(ShortCircuitOrNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        if (node.isXNegated()) {
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
            this.codeGenTool.getCodeBuffer().emitText("!");
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
            this.lowerValue((ValueNode)node.getX());
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        } else {
            this.lowerValue((ValueNode)node.getX());
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.SHORT_CIRCUITE_OR);
        if (node.isYNegated()) {
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
            this.codeGenTool.getCodeBuffer().emitText("!");
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
            this.lowerValue((ValueNode)node.getY());
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
            this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        } else {
            this.lowerValue((ValueNode)node.getY());
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(LogicNegationNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.codeGenTool.genUnaryOperation(JSKeyword.LOGIC_NOT, (ValueNode)node.getValue());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(WordCastNode node) {
        this.lowerValue(node.getInput());
    }

    protected void lower(FloatingWordCastNode node) {
        this.lowerValue(node.getInput());
    }

    protected void lower(InstanceOfNode node) {
        CodeBuffer masm = this.codeGenTool.getCodeBuffer();
        WebImageTypeControl typeControl = this.codeGenTool.getJSProviders().typeControl();
        TypeReference typeReference = node.type();
        boolean isExact = typeReference.isExact();
        HostedType checkType = (HostedType)typeReference.getType();
        GraalError.guarantee((!checkType.isPrimitive() ? 1 : 0) != 0, (String)"instanceof primitive");
        if (isExact || checkType.isInterface() || checkType.isArray()) {
            String targetHubName = typeControl.requestHubName((ResolvedJavaType)checkType);
            JSFunctionDefinition typeCheckFunction = isExact ? Runtime.isExact : Runtime.isA;
            typeCheckFunction.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((Boolean)node.allowsNull()), Emitter.of((ValueNode)node.getValue()), Emitter.of((String)targetHubName)});
        } else {
            if (node.allowsNull()) {
                masm.emitText("(");
                this.lowerValue(node.getValue());
                masm.emitText(" === null || ");
            }
            this.lowerValue(node.getValue());
            masm.emitText(" instanceof ");
            this.codeGenTool.genTypeName((ResolvedJavaType)checkType);
            if (node.allowsNull()) {
                masm.emitText(")");
            }
        }
    }

    protected void lower(InstanceOfDynamicNode node) {
        JSFunctionDefinition typeCheckFunction = node.isExact() ? Runtime.isExact : Runtime.isA;
        typeCheckFunction.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((Boolean)node.allowsNull()), Emitter.of((ValueNode)node.getObject()), Emitter.of((ValueNode)node.getMirrorOrHub())});
    }

    protected void lower(ArrayEqualsNode node) {
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        args.add(node.getArray1());
        args.add(node.getArray2());
        args.add(node.getLength());
        if (node.getStackKind() == JavaKind.Long) {
            Runtime.ARRAY_EQUALS_LONG.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
        } else {
            Runtime.ARRAY_EQUALS.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
        }
    }

    protected void lower(ArrayFillNode node) {
        throw VMError.unimplemented((String)("ArrayFillNode: " + String.valueOf(node)));
    }

    protected void lower(NewMultiArrayNode node) {
        HostedArrayClass arrayClass = (HostedArrayClass)node.type();
        assert (arrayClass.getArrayDimension() > 1) : "Dim 1 is no array depth";
        String hubName = this.codeGenTool.getJSProviders().typeControl().requestHubName((ResolvedJavaType)arrayClass);
        ArrayList<IEmitter> args = new ArrayList<IEmitter>(node.dimensionCount() + 1);
        args.add((IEmitter)Emitter.of((String)hubName));
        for (ValueNode dim : node.dimensions()) {
            args.add((IEmitter)Emitter.of((ValueNode)dim));
        }
        Runtime.NEW_MULTI_ARRAY.emitCall((CodeGenTool)this.codeGenTool, args);
    }

    protected void lower(ObjectClone node) {
        Runtime.CloneRuntime.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getObject())});
    }

    protected void lower(LoadHubNode node) {
        this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ValueNode)node.getValue()), (IEmitter)Emitter.of((String)"hub"));
    }

    protected void lower(LoadArrayComponentHubNode node) {
        try {
            ResolvedJavaField f = this.codeGenTool.getProviders().getMetaAccess().lookupJavaField(DynamicHub.class.getDeclaredField("componentType"));
            this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ValueNode)node.getValue()), (IEmitter)Emitter.of((ResolvedJavaField)f));
        }
        catch (NoSuchFieldException t) {
            throw GraalError.shouldNotReachHere((Throwable)t);
        }
    }

    protected void lower(EndNode node) {
        new PhiResolveLowerer((AbstractEndNode)node).lower((CodeGenTool)this.codeGenTool);
    }

    protected void lower(StateSplitProxyNode node) {
        if (node.object() != null) {
            this.lowerValue(node.object());
        }
    }

    protected void lower(DeoptimizeNode node) {
        this.codeGenTool.genShouldNotReachHere("Deoptimize node " + String.valueOf(node.getReason()));
    }

    protected void lower(JSCallNode node) {
        node.getFunctionDefinition().emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(node.getArguments()));
    }

    protected void lower(JavaReadNode node) {
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        if (node.getAddress() instanceof AMD64AddressNode) {
            args.add(node.getAddress().getBase());
            args.add(node.getAddress().getIndex());
        } else if (node.getAddress() instanceof OffsetAddressNode) {
            args.add(node.getAddress().getBase());
            args.add(((OffsetAddressNode)node.getAddress()).getOffset());
        } else {
            JVMCIError.shouldNotReachHere();
        }
        Runtime.UNSAFE_LOAD_RUNTIME.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
    }

    protected void lower(JavaWriteNode node) {
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        if (node.getAddress() instanceof AMD64AddressNode) {
            args.add(node.getAddress().getBase());
            args.add(node.getAddress().getIndex());
        } else if (node.getAddress() instanceof OffsetAddressNode) {
            args.add(node.getAddress().getBase());
            args.add(((OffsetAddressNode)node.getAddress()).getOffset());
        } else {
            throw JVMCIError.shouldNotReachHere((String)("node: " + String.valueOf(node.getAddress())));
        }
        args.add(node.value());
        Runtime.UNSAFE_STORE_RUNTIME.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
    }

    protected void lower(ReadNode node) {
        AddressNode location = node.getAddress();
        CodeBuffer masm = this.codeGenTool.getCodeBuffer();
        if (location instanceof AMD64AddressNode) {
            ValueNode object = location.getBase();
            HostedType objectType = (HostedType)object.stamp(NodeView.DEFAULT).javaType(this.codeGenTool.getProviders().getMetaAccess());
            if (objectType.isArray()) {
                this.codeGenTool.genArrayLoad((ValueNode)location, object);
            } else {
                this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ValueNode)object), (IEmitter)Emitter.of((String)"constructor[CM].ft"));
                masm.emitKeyword((Keyword)JSKeyword.LBRACK);
                this.lowerValue((ValueNode)location);
                masm.emitKeyword((Keyword)JSKeyword.RBRACK);
                masm.emitKeyword((Keyword)JSKeyword.LPAR);
                this.lowerValue(object);
                masm.emitKeyword((Keyword)JSKeyword.RPAR);
            }
        } else if (location instanceof OffsetAddressNode) {
            OffsetAddressNode address = (OffsetAddressNode)node.getAddress();
            Emitter base = Emitter.of((ValueNode)node.getAddress().getBase());
            Emitter offset = Emitter.of((ValueNode)address.getOffset());
            MetaAccessProvider metaAccess = this.codeGenTool.getProviders().getMetaAccess();
            JavaKind kind = node.getAccessStamp(NodeView.DEFAULT).javaType(metaAccess).getJavaKind();
            Emitter type = Emitter.of((Integer)JSBootImageHeapLowerer.getKindNum(kind));
            Runtime.UNSAFE_LOAD_RUNTIME.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{base, offset, type});
        } else {
            JVMCIError.shouldNotReachHere((String)("Method " + location.graph().method().toString() + " contains node " + String.valueOf(location)));
        }
    }

    protected void lower(RawLoadNode node) {
        Emitter obj = Emitter.of((ValueNode)node.object());
        Emitter offset = Emitter.of((ValueNode)node.offset());
        Emitter type = Emitter.of((Integer)JSBootImageHeapLowerer.getKindNum(node.accessKind()));
        Runtime.UNSAFE_LOAD_RUNTIME.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{obj, offset, type});
    }

    protected void lower(RawStoreNode node) {
        Emitter obj = Emitter.of((ValueNode)node.object());
        Emitter offset = Emitter.of((ValueNode)node.offset());
        Emitter value = Emitter.of((ValueNode)node.value());
        Emitter type = Emitter.of((Integer)JSBootImageHeapLowerer.getKindNum(node.accessKind()));
        Runtime.UNSAFE_STORE_RUNTIME.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{obj, offset, value, type});
    }

    protected void lower(AbstractUnsafeCompareAndSwapNode node) {
        Emitter obj = Emitter.of((ValueNode)node.object());
        Emitter offset = Emitter.of((ValueNode)node.offset());
        Emitter expected = Emitter.of((ValueNode)node.expected());
        Emitter newValue = Emitter.of((ValueNode)node.newValue());
        Emitter type = Emitter.of((Integer)JSBootImageHeapLowerer.getKindNum(node.getValueKind()));
        AbstractUnsafeCompareAndSwapNode abstractUnsafeCompareAndSwapNode = node;
        Objects.requireNonNull(abstractUnsafeCompareAndSwapNode);
        AbstractUnsafeCompareAndSwapNode abstractUnsafeCompareAndSwapNode2 = abstractUnsafeCompareAndSwapNode;
        int n = 0;
        JSFunctionDefinition func = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnsafeCompareAndSwapNode.class, UnsafeCompareAndExchangeNode.class}, (Object)abstractUnsafeCompareAndSwapNode2, n)) {
            case 0 -> {
                UnsafeCompareAndSwapNode n = (UnsafeCompareAndSwapNode)abstractUnsafeCompareAndSwapNode2;
                yield Runtime.CAS;
            }
            case 1 -> {
                UnsafeCompareAndExchangeNode n = (UnsafeCompareAndExchangeNode)abstractUnsafeCompareAndSwapNode2;
                yield Runtime.CAX;
            }
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)node);
        };
        func.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{obj, offset, expected, newValue, type});
    }

    protected void lower(AtomicReadAndWriteNode node) {
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        args.add(node.object());
        args.add(node.offset());
        args.add(node.newValue());
        Runtime.ATOMIC_READ_AND_WRITE.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
    }

    protected void lower(AtomicReadAndAddNode node) {
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        args.add(node.object());
        args.add(node.offset());
        args.add(node.delta());
        Runtime.ATOMIC_READ_AND_ADD.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
    }

    protected void lower(DynamicNewArrayNode node) {
        Array.lowerNewArray(node.getElementType(), (IEmitter)Emitter.of((ValueNode)node.length()), this.codeGenTool);
    }

    protected void lower(ObjectIsArrayNode node) {
        Runtime.IsArray.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
    }

    protected void lower(CompoundConditionNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue((ValueNode)node.getX());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        if (node.getOp() == CompoundConditionNode.CompoundOp.XaaY) {
            this.codeGenTool.getCodeBuffer().emitText("&&");
        } else if (node.getOp() == CompoundConditionNode.CompoundOp.XooY) {
            this.codeGenTool.getCodeBuffer().emitText("||");
        } else {
            JVMCIError.shouldNotReachHere();
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue((ValueNode)node.getY());
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(IntegerDivRemNode node) {
        assert (!(node instanceof UnsignedDivNode) && !(node instanceof UnsignedRemNode)) : node;
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.LPAR);
        if (node.getStackKind() == JavaKind.Long) {
            Long64Lowerer.genBinaryArithmeticOperation((ValueNode)node, node.getX(), node.getY(), this.codeGenTool);
        } else {
            BinaryIntOperationLowerer.binaryOp((ValueNode)node, node.getX(), node.getY(), this.codeGenTool, node.getOp() == IntegerDivRemNode.Op.DIV ? JSKeyword.DIV : JSKeyword.MOD, true);
        }
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(BinaryArithmeticNode<?> node) {
        switch (node.getStackKind()) {
            case Int: {
                BinaryIntOperationLowerer.binaryOp(node, node.getX(), node.getY(), this.codeGenTool, WebImageJSNodeLowerer.getSymbolForBinaryArithmeticOp(node), true);
                break;
            }
            case Long: {
                Long64Lowerer.genBinaryArithmeticOperation(node, node.getX(), node.getY(), this.codeGenTool);
                break;
            }
            case Float: 
            case Double: {
                BinaryFloatOperationLowerer.doop(this.codeGenTool, WebImageJSNodeLowerer.getSymbolForBinaryArithmeticOp(node), node);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)node.getStackKind());
            }
        }
    }

    private static JSKeyword getSymbolForBinaryArithmeticOp(BinaryArithmeticNode<?> node) {
        if (node instanceof AndNode) {
            return JSKeyword.AND;
        }
        if (node instanceof OrNode) {
            return JSKeyword.OR;
        }
        if (node instanceof XorNode) {
            return JSKeyword.XOR;
        }
        if (node instanceof AddNode) {
            return JSKeyword.ADD;
        }
        if (node instanceof SubNode) {
            return JSKeyword.SUB;
        }
        if (node instanceof MulNode) {
            return JSKeyword.MUL;
        }
        if (node instanceof FloatDivNode || node instanceof SignedFloatingIntegerDivNode) {
            return JSKeyword.DIV;
        }
        if (node instanceof RemNode || node instanceof SignedFloatingIntegerRemNode) {
            return JSKeyword.MOD;
        }
        throw GraalError.shouldNotReachHere((String)("Unexpected binary arithmetic node " + String.valueOf(node)));
    }

    protected void lower(GetClassNode node) {
        this.codeGenTool.genPropertyAccess((IEmitter)Emitter.of((ValueNode)node.getObject()), (IEmitter)Emitter.of((String)"hub"));
    }

    protected void lower(UnaryMathIntrinsicNode node) {
        (switch (node.getOperation()) {
            case UnaryMathIntrinsicNode.UnaryOperation.COS -> Runtime.MATH_COS;
            case UnaryMathIntrinsicNode.UnaryOperation.LOG -> Runtime.MATH_LOG;
            case UnaryMathIntrinsicNode.UnaryOperation.LOG10 -> Runtime.MATH_LOG10;
            case UnaryMathIntrinsicNode.UnaryOperation.SIN -> Runtime.MATH_SIN;
            case UnaryMathIntrinsicNode.UnaryOperation.TAN -> Runtime.MATH_TAN;
            case UnaryMathIntrinsicNode.UnaryOperation.EXP -> Runtime.MATH_EXP;
            default -> throw JVMCIError.shouldNotReachHere((String)("Uknown operation " + String.valueOf(node.getOperation())));
        }).emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
    }

    protected void lower(BinaryMathIntrinsicNode node) {
        switch (node.getOperation()) {
            case POW: {
                JSSystemFunction strictMathPow = JSCallNode.STRICT_MATH_POW;
                strictMathPow.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getX()), Emitter.of((ValueNode)node.getY())});
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)("Uknown operation " + String.valueOf(node.getOperation())));
            }
        }
    }

    protected void lower(AbsNode node) {
        switch (node.getStackKind()) {
            case Long: {
                Long64Lowerer.genUnaryArithmeticOperation((UnaryNode)node, node.getValue(), this.codeGenTool);
                break;
            }
            default: {
                Runtime.MATH_ABS.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
            }
        }
    }

    protected void lower(SqrtNode node) {
        Runtime.MATH_SQRT.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
    }

    protected void lower(RoundNode node) {
        (switch (node.mode()) {
            case ArithmeticLIRGeneratorTool.RoundingMode.NEAREST -> throw JVMCIError.shouldNotReachHere((String)"RoundNode mode round to nearest is not supported");
            case ArithmeticLIRGeneratorTool.RoundingMode.TRUNCATE -> Runtime.MATH_TRUNC;
            case ArithmeticLIRGeneratorTool.RoundingMode.DOWN -> Runtime.MATH_FLOOR;
            case ArithmeticLIRGeneratorTool.RoundingMode.UP -> Runtime.MATH_CEIL;
            default -> throw JVMCIError.shouldNotReachHere((String)("Unknown round mode " + String.valueOf(node.mode())));
        }).emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getValue())});
    }

    protected void lower(BytecodeExceptionNode node) {
        this.lowerBytecodeException(node.getExceptionKind(), (List<ValueNode>)node.getArguments());
    }

    protected void lower(ThrowBytecodeExceptionNode node) {
        this.codeGenTool.getCodeBuffer().emitKeyword((Keyword)JSKeyword.THROW);
        this.codeGenTool.getCodeBuffer().emitWhiteSpace();
        this.lowerBytecodeException(node.getExceptionKind(), (List<ValueNode>)node.getArguments());
    }

    protected void lowerBytecodeException(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, List<ValueNode> args) {
        HostedType exceptionsType = (HostedType)this.codeGenTool.getProviders().getMetaAccess().lookupJavaType(ImplicitExceptions.class);
        HostedMethod meth = WebImageProviders.findMethod(exceptionsType, WebImageImplicitExceptionsFeature.getSupportMethodName(exceptionKind));
        this.codeGenTool.genStaticCall((ResolvedJavaMethod)meth, (IEmitter[])Emitter.of(args));
    }

    protected void lower(JSBody node) {
        CodeBuffer masm = this.codeGenTool.getCodeBuffer();
        ResolvedJavaType declaring = node.getMethod().getDeclaringClass();
        masm.emitKeyword((Keyword)JSKeyword.LPAR);
        if (node.declaresJSResources()) {
            masm.emitText("function(){");
            this.codeGenTool.genInitJsResources(declaring);
            masm.emitText("}(), ");
        }
        JSBody.JSCode jsCode = node.getJsCode();
        String realBody = node.getJSCodeAsString(this.codeGenTool);
        masm.emitKeyword((Keyword)JSKeyword.LPAR);
        masm.emitKeyword((Keyword)JSKeyword.FUNCTION);
        masm.emitKeyword((Keyword)JSKeyword.LPAR);
        this.codeGenTool.genCommaList(Arrays.stream(jsCode.getArgs()).map(Emitter::of).collect(Collectors.toList()));
        masm.emitKeyword((Keyword)JSKeyword.RPAR);
        masm.emitScopeBegin();
        for (String line : realBody.split("\n")) {
            masm.emitText(line);
            masm.emitNewLine();
        }
        masm.emitScopeEnd();
        masm.emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeGenTool.genFunctionCall((IEmitter)Emitter.of((String)""), (IEmitter)Emitter.of((String)"call"), (IEmitter[])Emitter.of(node.getArguments()));
        masm.emitKeyword((Keyword)JSKeyword.RPAR);
    }

    protected void lower(UnsafeMemoryStoreNode node) {
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        args.add(node.getAddress());
        args.add(node.getValue());
        JSFunctionDefinition write = switch (node.getKind()) {
            case JavaKind.Boolean, JavaKind.Byte -> Runtime.WRITE_BYTE;
            case JavaKind.Char -> Runtime.WRITE_CHAR;
            case JavaKind.Short -> Runtime.WRITE_SHORT;
            case JavaKind.Int -> Runtime.WRITE_INT;
            case JavaKind.Float -> Runtime.WRITE_FLOAT;
            case JavaKind.Long -> Runtime.WRITE_LONG;
            case JavaKind.Double -> Runtime.WRITE_DOUBLE;
            default -> throw GraalError.shouldNotReachHere((String)("Unsafe store not possible for kind: " + String.valueOf(node.getKind())));
        };
        write.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
    }

    protected void lower(UnsafeMemoryLoadNode node) {
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        args.add(node.getAddress());
        JSFunctionDefinition read = switch (node.getKind()) {
            case JavaKind.Boolean, JavaKind.Byte -> Runtime.READ_BYTE;
            case JavaKind.Char -> Runtime.READ_CHAR;
            case JavaKind.Short -> Runtime.READ_SHORT;
            case JavaKind.Int -> Runtime.READ_INT;
            case JavaKind.Float -> Runtime.READ_FLOAT;
            case JavaKind.Long -> Runtime.READ_LONG;
            case JavaKind.Double -> Runtime.READ_DOUBLE;
            default -> throw GraalError.shouldNotReachHere((String)("Unsafe load not possible for kind: " + String.valueOf(node.getKind())));
        };
        read.emitCall((CodeGenTool)this.codeGenTool, (IEmitter[])Emitter.of(args));
    }

    protected void lower(BlackholeNode node) {
    }

    protected void lower(ReachabilityFenceNode node) {
    }

    protected void lower(ForeignCall node) {
        ForeignCallDescriptor descriptor = node.getDescriptor();
        if (descriptor == SnippetRuntime.UNSUPPORTED_FEATURE) {
            this.codeGenTool.genShouldNotReachHere("unsupportedFeature");
        } else {
            SnippetRuntime.SubstrateForeignCallDescriptor substrateDescriptor = (SnippetRuntime.SubstrateForeignCallDescriptor)descriptor;
            ResolvedJavaMethod method = substrateDescriptor.findMethod(this.codeGenTool.getProviders().getMetaAccess());
            if (method.isStatic()) {
                this.codeGenTool.genStaticCall(method, (IEmitter[])Emitter.of((List)node.getArguments()));
            } else {
                throw GraalError.unimplemented((String)("ForeignCallNode for non-static methods not implemented: " + String.valueOf(node)));
            }
        }
    }

    protected void lower(ClassIsAssignableFromNode node) {
        Runtime.slotTypeCheck.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((ValueNode)node.getThisClass()), Emitter.of((ValueNode)node.getOtherClass())});
    }

    private void lower(StaticFieldsSupport.StaticFieldResolvedBaseNode node) {
        boolean primitive = node.primitive;
        WebImageJSProviders providers = this.codeGenTool.getJSProviders();
        JavaConstant constant = providers.getSnippetReflection().forObject(primitive ? StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields() : StaticFieldsSupport.getCurrentLayerStaticObjectFields());
        ConstantNode constantNode = ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)providers.getMetaAccess());
        this.lower(constantNode);
    }

    public boolean isActiveValueNode(ValueNode node) {
        return this.actualUsageCount((Node)node) > 0 && !(node instanceof EndNode) && !this.isIgnored((Node)node);
    }

    public NodeIterable<Node> actualUsages(ValueNode node) {
        return node.usages().filter((NodePredicate)NodePredicates.isNotA(FrameState.class));
    }

    public boolean isTopLevelStatement(Node node) {
        return !this.isIgnored(node) && !(node instanceof OffsetAddressNode) && !(node instanceof AMD64AddressNode) && (this.actualUsageCount(node) == 0 || this.codeGenTool.declared(node) || node instanceof EndNode);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static void lowerConstant(PrimitiveConstant c, JSCodeGenTool jsLTools) {
        switch (c.getJavaKind()) {
            case Int: 
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: {
                jsLTools.getCodeBuffer().emitIntLiteral(c.asInt());
                return;
            }
            case Long: {
                Long64Lowerer.lowerFromConstant((Constant)c, jsLTools);
                return;
            }
            case Float: {
                jsLTools.getCodeBuffer().emitText(ObjectInspector.ValueType.floatWithSpecialCases(c.asFloat()));
                return;
            }
            case Double: {
                jsLTools.getCodeBuffer().emitText(ObjectInspector.ValueType.doubleWithSpecialCases(c.asDouble()));
                return;
            }
        }
        JVMCIError.shouldNotReachHere();
    }

    public static String getStringLiteral(String s) {
        StringBuilder sb = new StringBuilder();
        boolean useDoubleQuotes = s.contains("'");
        sb.append(useDoubleQuotes ? (char)'\"' : '\'');
        block11: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\0");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\"': {
                    if (useDoubleQuotes) {
                        sb.append("\\\"");
                        continue block11;
                    }
                    sb.append('\"');
                    continue block11;
                }
                case '\'': {
                    if (useDoubleQuotes) {
                        sb.append('\'');
                        continue block11;
                    }
                    sb.append("\\'");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                default: {
                    if (c <= '\u001f' || c == '\u007f') {
                        sb.append("\\x");
                        String hex = Integer.toHexString(c);
                        if (hex.length() == 1) {
                            sb.append("0");
                        }
                        sb.append(hex);
                        continue block11;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append(useDoubleQuotes ? (char)'\"' : '\'');
        return sb.toString();
    }

    public String nodeDebugInfo(Node node) {
        boolean isValueNode = node instanceof ValueNode;
        return String.valueOf(node) + ", inlineable = " + (isValueNode && !this.codeGenTool.getVariableAllocation().needsVariable((ValueNode)node, (CodeGenTool)this.codeGenTool)) + (String)(isValueNode ? ", safe inlining = " + String.valueOf(this.codeGenTool.getVariableAllocation().getSafeInliningPolicies((ValueNode)node, (CodeGenTool)this.codeGenTool)) : "") + ", declared = " + this.codeGenTool.declared(node) + ", isValue = " + (isValueNode && this.isActiveValueNode((ValueNode)node)) + ", ignored = " + this.isIgnored(node) + ", " + String.valueOf(node.usages()) + ", actual usage = " + this.actualUsageCount(node) + (String)(node instanceof FixedWithNextNode ? ", next = " + String.valueOf(((FixedWithNextNode)node).next()) : "");
    }
}

