/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.Array;
import com.oracle.svm.hosted.webimage.codegen.ClosureCompilerSupport;
import com.oracle.svm.hosted.webimage.codegen.JSIntrinsifyFile;
import com.oracle.svm.hosted.webimage.codegen.KnownHubMapLowerer;
import com.oracle.svm.hosted.webimage.codegen.LowerableResource;
import com.oracle.svm.hosted.webimage.codegen.LowerableResources;
import com.oracle.svm.hosted.webimage.codegen.Runtime;
import com.oracle.svm.hosted.webimage.codegen.RuntimeConstants;
import com.oracle.svm.hosted.webimage.codegen.RuntimeModificationLowerer;
import com.oracle.svm.hosted.webimage.codegen.WebImageCodeGen;
import com.oracle.svm.hosted.webimage.codegen.WebImageCompilationResult;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.hosted.webimage.codegen.compatibility.JSBenchmarkingCode;
import com.oracle.svm.hosted.webimage.codegen.compatibility.JSEntryPointCode;
import com.oracle.svm.hosted.webimage.codegen.heap.ConstantMap;
import com.oracle.svm.hosted.webimage.codegen.oop.ClassLowerer;
import com.oracle.svm.hosted.webimage.codegen.oop.ClassWithMirrorLowerer;
import com.oracle.svm.hosted.webimage.codegen.oop.StaticFieldLowerer;
import com.oracle.svm.hosted.webimage.codegen.type.TypeVtableLowerer;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.UniverseMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.snippets.JSSnippetWithEmitterSupport;
import com.oracle.svm.hosted.webimage.snippets.JSSnippets;
import com.oracle.svm.hosted.webimage.util.AnnotationUtil;
import com.oracle.svm.hosted.webimage.util.TypeControlGraphPrinter;
import com.oracle.svm.hosted.webimage.util.metrics.CodeSizeCollector;
import com.oracle.svm.hosted.webimage.util.metrics.ImageMetricsCollector;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.webimage.Labeler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.webimage.api.JS;
import org.graalvm.webimage.api.JSObject;

public class WebImageJSCodeGen
extends WebImageCodeGen {
    public static final String GenUniverseTimer = "(gen universe)";
    public static final String ClosureTimer = "closure";
    public static final String WriteTimer = "(write)";
    public static final String ClosureWhitespaceTimer = "(closure compiler whitespace)";
    private final WebImageTypeControl typeControl;
    protected final Map<HostedMethod, StructuredGraph> methodGraphs;
    private final ImageClassLoader imageClassLoader;

    public WebImageJSCodeGen(WebImageCodeCache codeCache, List<HostedMethod> hostedEntryPoints, HostedMethod mainEntryPoint, WebImageProviders providers, DebugContext debug, WebImageHostedConfiguration config, ImageClassLoader imageClassLoader) {
        super(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, config);
        this.typeControl = ((WebImageJSProviders)providers).typeControl();
        this.methodGraphs = this.compilations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((WebImageCompilationResult)((Object)((Object)e.getValue()))).getGraph()));
        this.imageClassLoader = imageClassLoader;
    }

    private static void lowerJavaScriptCode(CodeBuffer codeBuffer, String titleComment, InputStream is) {
        codeBuffer.emitText(titleComment);
        codeBuffer.emitNewLine();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        reader.lines().forEach(line -> {
            codeBuffer.emitText(line);
            codeBuffer.emitNewLine();
        });
        codeBuffer.emitNewLine();
    }

    private static int getMethodsSize() {
        String scopeName;
        if (WebImageProviders.isLabelInjectionEnabled()) {
            scopeName = "Closure-Compiler";
        } else if (!((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            scopeName = "Pre-Closure";
        } else {
            return 0;
        }
        LoggerContext currentContext = LoggerContext.currentContext();
        String qualifiedScopeName = LoggerContext.getQualifiedScopeName(currentContext.currentScope().getName(), scopeName);
        Map<String, Number> savedCounters = currentContext.getSavedCounters(qualifiedScopeName, ImageMetricsCollector.SAVED_SIZE_BREAKDOWN_KEYS);
        return savedCounters.get(ImageBreakdownMetricKeys.TOTAL_METHOD_SIZE.getName()).intValue();
    }

    @Override
    protected WebImageJSProviders getProviders() {
        return (WebImageJSProviders)super.getProviders();
    }

    @Override
    protected void emitCode() {
        this.emitJSCode();
    }

    @Override
    protected void postProcess() {
        if (((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            this.getProviders().stdout().println("Compiling with final closure compiler pass.....");
            try (Timer.StopTimer t = TimerCollection.createTimerAndStart((String)ClosureTimer);
                 ImageMetricsCollector.PostClosure tracker = new ImageMetricsCollector.PostClosure(this.methodMetricsCollector, this.labeler, this.codeBuffer);){
                this.codeBuffer.setCodeBytes(this.getClosureCompilerSupport().applyClosureCompiler(this.codeBuffer.getCode()).getBytes());
            }
        }
        this.codeBuffer.infoDump(this.getProviders());
        this.getProviders().stdout().println("----------------------------------------------------------");
        this.getProviders().stdout().println("Compiled methods class file method size[raw bytes]:" + JSCodeBuffer.bytesToString(this.compiledMethodBytes, true));
        this.getProviders().stdout().println("----------------------------------------------------------");
        LoggerContext.counter(UniverseMetricKeys.EMITTED_TYPES).add(this.typeControl.emittedTypes().size());
        this.codeCache.setCodeAreaSize(WebImageJSCodeGen.getMethodsSize());
    }

    protected String getClosureCompilerSupportClass() {
        return "com.oracle.svm.hosted.webimage.closurecompiler.ClosureCompilerSupportImpl";
    }

    private ClosureCompilerSupport getClosureCompilerSupport() {
        return ClosureCompilerSupport.getClosureSupport(this.getClosureCompilerSupportClass(), this.imageClassLoader.watchdog, this.codeGenTool, this.imageName);
    }

    protected Map<String, RuntimeConstants.ConstantDeclaration> getRuntimeConstants() {
        return RuntimeConstants.getConstantMap();
    }

    @Override
    protected void emitJSCode() {
        this.configuration.getJavaRelatedResources().stream().filter(LowerableResource::isRegistered).forEach(resource -> JSIntrinsifyFile.process(resource.getData(), this.getProviders()));
        if (((Boolean)WebImageOptions.UsePEA.getValue(this.options)).booleanValue()) {
            this.getProviders().stdout().println("Compiling with PEA.....");
        }
        super.emitJSCode();
    }

    @Override
    protected void emitPreamble() {
        if (((Boolean)WebImageOptions.GenerateSourceMap.getValue(this.options)).booleanValue()) {
            this.codeBuffer.emitText("//# sourceMappingURL=" + this.filename + ".map");
            this.codeBuffer.emitNewLine();
        }
    }

    @Override
    protected void emitBootstrapDefinitions() {
        this.configuration.getBootstrapResources().stream().filter(LowerableResource::isRegistered).forEach(resource -> JSIntrinsifyFile.process(resource.getData(), this.getProviders()));
        LowerableResources.lower(this.codeGenTool, LowerableResources.bootstrap);
        boolean isLittleEndianBuildTime = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
        Runtime.SET_ENDIANNESS_FUN.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((Boolean)isLittleEndianBuildTime)});
        this.codeGenTool.getCodeBuffer().emitInsEnd();
    }

    @Override
    protected void emitRuntimeDefinitions() {
        RuntimeConstants.lowerInitialDefinition(this.codeGenTool, this.getRuntimeConstants());
        LowerableResources.lower(this.codeGenTool, LowerableResources.runtime);
    }

    @Override
    protected void emitCompiledCode() {
        try (JSBenchmarkingCode.Timer t = this.benchmarkingCode.getTimer("Hosted Universe").start();
             Timer.StopTimer t1 = TimerCollection.createTimerAndStart((String)GenUniverseTimer);){
            this.lowerHostedUniverse();
        }
        KnownHubMapLowerer.classNameMapping(this.codeGenTool);
        t = this.benchmarkingCode.getTimer(ConstantMap.WEB_IMAGE_CONST_PROPERTY_INIT_F_NAME.getFunctionName()).start();
        try {
            ConstantMap.WEB_IMAGE_CONST_PROPERTY_INIT_F_NAME.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[0]);
            this.codeGenTool.genResolvedVarDeclPostfix(null);
            Runtime.INITIALIZE_JAVA_STRINGS.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[0]);
            this.codeGenTool.genResolvedVarDeclPostfix(null);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @Override
    protected void emitEntryPointCall() {
        JSEntryPointCode.ENTRY_POINT_FUN.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((String)"vmArgs")});
        this.codeBuffer.emitInsEnd();
    }

    @Override
    protected void emitJSCodeFiles() {
        HashSet<String> includedPaths = new HashSet<String>();
        this.codeBuffer.emitNewLine();
        for (HostedType type : this.getProviders().typeControl().emittedTypes()) {
            List<JS.Code.Include> includes = AnnotationUtil.getDeclaredAnnotationsByType((AnnotatedElement)type, JS.Code.Include.class, JS.Code.Include.Group.class, JS.Code.Include.Group::value);
            for (JS.Code.Include include : includes) {
                String path = include.value();
                if (includedPaths.contains(path)) continue;
                includedPaths.add(path);
                String titleComment = "// Source file: " + include.value().replace("\n", "").replace("\r", "");
                InputStream is = type.getJavaClass().getResourceAsStream(path);
                if (is == null) {
                    throw new RuntimeException("Resource not found: " + path);
                }
                WebImageJSCodeGen.lowerJavaScriptCode(this.codeBuffer, titleComment, is);
            }
            JS.Code code = (JS.Code)type.getDeclaredAnnotation(JS.Code.class);
            if (code == null) continue;
            String titleComment = "// Class file: " + type.getJavaClass().getName();
            WebImageJSCodeGen.lowerJavaScriptCode(this.codeBuffer, titleComment, new ByteArrayInputStream(code.value().getBytes(StandardCharsets.UTF_8)));
        }
        this.codeBuffer.emitText(";;");
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitNewLine();
    }

    private void registerTypes() {
        for (HostedMethod[] m : this.hostedEntryPoints) {
            this.typeControl.requestTypeName((ResolvedJavaType)m.getDeclaringClass());
        }
        if (((Boolean)WebImageOptions.UseVtable.getValue(this.options)).booleanValue()) {
            HostedType invalidVTableType = this.hMetaAccess.lookupJavaType(InvalidMethodPointerHandler.class);
            for (HostedMethod m : this.hUniverse.getType(JavaKind.Object).getVTable()) {
                if (!m.getDeclaringClass().equals(invalidVTableType)) continue;
                this.typeControl.requestTypeName((ResolvedJavaType)invalidVTableType);
            }
        }
        for (HostedType type : this.hUniverse.getTypes()) {
            if (type.isArray() || !type.getWrapped().isUnsafeAllocated()) continue;
            this.typeControl.requestTypeName((ResolvedJavaType)type);
        }
        HostedType jsObjectType = (HostedType)this.getProviders().getMetaAccess().lookupJavaType(JSObject.class);
        this.requestJSObjectSubclasses(jsObjectType);
    }

    private void requestJSObjectSubclasses(HostedType type) {
        if (type.getJavaClass().equals(JSObject.class) || type.getAnnotation(JS.Export.class) != null) {
            this.typeControl.requestTypeName((ResolvedJavaType)type);
        }
        for (HostedType subtype : type.getSubTypes()) {
            this.requestJSObjectSubclasses(subtype);
        }
    }

    private void lowerHostedUniverse() {
        HashMap<HostedType, HashMap<HostedField, Constant>> staticFields = new HashMap<HostedType, HashMap<HostedField, Constant>>();
        this.registerTypes();
        try (Labeler.Injection injection = this.labeler.injectMetricLabel(this.codeBuffer, ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE);){
            while (this.typeControl.hasNext()) {
                HostedType t = this.typeControl.next();
                JVMCIError.guarantee((!t.isArray() ? 1 : 0) != 0, (String)"Must only query non array types from the type control %s", (Object[])new Object[]{t.toString()});
                HashMap<HostedField, Constant> fieldMap = StaticFieldLowerer.registerLowering(t, this.getProviders());
                staticFields.put(t, fieldMap);
                this.lowerType(t);
            }
        }
        try (CodeSizeCollector collector = new CodeSizeCollector(ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE, () -> ((JSCodeBuffer)this.codeBuffer).codeSize());){
            if (((Boolean)WebImageOptions.UseVtable.getValue(this.options)).booleanValue()) {
                for (HostedType type : this.typeControl.emittedTypes()) {
                    new TypeVtableLowerer(type).lowerInitialDefinition(this.codeGenTool);
                }
            }
        }
        this.lowerExtraDefinitions();
        try (DebugContext.Scope s = this.debug.scope((Object)"Emitted-Types");){
            this.debug.log("");
            Collection<HostedType> emittedTypes = this.typeControl.queryEmittedTypes();
            Collection<HostedType> omittedTypes = this.typeControl.queryOmittedTypes();
            this.debug.log("* - Emitted Types size %s--------", emittedTypes.size());
            for (HostedType t : emittedTypes) {
                this.debug.log("\t* - %s", (Object)t.toJavaName());
            }
            this.debug.log("* - Omitted Types size %s--------", omittedTypes.size());
            for (HostedType t : omittedTypes) {
                this.debug.log("\t* - %s", (Object)t.toJavaName());
            }
            this.debug.log(System.lineSeparator());
        }
        JSEntryPointCode.lower(this.codeGenTool, this.mainEntryPoint);
        this.typeControl.postProcess(this.codeGenTool);
        collector = new CodeSizeCollector(ImageBreakdownMetricKeys.STATIC_FIELDS_SIZE, () -> ((JSCodeBuffer)this.codeBuffer).codeSize());
        try (Labeler.Injection injection = this.labeler.injectMetricLabel(this.codeBuffer, ImageBreakdownMetricKeys.STATIC_FIELDS_SIZE);){
            for (HostedType t : this.typeControl.queryEmittedTypes()) {
                if (t.isArray()) continue;
                new StaticFieldLowerer(t, (HashMap)staticFields.get(t)).lower(this.codeGenTool);
            }
        }
        finally {
            collector.close();
        }
        new RuntimeModificationLowerer().lower(this.codeGenTool);
        if (((Boolean)WebImageOptions.DebugOptions.DumpTypeControlGraph.getValue(this.options)).booleanValue()) {
            TypeControlGraphPrinter.print(this.typeControl, this.methodMetricsCollector, SubstrateOptions.reportsPath(), ReportUtils.extractImageName((String)this.imageName));
        }
    }

    protected void lowerExtraDefinitions() {
        try (JSBenchmarkingCode.Timer t = this.benchmarkingCode.getTimer("Extra Definitions").start();
             CodeSizeCollector sizeCollector = new CodeSizeCollector(ImageBreakdownMetricKeys.EXTRA_DEFINITIONS_SIZE, () -> ((JSCodeBuffer)this.codeBuffer).codeSize());
             Labeler.Injection injection = this.labeler.injectMetricLabel(this.codeBuffer, ImageBreakdownMetricKeys.EXTRA_DEFINITIONS_SIZE);){
            ResolvedJavaMethod stringCharConstructor = this.getProviders().getMetaAccess().lookupJavaMethod((Executable)ReflectionUtil.lookupConstructor(String.class, (Class[])new Class[]{char[].class}));
            JSSnippetWithEmitterSupport stringCharConstructorSnippet = JSSnippets.instantiateStringCharConstructor(Emitter.of((ResolvedJavaMethod)stringCharConstructor));
            this.codeGenTool.lower(stringCharConstructorSnippet);
            LowerableResources.lower(this.codeGenTool, LowerableResources.extra);
            LowerableResources.lower(this.codeGenTool, LowerableResources.thirdParty.toArray(new LowerableResource[0]));
            Array.lowerArrrayVTable(this.codeGenTool);
        }
    }

    private void lowerType(HostedType type) {
        ResolvedJavaType jsObjectType = this.getProviders().getMetaAccess().lookupJavaType(JSObject.class);
        ClassLowerer classLowerer = jsObjectType.isAssignableFrom((ResolvedJavaType)type) ? new ClassWithMirrorLowerer(this.options, this.debug, this.codeGenTool, this.methodGraphs, this.labeler, this.methodMetricsCollector, b -> this.compiledMethodBytes += b.intValue(), type) : new ClassLowerer(this.options, this.debug, this.codeGenTool, this.methodGraphs, this.labeler, this.methodMetricsCollector, b -> this.compiledMethodBytes += b.intValue(), type);
        classLowerer.lower(this.typeControl);
    }
}

