/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.webimage.functionintrinsics.ImplicitExceptions;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class WebImageImplicitExceptionsFeature
implements InternalFeature {
    private final HashMap<String, Method> methodsMap = WebImageImplicitExceptionsFeature.createMethodsMap(ImplicitExceptions.class);
    private final HashSet<Method> foundMethods = new HashSet();
    private final HashSet<AnalysisMethod> visitedMethods = new HashSet();

    private static HashMap<String, Method> createMethodsMap(Class<?> clazz) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method m : clazz.getDeclaredMethods()) {
            map.put(m.getName(), m);
        }
        return map;
    }

    private boolean isAllSupportMethodsReachable() {
        return this.foundMethods.size() == this.methodsMap.size();
    }

    public static String getSupportMethodName(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind) {
        return switch (exceptionKind) {
            case BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE -> "createNewArrayStoreExceptionWithArgs";
            case BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE -> "createNegativeArraySizeException";
            case BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST -> "createNewClassCastExceptionWithArgs";
            case BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO -> "createNewDivisionByZeroException";
            case BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW -> "createNewArithmeticException";
            case BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER -> "createNewNullPointerException";
            case BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS -> "createNewOutOfBoundsExceptionWithArgs";
            case BytecodeExceptionNode.BytecodeExceptionKind.INTRINSIC_OUT_OF_BOUNDS -> "createNewOutOfBoundsException";
            case BytecodeExceptionNode.BytecodeExceptionKind.INCOMPATIBLE_CLASS_CHANGE -> "createNewIncompatibleClassChangeError";
            case BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH -> "createNewNegativeLengthException";
            case BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY -> "createNewArgumentIsNotArrayException";
            case BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT -> "createNewAssertionErrorObject";
            case BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY -> "createNewAssertionErrorNullary";
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)exceptionKind);
        };
    }

    private Method resolveSupportMethod(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind) {
        return this.methodsMap.get(WebImageImplicitExceptionsFeature.getSupportMethodName(exceptionKind));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.foundMethods.clear();
        this.visitedMethods.clear();
        Method[] methods = new Method[]{this.methodsMap.get("checkNullPointer"), this.methodsMap.get("checkArrayBound")};
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        AnalysisMetaAccess meta = accessImpl.getMetaAccess();
        for (Method meth : methods) {
            AnalysisMethod aMethod = meta.lookupJavaMethod((Executable)meth);
            accessImpl.registerAsRoot(aMethod, true, "Web image runtime check outlining support, registered in " + String.valueOf(WebImageImplicitExceptionsFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.isAllSupportMethodsReachable()) {
            return;
        }
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        BigBang bigbang = accessImpl.getBigBang();
        AnalysisUniverse universe = bigbang.getUniverse();
        for (AnalysisMethod method : universe.getMethods()) {
            if (!method.isReachable() || this.visitedMethods.contains(method)) continue;
            this.visitedMethods.add(method);
            StructuredGraph graph = method.decodeAnalyzedGraph(DebugContext.forCurrentThread(), null);
            if (graph == null) continue;
            for (BytecodeExceptionNode node : graph.getNodes().filter(BytecodeExceptionNode.class)) {
                this.registerBytecodeException(accessImpl, node.getExceptionKind(), (List<ValueNode>)node.getArguments());
                if (!this.isAllSupportMethodsReachable()) continue;
                return;
            }
        }
    }

    private void registerBytecodeException(FeatureImpl.DuringAnalysisAccessImpl access, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, List<ValueNode> arguments) {
        Method supportMethod = this.resolveSupportMethod(exceptionKind);
        if (arguments.size() != supportMethod.getParameterCount()) {
            throw new GraalError("Unexpected number of arguments for %s. Expected %d, got %d", new Object[]{exceptionKind, supportMethod.getParameterCount(), arguments.size()});
        }
        AnalysisMethod aMethod = access.getMetaAccess().lookupJavaMethod((Executable)supportMethod);
        boolean newMethod = this.foundMethods.add(supportMethod);
        if (newMethod && !aMethod.isInvoked()) {
            access.registerAsRoot(aMethod, false, "Web image implicit exception support, registered in " + String.valueOf(WebImageImplicitExceptionsFeature.class), new MultiMethod.MultiMethodKey[0]);
            access.requireAnalysisIteration();
        }
    }
}

