/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.CodeSizeDiagnostics;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.LowerableResources;
import com.oracle.svm.hosted.webimage.codegen.NameSpaceHideLowerer;
import com.oracle.svm.hosted.webimage.codegen.WebImageCompilationResult;
import com.oracle.svm.hosted.webimage.codegen.WebImageEntryFunctionLowerer;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageVariableAllocation;
import com.oracle.svm.hosted.webimage.codegen.compatibility.JSBenchmarkingCode;
import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.MethodMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.UniverseMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.util.metrics.CodeSizeCollector;
import com.oracle.svm.hosted.webimage.util.metrics.ImageMetricsCollector;
import com.oracle.svm.hosted.webimage.util.metrics.MethodMetricsCollector;
import com.oracle.svm.webimage.Labeler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.MetricKey;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.collections.UnmodifiableEconomicMap;

public abstract class WebImageCodeGen {
    public static final String CODE_GEN_SCOPE_NAME = "Code-Generation";
    public static final String WebImageEmitTimer = "emit";
    protected static final boolean PRINT_OMITTED_TYPES = true;
    protected final OptionValues options;
    protected final JSCodeBuffer codeBuffer;
    protected final HostedUniverse hUniverse;
    protected final HostedMetaAccess hMetaAccess;
    private final WebImageProviders providers;
    protected final DebugContext debug;
    protected final String imageName;
    protected final String filename;
    protected final JSCodeGenTool codeGenTool;
    protected JSBenchmarkingCode benchmarkingCode;
    protected final MethodMetricsCollector methodMetricsCollector;
    protected final Labeler labeler;
    protected int compiledMethodBytes;
    protected final List<HostedMethod> hostedEntryPoints;
    protected final HostedMethod mainEntryPoint;
    protected final WebImageCodeCache codeCache;
    protected final Map<HostedMethod, WebImageCompilationResult> compilations;
    protected final WebImageHostedConfiguration configuration;

    protected WebImageCodeGen(WebImageCodeCache codeCache, List<HostedMethod> hostedEntryPoints, HostedMethod mainEntryPoint, WebImageProviders providers, DebugContext debug, WebImageHostedConfiguration config) {
        this.hMetaAccess = (HostedMetaAccess)providers.getMetaAccess();
        this.codeCache = codeCache;
        this.compilations = codeCache.webImageCompilationResults;
        this.hostedEntryPoints = hostedEntryPoints;
        this.mainEntryPoint = Objects.requireNonNull(mainEntryPoint);
        this.configuration = config;
        this.options = debug.getOptions();
        this.codeBuffer = config.createCodeBuffer(this.options);
        this.hUniverse = this.hMetaAccess.getUniverse();
        this.imageName = (String)SubstrateOptions.Name.getValue(this.options);
        this.filename = this.imageName + ".js";
        this.methodMetricsCollector = new MethodMetricsCollector(this.codeBuffer);
        this.providers = providers;
        this.labeler = providers.labeler();
        this.debug = debug;
        this.codeGenTool = new JSCodeGenTool(providers, this.codeBuffer, this.configuration, new WebImageVariableAllocation());
        CodeSizeDiagnostics.installMethodSizeProvider(method -> {
            try {
                return this.methodMetricsCollector.getMethodMetric((HostedMethod)method, MethodMetricKeys.METHOD_SIZE).intValue();
            }
            catch (NullPointerException ex) {
                return 0;
            }
        });
    }

    protected WebImageProviders getProviders() {
        return this.providers;
    }

    private void saveCodegenCounters(LoggerScope scope, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
        ArrayList<MetricKey> keys = new ArrayList<MetricKey>();
        this.addSavedCodegenCounters(keys);
        LoggerContext.currentContext().saveCounters(scope, keys.toArray(new MetricKey[0]));
    }

    protected void addSavedCodegenCounters(List<MetricKey> keys) {
        keys.add(UniverseMetricKeys.EMITTED_TYPES);
        keys.add(UniverseMetricKeys.EMITTED_METHODS);
        keys.addAll(ImageBreakdownMetricKeys.CONSTANT_SIZE_CLASSES);
    }

    public static WebImageCodeGen generateCode(WebImageCodeCache codeCache, List<HostedMethod> hostedEntryPoints, HostedMethod mainEntryPoint, WebImageProviders providers, DebugContext debug, WebImageHostedConfiguration config, ImageClassLoader imageClassLoader) {
        WebImageCodeGen codegen = config.createCodeGen(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, imageClassLoader);
        try (LoggerScope loggerScope = LoggerContext.currentContext().scope(CODE_GEN_SCOPE_NAME, codegen::saveCodegenCounters);){
            codegen.buildImage();
            WebImageCodeGen webImageCodeGen = codegen;
            return webImageCodeGen;
        }
    }

    protected void buildImage() {
        try (Timer.StopTimer t = TimerCollection.createTimerAndStart((String)WebImageEmitTimer);){
            this.emitCode();
        }
        this.postProcess();
    }

    protected abstract void emitCode();

    protected abstract void postProcess();

    protected void emitJSCode() {
        try (ImageMetricsCollector.PreClosure collector = new ImageMetricsCollector.PreClosure(this.codeBuffer);){
            this.doEmitJSFile();
        }
    }

    private void doEmitJSFile() {
        this.emitPreamble();
        this.codeBuffer.emitStringLiteral("use strict");
        this.codeBuffer.emitInsEnd();
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitText("/**");
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitText(" * @suppress {checkVars,checkTypes,duplicate}");
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitText(" * @nocollapse");
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitText("*/");
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitText("var " + this.codeGenTool.vmClassName() + " = {};");
        this.codeBuffer.emitNewLine();
        this.benchmarkingCode = new JSBenchmarkingCode(this.codeGenTool, this.options);
        this.benchmarkingCode.lowerInitialDefinition();
        this.codeBuffer.emitText("(function() {");
        this.codeGenTool.genComment("JS.Code section", WebImageOptions.CommentVerbosity.MINIMAL);
        this.codeBuffer.emitText("(function() {");
        this.codeGenTool.genComment("Untrusted code section", WebImageOptions.CommentVerbosity.MINIMAL);
        try (JSBenchmarkingCode.Timer totalTimer = this.benchmarkingCode.getTimer("Total").start();){
            Labeler.Injection injection;
            CodeSizeCollector sizeCollector;
            this.codeBuffer.emitText("(function() {");
            this.codeGenTool.genComment("VM internals section", WebImageOptions.CommentVerbosity.MINIMAL);
            try (JSBenchmarkingCode.Timer t = this.benchmarkingCode.getTimer("Initial Definitions").start();){
                sizeCollector = new CodeSizeCollector(ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE, () -> ((JSCodeBuffer)this.codeBuffer).codeSize());
                try {
                    injection = this.labeler.injectMetricLabel(this.codeBuffer, ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE);
                    try {
                        this.emitBootstrapDefinitions();
                    }
                    finally {
                        if (injection != null) {
                            injection.close();
                        }
                    }
                }
                finally {
                    sizeCollector.close();
                }
            }
            NameSpaceHideLowerer.lowerNameSpaceHidingFunction(this.codeGenTool);
            t = this.benchmarkingCode.getTimer("Initial Definitions").start();
            try {
                sizeCollector = new CodeSizeCollector(ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE, () -> ((JSCodeBuffer)this.codeBuffer).codeSize());
                try {
                    injection = this.labeler.injectMetricLabel(this.codeBuffer, ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE);
                    try {
                        this.emitRuntimeDefinitions();
                    }
                    finally {
                        if (injection != null) {
                            injection.close();
                        }
                    }
                }
                finally {
                    sizeCollector.close();
                }
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            this.emitCompiledCode();
            t = this.benchmarkingCode.getTimer("Runtime").start();
            try {
                this.emitEntryPointCall();
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            this.benchmarkingCode.lowerMeasuringResult();
            this.codeBuffer.emitNewLine();
            this.codeGenTool.genReturn("vm");
            NameSpaceHideLowerer.lowerNameSpaceHidingEnd(this.codeGenTool);
            this.codeBuffer.emitNewLine();
            this.codeBuffer.emitText(this.codeGenTool.vmClassName() + ".Config = Config;");
            this.codeBuffer.emitNewLine();
            this.configuration.getEntryFunctionLowerer().lowerEntryFunction(this.codeGenTool);
            this.codeGenTool.genComment("End VM internals section", WebImageOptions.CommentVerbosity.MINIMAL);
            this.codeBuffer.emitText("})();");
            this.codeBuffer.emitNewLine();
            this.codeBuffer.emitNewLine();
        }
        this.codeGenTool.genComment("End untrusted code section", WebImageOptions.CommentVerbosity.MINIMAL);
        this.codeBuffer.emitText("})();");
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitNewLine();
        this.emitJSCodeFiles();
        this.codeGenTool.genComment("End JS.Code annotation section", WebImageOptions.CommentVerbosity.MINIMAL);
        this.codeBuffer.emitText("})();");
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitText("(function() {");
        this.codeBuffer.emitNewLine();
        if (((Boolean)WebImageOptions.AutoRunVM.getValue(this.options)).booleanValue()) {
            this.codeGenTool.genComment("Auto run VM.", WebImageOptions.CommentVerbosity.MINIMAL);
            LowerableResources.LOAD_CMD_ARGS.lower(this.codeGenTool);
            this.codeBuffer.emitNewLine();
            this.codeBuffer.emitText("const config = new " + this.codeGenTool.vmClassName() + ".Config();");
            this.codeBuffer.emitNewLine();
            String autoFetchLibs = (String)WebImageOptions.AutoRunLibraries.getValue(this.options);
            if (!autoFetchLibs.equals("")) {
                try {
                    String[] pairs;
                    for (String pair : pairs = autoFetchLibs.split(",")) {
                        String[] parts = pair.split(":");
                        this.codeBuffer.emitText("config.libraries[\"" + parts[0] + "\"] = \"" + parts[1] + "\"");
                        this.codeBuffer.emitNewLine();
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw JVMCIError.shouldNotReachHere((String)("Incorrectly specified list of libraries: " + autoFetchLibs));
                }
            }
            this.codeBuffer.emitText(this.codeGenTool.vmClassName() + ".");
            WebImageEntryFunctionLowerer.FUNCTION.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((String)"load_cmd_args()"), Emitter.of((String)"config")});
            this.codeBuffer.emitText(".catch(console.error)");
            this.codeBuffer.emitInsEnd();
        } else {
            this.codeGenTool.genComment("Store the VM class into the global scope.", WebImageOptions.CommentVerbosity.MINIMAL);
            this.codeBuffer.emitText("globalThis[\"" + this.codeGenTool.vmClassName() + "\"] = " + this.codeGenTool.vmClassName() + ";");
            this.codeBuffer.emitNewLine();
        }
        this.codeBuffer.emitText("})();");
    }

    protected abstract void emitPreamble();

    protected abstract void emitBootstrapDefinitions();

    protected abstract void emitRuntimeDefinitions();

    protected abstract void emitCompiledCode();

    protected abstract void emitEntryPointCall();

    protected abstract void emitJSCodeFiles();

    protected Collection<Path> writeFiles() {
        ArrayList<Path> writtenFiles = new ArrayList<Path>();
        BuildArtifacts artifacts = BuildArtifacts.singleton();
        Path outFile = NativeImageGenerator.generatedFiles((OptionValues)this.options).resolve(this.filename);
        this.codeBuffer.emitImage(outFile);
        writtenFiles.add(outFile);
        artifacts.add(BuildArtifacts.ArtifactType.EXECUTABLE, outFile);
        if (((Boolean)WebImageOptions.GenerateSourceMap.getValue(this.options)).booleanValue()) {
            Path mapFile = NativeImageGenerator.generatedFiles((OptionValues)this.options).resolve(this.filename + ".map");
            this.codeBuffer.emitSourceMap(mapFile);
            writtenFiles.add(mapFile);
            artifacts.add(BuildArtifacts.ArtifactType.DEBUG_INFO, mapFile);
        }
        return writtenFiles;
    }
}

