/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.WebImageCodeGen;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.util.metrics.ImageMetricsCollector;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;

public class WebImage
extends AbstractImage {
    protected WebImageCodeGen webImageCodeGen;
    private final ImageClassLoader imageClassLoader;
    protected final HostedMethod mainEntryPoint;
    protected long imageHeapSize = -1L;

    public WebImage(AbstractImage.NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ImageClassLoader imageClassLoader, HostedMethod mainEntryPoint) {
        super(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, imageClassLoader.getClassLoader());
        this.imageClassLoader = imageClassLoader;
        this.mainEntryPoint = mainEntryPoint;
    }

    private static int getConstantsSize() {
        String scopeName;
        if (WebImageProviders.isLabelInjectionEnabled()) {
            scopeName = "Closure-Compiler";
        } else if (!((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            scopeName = "Pre-Closure";
        } else {
            return 0;
        }
        String qualifiedScopeName = LoggerContext.getQualifiedScopeName("Code-Generation", scopeName);
        Map<String, Number> savedCounters = LoggerContext.currentContext().getSavedCounters(qualifiedScopeName, ImageMetricsCollector.SAVED_SIZE_BREAKDOWN_KEYS);
        return savedCounters.get(ImageBreakdownMetricKeys.CONSTANTS_SIZE.getName()).intValue();
    }

    public void build(String imageName, DebugContext debug) {
        WebImageProviders webImageProviders = (WebImageProviders)((Object)ImageSingletons.lookup(WebImageProviders.class));
        try (Timer.StopTimer codeGenTimer = TimerCollection.createTimerAndStart((String)"codegen");){
            this.webImageCodeGen = WebImageCodeGen.generateCode((WebImageCodeCache)this.codeCache, this.entryPoints, this.mainEntryPoint, webImageProviders, debug, WebImageHostedConfiguration.get(), this.imageClassLoader);
        }
    }

    public LinkerInvocation write(DebugContext debug, Path outputDirectory, Path tempDirectory, String imageName, FeatureImpl.BeforeImageWriteAccessImpl config) {
        try (Timer.StopTimer t = TimerCollection.createTimerAndStart((String)"(write)");){
            Collection<Path> paths = this.webImageCodeGen.writeFiles();
            this.imageFileSize = (int)paths.stream().map(Path::toFile).mapToLong(File::length).sum();
            this.imageHeapSize = WebImage.getConstantsSize();
            this.debugInfoSize = (int)paths.stream().filter(p -> p.getFileName().toString().endsWith(".map")).map(Path::toFile).mapToLong(File::length).sum();
        }
        return null;
    }

    public String[] makeLaunchCommand(AbstractImage.NativeImageKind k, String imageName, Path binPath, Path workPath, Method method) {
        return new String[0];
    }

    public long getImageHeapSize() {
        return this.imageHeapSize;
    }

    public ObjectFile getObjectFile() {
        return null;
    }
}

