/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.RuntimeConstants;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.webimage.type.TypeControl;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class RuntimeModificationLowerer {
    private static final Set<Class<?>> COMPULSORY_RUNTIME_HUBS = new HashSet();

    public void lower(JSCodeGenTool tool) {
        tool.getCodeBuffer().emitNewLine();
        RuntimeModificationLowerer.indexHubs(tool);
        RuntimeModificationLowerer.storeBoxedHubs(tool);
        tool.getCodeBuffer().emitNewLine();
    }

    private static void storeBoxedHubs(JSCodeGenTool tool) {
        tool.genComment("Store the corresponding boxed type hub into each primitive type hub.");
        for (JavaKind kind : JavaKind.values()) {
            if (!kind.isPrimitive() || kind == JavaKind.Void) continue;
            RuntimeModificationLowerer.insertPrimitiveHubProperties(tool, kind);
        }
    }

    private static void insertPrimitiveHubProperties(JSCodeGenTool tool, JavaKind kind) {
        try {
            Class primitiveClass = kind.toJavaClass();
            Class boxedClass = kind.toBoxedJavaClass();
            MetaAccessProvider meta = tool.getProviders().getMetaAccess();
            WebImageTypeControl typeControl = tool.getJSProviders().typeControl();
            HostedType primitiveType = (HostedType)meta.lookupJavaType(primitiveClass);
            HostedType boxedType = (HostedType)meta.lookupJavaType(boxedClass);
            RuntimeModificationLowerer.assignHubProperty(tool, typeControl, primitiveType, Emitter.of((String)(RuntimeConstants.RUNTIME_SYMBOL + ".boxedHub")), typeControl.requestHubName((ResolvedJavaType)boxedType));
            String boxedName = typeControl.requestTypeName((ResolvedJavaType)boxedType);
            String valueOfName = typeControl.requestMethodName(meta.lookupJavaMethod((Executable)boxedClass.getMethod("valueOf", primitiveClass)));
            RuntimeModificationLowerer.assignHubProperty(tool, typeControl, primitiveType, Emitter.of((String)(RuntimeConstants.RUNTIME_SYMBOL + ".box")), boxedName + "." + valueOfName);
            String toPrimitiveName = typeControl.requestMethodName(meta.lookupJavaMethod((Executable)boxedClass.getMethod(kind.getJavaName() + "Value", new Class[0])));
            RuntimeModificationLowerer.assignHubProperty(tool, typeControl, primitiveType, Emitter.of((String)(RuntimeConstants.RUNTIME_SYMBOL + ".unbox")), boxedName + ".prototype." + toPrimitiveName);
        }
        catch (NoSuchMethodException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    private static void assignHubProperty(JSCodeGenTool tool, TypeControl typeControl, HostedType primitiveType, Emitter propertyExpression, String value) {
        tool.genPropertyBracketAccessWithExpression((IEmitter)Emitter.of((String)typeControl.requestHubName((ResolvedJavaType)primitiveType)), (IEmitter)propertyExpression);
        tool.genAssignment();
        tool.getCodeBuffer().emitText(value);
        tool.genResolvedVarDeclPostfix(null);
    }

    private static void indexHubs(JSCodeGenTool tool) {
        WebImageTypeControl typeControl = tool.getJSProviders().typeControl();
        tool.genComment("Create an index between class names and hubs in the image.");
        MetaAccessProvider meta = tool.getProviders().getMetaAccess();
        for (HostedType type : typeControl.emittedTypes()) {
            RuntimeModificationLowerer.assignJsClassToHub(tool, typeControl, type);
            if (!COMPULSORY_RUNTIME_HUBS.contains(type.getJavaClass())) continue;
            RuntimeModificationLowerer.assignToRuntimeHubs(tool, typeControl, type, type.getJavaClass().getName());
        }
        for (JavaKind kind : JavaKind.values()) {
            if (!kind.isPrimitive() || kind == JavaKind.Void) continue;
            Class<?> arrayClass = Array.newInstance(kind.toJavaClass(), 0).getClass();
            RuntimeModificationLowerer.assignToRuntimeHubs(tool, typeControl, (HostedType)meta.lookupJavaType(arrayClass), kind.getJavaName() + "[]");
        }
    }

    private static void assignJsClassToHub(JSCodeGenTool tool, TypeControl typeControl, HostedType type) {
        tool.genPropertyBracketAccessWithExpression((IEmitter)Emitter.of((String)typeControl.requestHubName((ResolvedJavaType)type)), (IEmitter)Emitter.of((String)RuntimeConstants.JS_CLASS_SYMBOL));
        tool.genAssignment();
        tool.getCodeBuffer().emitText(typeControl.requestTypeName((ResolvedJavaType)type));
        tool.genResolvedVarDeclPostfix(null);
    }

    private static void assignToRuntimeHubs(JSCodeGenTool tool, TypeControl typeControl, HostedType type, String name) {
        tool.genPropertyBracketAccess((IEmitter)Emitter.of((String)RuntimeConstants.RUNTIME_HUBS), name);
        tool.genAssignment();
        tool.getCodeBuffer().emitText(typeControl.requestHubName((ResolvedJavaType)type));
        tool.genResolvedVarDeclPostfix(null);
    }

    static {
        for (JavaKind kind : JavaKind.values()) {
            if (!kind.isPrimitive() || kind == JavaKind.Void) continue;
            COMPULSORY_RUNTIME_HUBS.add(kind.toBoxedJavaClass());
        }
        COMPULSORY_RUNTIME_HUBS.add(Class.class);
        COMPULSORY_RUNTIME_HUBS.add(String.class);
        COMPULSORY_RUNTIME_HUBS.add(BigInteger.class);
    }
}

