/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSNodeLowerer;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.webimage.JSKeyword;
import com.oracle.svm.webimage.JSNameGenerator;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.Keyword;

public class RuntimeConstants {
    public static final String DEBUG_CHECKS = JSNameGenerator.registerReservedSymbol("DEBUG_CHECKS");
    public static final String NULL = JSNameGenerator.registerReservedSymbol("N");
    public static final String UNDEFINED = JSNameGenerator.registerReservedSymbol("U");
    public static final String CLASS_META_SYMBOL = JSNameGenerator.registerReservedSymbol("CM");
    public static final String JS_CLASS_SYMBOL = JSNameGenerator.registerReservedSymbol("JC");
    public static final String GET_CLASS_PROTOTYPE = JSNameGenerator.registerReservedSymbol("CP");
    public static final String RUNTIME_SYMBOL = JSNameGenerator.registerReservedSymbol("SYM");
    public static final String RUNTIME_HUBS = JSNameGenerator.registerReservedSymbol("RH");
    public static final String HASH_CODE_FIELD = JSNameGenerator.registerReservedSymbol("HASH_CODE_FIELD");
    private static Map<String, ConstantDeclaration> constants;

    private static void genDefinition(JSCodeGenTool jsLTools, String docComment, String name, String value, String comment) {
        CodeBuffer masm = jsLTools.getCodeBuffer();
        masm.emitNewLine();
        if (docComment != null) {
            masm.emitText("/** ");
            masm.emitText(docComment);
            masm.emitText(" */");
            masm.emitWhiteSpace();
        }
        masm.emitKeyword((Keyword)JSKeyword.CONST);
        masm.emitWhiteSpace();
        jsLTools.genResolvedVarAssignmentPrefix(name);
        masm.emitText(value);
        jsLTools.genResolvedVarDeclPostfix(comment);
    }

    static Map<String, ConstantDeclaration> getConstantMap() {
        if (constants == null) {
            constants = new HashMap<String, ConstantDeclaration>(){
                {
                    this.put(DEBUG_CHECKS, new ConstantDeclaration(null, DEBUG_CHECKS, (Boolean)WebImageOptions.DebugOptions.RuntimeDebugChecks.getValue() != false ? "true" : "false", (String)WebImageOptions.DebugOptions.RuntimeDebugChecks.getDescriptor().getHelp().getFirst()));
                    this.put(NULL, new ConstantDeclaration(null, NULL, "null", "Short name for the null constant."));
                    this.put(UNDEFINED, new ConstantDeclaration(null, UNDEFINED, "undefined", "Short name for the undefined constant."));
                    this.put(CLASS_META_SYMBOL, new ConstantDeclaration(null, CLASS_META_SYMBOL, "runtime.symbol.classMeta", "Symbol that is the key for the class property with extra class metadata."));
                    this.put(JS_CLASS_SYMBOL, new ConstantDeclaration(null, JS_CLASS_SYMBOL, "runtime.symbol.jsClass", "Symbol that is the key for the property inside the hub object that points to the JavaScript class."));
                    this.put(GET_CLASS_PROTOTYPE, new ConstantDeclaration(null, GET_CLASS_PROTOTYPE, "cprops", "Function that obtains an object that can access the class properties."));
                    this.put(RUNTIME_SYMBOL, new ConstantDeclaration(null, RUNTIME_SYMBOL, "runtime.symbol", "Expression for obtaining the table of VM-internal Symbols."));
                    this.put(RUNTIME_HUBS, new ConstantDeclaration(null, RUNTIME_HUBS, "runtime.hubs", "Expression for obtaining the table of class hubs."));
                    this.put(HASH_CODE_FIELD, new ConstantDeclaration(null, HASH_CODE_FIELD, WebImageJSNodeLowerer.getStringLiteral("__hc"), "Name of the hash code field in objects."));
                }
            };
        }
        return constants;
    }

    public static void lowerInitialDefinition(JSCodeGenTool jsLTools, Map<String, ConstantDeclaration> consts) {
        for (Map.Entry<String, ConstantDeclaration> entry : consts.entrySet()) {
            ConstantDeclaration decl = entry.getValue();
            RuntimeConstants.genDefinition(jsLTools, decl.docComment, decl.name, decl.value, decl.comment);
        }
    }

    public static class ConstantDeclaration {
        public final String docComment;
        public final String name;
        public final String value;
        public final String comment;

        public ConstantDeclaration(String docComment, String name, String value, String comment) {
            this.docComment = docComment;
            this.name = name;
            this.value = value;
            this.comment = comment;
        }
    }
}

