/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.AnalysisUtil;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.JSIntrinsifyFile;
import com.oracle.svm.hosted.webimage.codegen.LowerableResource;
import com.oracle.svm.hosted.webimage.codegen.WebImageCodeGen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;

public class LowerableResources {
    public static final LowerableResource[] bootstrap = new LowerableResource[]{LowerableResources.bootstrapResource("runtime/feature-detection.js", false), LowerableResources.bootstrapResource("runtime/string-util.js", false), LowerableResources.bootstrapResource("runtime/log-console.js", false), LowerableResources.bootstrapResource("runtime/runtime.js", false)};
    public static final LowerableResource CWD = LowerableResources.runtimeResource("runtime/cwd.js", false);
    public static final LowerableResource STACK_TRACE = LowerableResources.runtimeResource("runtime/stack-trace.js", false);
    public static final LowerableResource[] runtime = new LowerableResource[]{CWD, LowerableResources.runtimeResource("runtime/arrayinit.js", true), LowerableResources.runtimeResource("runtime/arraycopyof.js", true), LowerableResources.runtimeResource("runtime/arrayequals.js", true), LowerableResources.runtimeResource("runtime/array-vtableinit.js", false), LowerableResources.runtimeResource("runtime/internal-error.js", true), LowerableResources.runtimeResource("runtime/float-convert.js", true), LowerableResources.runtimeResource("runtime/instanceof-runtime.js", true), LowerableResources.runtimeResource("runtime/library-loader.js", true), LowerableResources.runtimeResource("runtime/long64.js", true), LowerableResources.runtimeResource("runtime/clone-runtime.js", true), LowerableResources.runtimeResource("runtime/class-object-init.js", true), LowerableResources.runtimeResource("runtime/reinterpret-for-lowering.js", true), STACK_TRACE, LowerableResources.runtimeResource("runtime/unmanaged-memory.js", true), LowerableResources.runtimeResource("runtime/unsafe-runtime.js", true), LowerableResources.runtimeResource("runtime/unsigned-math.js", true)};
    public static final LowerableResource JSCONVERSION_COMMON = LowerableResources.extraResource("runtime/jsconversion.js", false);
    public static final LowerableResource[] extra = new LowerableResource[]{JSCONVERSION_COMMON, LowerableResources.extraResource("runtime/jsconversion-js.js", true), LowerableResources.extraResource("runtime/string-extensions.js", true)};
    public static final LowerableResource LOAD_CMD_ARGS = new LowerableResource("runtime/load-cmd-args.js", WebImageCodeGen.class, false);
    public static final LowerableResource TIMER = new LowerableResource("runtime/timer.js", WebImageCodeGen.class, false);
    public static final List<LowerableResource> optional = new ArrayList<LowerableResource>(Arrays.asList(LOAD_CMD_ARGS, TIMER));
    public static final List<LowerableResource> thirdParty = new ArrayList<LowerableResource>();

    public static void lower(JSCodeGenTool codeGenTool, LowerableResource ... resources) {
        for (LowerableResource resource : resources) {
            codeGenTool.lowerFile(resource);
        }
    }

    private static LowerableResource bootstrapResource(String name, boolean shouldIntrinsify) {
        return new LowerableResource(name, WebImageCodeGen.class, shouldIntrinsify);
    }

    private static LowerableResource runtimeResource(String name, boolean shouldIntrinsify) {
        return new LowerableResource(name, WebImageCodeGen.class, shouldIntrinsify);
    }

    private static LowerableResource extraResource(String name, boolean shouldIntrinsify) {
        return new LowerableResource(name, WebImageCodeGen.class, shouldIntrinsify);
    }

    public static void processResources(Feature.BeforeAnalysisAccess access, WebImageHostedConfiguration config) {
        for (LowerableResource resource : config.getAnalysisResources()) {
            if (!resource.shouldIntrinsify()) continue;
            String content = JSIntrinsifyFile.readFile(resource::getStream);
            JSIntrinsifyFile.FileData data = new JSIntrinsifyFile.FileData(resource.getName(), content);
            JSIntrinsifyFile.collectIntrinsifications(data);
            AnalysisUtil.processFileData((FeatureImpl.BeforeAnalysisAccessImpl)access, data);
            resource.markRegistered(data);
        }
    }
}

