/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.webimage.codegen.JSIntrinsifyFile;
import com.oracle.svm.webimage.LowerableFile;
import java.io.File;
import java.io.InputStream;
import java.util.Scanner;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;

public final class LowerableResource
implements LowerableFile {
    private final String name;
    private final Class<?> clazz;
    private final boolean shouldIntrinsify;
    private JSIntrinsifyFile.FileData data = null;

    public LowerableResource(String name, Class<?> clazz, boolean shouldIntrinsify) {
        this.name = name;
        this.clazz = clazz;
        this.shouldIntrinsify = shouldIntrinsify;
    }

    public boolean shouldIntrinsify() {
        return this.shouldIntrinsify;
    }

    public boolean isRegistered() {
        return this.data != null;
    }

    public void markRegistered(JSIntrinsifyFile.FileData fileData) {
        this.data = fileData;
    }

    public JSIntrinsifyFile.FileData getData() {
        return this.data;
    }

    @Override
    public String getName() {
        return this.name.substring(this.name.lastIndexOf(File.separatorChar) + 1);
    }

    @Override
    public void lower(CodeGenTool jsLTools) {
        if (this.shouldIntrinsify) {
            assert (this.isRegistered()) : "Resource " + this.name + " must be registered.";
            assert (this.data.isProcessed()) : "Resource " + this.name + " was not processed.";
            jsLTools.getCodeBuffer().emitText(this.data.getProcessed());
        } else {
            CodeBuffer codeBuffer = jsLTools.getCodeBuffer();
            try (Scanner s = new Scanner(this.getStream());){
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    codeBuffer.emitText(line);
                    codeBuffer.emitNewLine();
                }
            }
        }
    }

    public InputStream getStream() {
        InputStream stream = this.clazz.getResourceAsStream(this.name);
        GraalError.guarantee((stream != null ? 1 : 0) != 0, (String)"Couldn't find lowerable resource %s relative to %s", (Object)this.name, (Object)this.clazz.getName());
        return stream;
    }
}

