/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.util.ReflectionUtil;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class JSIntrinsifyFile {
    private static final MethodIntrinsificationFI NoIntrinsification = new NoIntrinsificationFI();
    public static final Pattern LOOKUP_PATTERN = Pattern.compile("((\\s*\\.\\s*\\$(?<indexedType>[fm]))|(\\$(?<type>t)))\\s*\\[\\s*\"(?<name>[\\w|.]+)\"\\s*]");

    public static String readFile(Supplier<InputStream> file) {
        StringBuilder sb = new StringBuilder();
        try (Scanner s = new Scanner(file.get());){
            while (s.hasNextLine()) {
                String line = s.nextLine();
                sb.append(line);
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    public static void process(FileData f, WebImageJSProviders providers) {
        JSIntrinsifyFile.process(f, providers, NoIntrinsification);
    }

    public static void process(FileData f, WebImageJSProviders providers, MethodIntrinsificationFI methodIntrinsifier) {
        block0: for (JSIntrinsification js : f.intrinsics) {
            if (js instanceof TypeIntrinsification) {
                TypeIntrinsification tjs = (TypeIntrinsification)js;
                tjs.emit = true;
                Class c = ReflectionUtil.lookupClass((boolean)false, (String)tjs.name, (ClassLoader)providers.getClassLoader());
                tjs.resolvedType = (HostedType)providers.getMetaAccess().lookupJavaType(c);
                continue;
            }
            if (js instanceof FieldIntrinsification) {
                FieldIntrinsification fjs = (FieldIntrinsification)js;
                HostedMethod[] type = fjs.precedingType.resolvedType;
                ArrayList fields = new ArrayList();
                Collections.addAll(fields, type.getInstanceFields(true));
                Collections.addAll(fields, (HostedField[])type.getStaticFields());
                fjs.emit = true;
                for (HostedField field : fields) {
                    if (!field.getName().equals(fjs.name)) continue;
                    fjs.resolvedField = field;
                    fjs.precedingType.emit = field.isStatic();
                    continue block0;
                }
                continue;
            }
            if (!(js instanceof MethodIntrinsification)) continue;
            MethodIntrinsification mjs = (MethodIntrinsification)js;
            mjs.emit = true;
            for (HostedMethod method : mjs.precedingType.resolvedType.getAllDeclaredMethods()) {
                if (!method.getName().equals(mjs.name) || !JSIntrinsifyFile.checkSignature(mjs.sig, (Signature)method.getSignature())) continue;
                mjs.resolvedMethod = method;
                mjs.precedingType.emit = method.isStatic();
                continue block0;
            }
        }
        JSIntrinsifyFile.validate(f);
        StringBuilder sb = new StringBuilder();
        int previousEnd = 0;
        for (JSIntrinsification js : f.intrinsics) {
            HostedMethod method;
            sb.append(f.content, previousEnd, js.startIndex);
            previousEnd = js.endIndex;
            if (!js.emit) continue;
            WebImageTypeControl typeControl = providers.typeControl();
            if (js instanceof TypeIntrinsification) {
                TypeIntrinsification typeIntrinsification = (TypeIntrinsification)js;
                HostedType type = typeIntrinsification.resolvedType;
                sb.append(providers.typeControl().requestTypeName((ResolvedJavaType)type));
                continue;
            }
            if (js instanceof FieldIntrinsification) {
                HostedField field;
                FieldIntrinsification fieldIntrinsification = (FieldIntrinsification)js;
                field = fieldIntrinsification.resolvedField;
                if (field.isStatic()) {
                    sb.append('.');
                }
                sb.append(typeControl.requestFieldName((ResolvedJavaField)field));
                continue;
            }
            if (!(js instanceof MethodIntrinsification)) continue;
            MethodIntrinsification methodIntrinsification = (MethodIntrinsification)js;
            method = methodIntrinsification.resolvedMethod;
            String ident = typeControl.requestMethodName((ResolvedJavaMethod)method);
            if (method.isStatic()) {
                sb.append('.');
            }
            methodIntrinsifier.intrinsifyMethod(providers, sb, methodIntrinsification, method, ident);
        }
        sb.append(f.content.substring(previousEnd));
        f.setProcessed(sb.toString());
    }

    private static boolean checkSignature(String str, Signature sig) {
        if (sig == null) {
            throw new NullPointerException();
        }
        if (str == null) {
            return true;
        }
        int strPtr = 0;
        int arity = sig.getParameterCount(false);
        for (int i = 0; i < arity; ++i) {
            int argLen;
            String arg = sig.getParameterType(i, null).getName();
            if (!str.regionMatches(strPtr, arg, 0, argLen = arg.length())) {
                return false;
            }
            strPtr += argLen;
        }
        return strPtr == str.length();
    }

    private static void validate(FileData f) {
        JSIntrinsification previous = null;
        block5: for (JSIntrinsification js : f.intrinsics) {
            JSIntrinsification jSIntrinsification;
            if (previous != null) {
                GraalError.guarantee((previous.endIndex <= js.startIndex ? 1 : 0) != 0, (String)"Intrinsifications must appear in order.");
            }
            previous = js;
            Objects.requireNonNull(js);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeIntrinsification.class, FieldIntrinsification.class, MethodIntrinsification.class}, (Object)jSIntrinsification, n)) {
                case 0: {
                    TypeIntrinsification tjs = (TypeIntrinsification)jSIntrinsification;
                    GraalError.guarantee((tjs.resolvedType != null ? 1 : 0) != 0, (String)"%s: Type must evaluate to a image type: '%s'", (Object)f.name, (Object)js.name);
                    continue block5;
                }
                case 1: {
                    FieldIntrinsification fjs = (FieldIntrinsification)jSIntrinsification;
                    GraalError.guarantee((fjs.resolvedField != null ? 1 : 0) != 0, (String)"%s: Field must evaluate to an image type field '%s' type '%s'", (Object)f.name, (Object)js.name, (Object)fjs.precedingType.name);
                    GraalError.guarantee((fjs.startIndex == fjs.precedingType.endIndex ? 1 : 0) != 0, (String)"%s: Field intrinsification must directly follow a type intrinsification", (Object)f.name);
                    continue block5;
                }
                case 2: {
                    MethodIntrinsification mjs = (MethodIntrinsification)jSIntrinsification;
                    GraalError.guarantee((mjs.resolvedMethod != null ? 1 : 0) != 0, (String)"%s: Method must evaluate to an image type method '%s' type '%s'", (Object)f.name, (Object)js.name, (Object)mjs.precedingType.name);
                    GraalError.guarantee((mjs.startIndex == mjs.precedingType.endIndex ? 1 : 0) != 0, (String)"%s: Method intrinsification must directly follow a type intrinsification", (Object)f.name);
                    continue block5;
                }
            }
            GraalError.shouldNotReachHere((String)js.toString());
        }
    }

    public static void collectIntrinsifications(FileData f) {
        Matcher m = LOOKUP_PATTERN.matcher(f.content);
        while (m.find()) {
            JSIntrinsification js;
            String match = m.group();
            String indexedType = m.group("indexedType");
            String type = m.group("type");
            String name = m.group("name");
            int startIndex = m.start();
            int endIndex = m.end();
            if (name == null) {
                throw new IntrinsificationException(f.name, startIndex, "Could not match name", match);
            }
            if (type != null) {
                if (!"t".equals(type)) {
                    throw new IntrinsificationException(f.name, startIndex, "Illegal intrinsification type", match);
                }
                js = new TypeIntrinsification();
            } else {
                if (indexedType == null) {
                    throw new IntrinsificationException(f.name, startIndex, "No type was matched", match);
                }
                if (name.contains(".")) {
                    throw new IntrinsificationException(f.name, startIndex, "Name in method or field pattern must not contain periods", match);
                }
                TypeIntrinsification precedingType = (TypeIntrinsification)f.intrinsics.getLast();
                if ("f".equals(indexedType)) {
                    FieldIntrinsification field = new FieldIntrinsification();
                    field.precedingType = precedingType;
                    js = field;
                } else if ("m".equals(indexedType)) {
                    MethodIntrinsification method = new MethodIntrinsification();
                    method.precedingType = precedingType;
                    js = method;
                } else {
                    throw new IntrinsificationException(f.name, startIndex, "Illegal intrinsification type " + indexedType, match);
                }
            }
            js.name = name;
            js.startIndex = startIndex;
            js.endIndex = endIndex;
            f.addIntrinsic(js);
        }
    }

    @FunctionalInterface
    public static interface MethodIntrinsificationFI {
        public void intrinsifyMethod(WebImageJSProviders var1, StringBuilder var2, MethodIntrinsification var3, HostedMethod var4, String var5);
    }

    public static class FileData {
        public List<JSIntrinsification> intrinsics = new ArrayList<JSIntrinsification>();
        public final String name;
        public final String content;
        private String processed;

        public FileData(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public void addIntrinsic(JSIntrinsification js) {
            this.intrinsics.add(js);
        }

        public boolean isProcessed() {
            return this.processed != null;
        }

        public void setProcessed(String s) {
            assert (s != null);
            this.processed = s;
        }

        public String getProcessed() {
            assert (this.isProcessed()) : "File " + this.name + " was never processed";
            return this.processed;
        }
    }

    public static abstract sealed class JSIntrinsification
    permits TypeIntrinsification, FieldIntrinsification, MethodIntrinsification {
        public String name;
        public int startIndex;
        public int endIndex;
        public boolean emit;
    }

    public static final class TypeIntrinsification
    extends JSIntrinsification {
        public HostedType resolvedType;
    }

    public static final class FieldIntrinsification
    extends JSIntrinsification {
        public TypeIntrinsification precedingType;
        public HostedField resolvedField;
    }

    public static final class MethodIntrinsification
    extends JSIntrinsification {
        public TypeIntrinsification precedingType;
        public HostedMethod resolvedMethod;
        public String sig;
    }

    public static class IntrinsificationException
    extends RuntimeException {
        public IntrinsificationException(String filename, int startIndex, String message, String fullMatch) {
            super(filename + " at index " + startIndex + ": " + message + ". Full match: " + fullMatch);
        }
    }

    private static final class NoIntrinsificationFI
    implements MethodIntrinsificationFI {
        private NoIntrinsificationFI() {
        }

        @Override
        public void intrinsifyMethod(WebImageJSProviders providers, StringBuilder sb, MethodIntrinsification methodIntrinsification, HostedMethod method, String ident) {
            sb.append(ident);
        }
    }
}

