/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.Array;
import com.oracle.svm.hosted.webimage.codegen.Runtime;
import com.oracle.svm.hosted.webimage.codegen.RuntimeConstants;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSNodeLowerer;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.webimage.JSKeyword;
import com.oracle.svm.webimage.LowerableFile;
import com.oracle.svm.webimage.annotation.WebImage;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.hightiercodegen.Keyword;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.hightiercodegen.variables.VariableAllocation;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.webimage.api.JSValue;

public class JSCodeGenTool
extends CodeGenTool {
    private final WebImageJSNodeLowerer nodeLowerer;
    private final WebImageProviders providers;
    private final EconomicMap<String, ExternClassDescriptor> externJSClasses = EconomicMap.create();

    public WebImageProviders getProviders() {
        return this.providers;
    }

    public WebImageJSProviders getJSProviders() {
        return (WebImageJSProviders)this.providers;
    }

    public JSCodeGenTool(WebImageProviders providers, JSCodeBuffer codeBuffer, WebImageHostedConfiguration configuration, VariableAllocation variableAllocation) {
        super((CodeBuffer)codeBuffer, variableAllocation);
        this.providers = providers;
        this.nodeLowerer = configuration.createNodeLowerer(this);
    }

    public MapCursor<String, ExternClassDescriptor> getExternJSClasses() {
        return this.externJSClasses.getEntries();
    }

    public ExternClassDescriptor addExternJSClass(String name) {
        ExternClassDescriptor descriptor = (ExternClassDescriptor)this.externJSClasses.get((Object)name);
        if (descriptor == null) {
            descriptor = new ExternClassDescriptor(name);
            this.externJSClasses.put((Object)name, (Object)descriptor);
        }
        return descriptor;
    }

    public void genClassHeader(ResolvedJavaType type) {
        MetaAccessProvider meta;
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitNewLine();
        this.genComment(type.toJavaName(true), WebImageOptions.CommentVerbosity.MINIMAL);
        if (((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue() && ((meta = this.getProviders().getMetaAccess()).lookupJavaType(JSValue.class).isAssignableFrom(type) || meta.lookupJavaType(Class.class).equals((Object)type))) {
            this.codeBuffer.emitText("/** @unrestricted */");
            this.codeBuffer.emitNewLine();
        }
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.CLASS);
        this.codeBuffer.emitWhiteSpace();
        this.genTypeName(type);
        this.codeBuffer.emitWhiteSpace();
        if (type.getSuperclass() != null) {
            this.codeBuffer.emitKeyword((Keyword)JSKeyword.EXTENDS);
            this.codeBuffer.emitWhiteSpace();
            this.genTypeName(type.getSuperclass());
            this.codeBuffer.emitWhiteSpace();
        }
        this.codeBuffer.emitScopeBegin();
    }

    public void genMethodHeader(StructuredGraph graph, ResolvedJavaMethod m, List<ParameterNode> parameters) {
        String functionName = this.getJSProviders().typeControl().requestMethodName(m);
        Signature s = m.getSignature();
        if (((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue() && !AnnotationAccess.isAnnotationPresent((AnnotatedElement)m, WebImage.OmitClosureReturnType.class)) {
            this.codeBuffer.emitNewLine();
            this.codeBuffer.emitText("/** @return {" + this.getClosureCompilerAnnotation((ResolvedJavaType)s.getReturnType(null), true) + "} */");
            if (graph.getNodes().filter(JSBody.class::isInstance).isNotEmpty()) {
                this.codeBuffer.emitNewLine();
                this.codeBuffer.emitText("/** @suppress {checkTypes|externsValidation|undefinedVars} */ ");
            }
        }
        this.codeBuffer.emitMethodHeader(m, functionName, s, parameters);
    }

    protected void genArrayAccessPostfix() {
        this.codeBuffer.emitWhiteSpace();
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RBRACK);
    }

    protected void genArrayAccessPrefix() {
        this.codeBuffer.emitWhiteSpace();
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LBRACK);
        this.codeBuffer.emitWhiteSpace();
    }

    public void genArrayStore(IEmitter index, ValueNode array, ValueNode value) {
        if (value.getStackKind() == JavaKind.Long) {
            Runtime.BigInt64ArrayStore.emitCall((CodeGenTool)this, new IEmitter[]{Emitter.of((ValueNode)array), index, Emitter.of((ValueNode)value)});
        } else {
            super.genArrayStore(index, (IEmitter)Emitter.of((ValueNode)array), (IEmitter)Emitter.of((ValueNode)value));
        }
    }

    public void genBinaryOperation(Keyword operator, ValueNode leftOperand, ValueNode righOperand) {
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LPAR);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue(leftOperand);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeBuffer.emitKeyword(operator);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LPAR);
        this.lowerValue(righOperand);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RPAR);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RPAR);
    }

    public void genUnaryOperation(Keyword operator, ValueNode operand) {
        this.codeBuffer.emitKeyword(operator);
        this.lowerValue(operand);
    }

    public WebImageJSNodeLowerer nodeLowerer() {
        return this.nodeLowerer;
    }

    public void genResolvedVarDeclPostfix(String comment) {
        if (WebImageOptions.genJSComments()) {
            this.codeBuffer.emitResolvedBuiltInVarDeclPostfix(comment);
        } else {
            this.codeBuffer.emitResolvedBuiltInVarDeclPostfix(null);
        }
    }

    public void genCommaList(IEmitter ... inputs) {
        for (int i = 0; i < inputs.length; ++i) {
            if (i != 0) {
                this.codeBuffer.emitKeyword((Keyword)JSKeyword.COMMA);
            }
            this.lower(inputs[i]);
        }
    }

    public void genComment(String comment) {
        this.genComment(comment, null);
    }

    public void genComment(String comment, WebImageOptions.CommentVerbosity verbosity) {
        if (!WebImageOptions.genJSComments(verbosity)) {
            return;
        }
        this.codeBuffer.emitComment(comment);
        this.codeBuffer.emitNewLine();
    }

    public void genInlineComment(String comment) {
        if (!WebImageOptions.genJSComments()) {
            return;
        }
        this.codeBuffer.emitInlineComment(comment);
    }

    public void genNumericalPaladinIntLeft() {
        this.codeBuffer.emitText("( ( ");
    }

    public void genNumericalPaladinIntRight() {
        this.codeBuffer.emitText(" ) | 0)");
    }

    public void genNewInstance(ResolvedJavaType t) {
        this.genObjectCreate((IEmitter)Emitter.of((ResolvedJavaType)t), new IEmitter[0]);
    }

    public void genNewArray(ResolvedJavaType arrayType, IEmitter length) {
        Array.lowerNewArray((HostedType)arrayType.getComponentType(), length, this);
    }

    public void genObjectCreate(IEmitter prototype, IEmitter ... initParams) {
        this.codeBuffer.emitNew();
        this.lower(prototype);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LPAR);
        this.genCommaList(initParams);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RPAR);
    }

    public void genEmptyDeclaration(ValueNode node) {
        ResolvedVar resolvedVar = this.getAllocatedVariable(node);
        assert (resolvedVar != null) : this.nodeLowerer().nodeDebugInfo((Node)node);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.VAR);
        this.codeBuffer.emitWhiteSpace();
        this.codeBuffer.emitText(resolvedVar.getName());
        this.genResolvedVarDeclPostfix(node.toString());
        resolvedVar.setDefinitionLowered();
    }

    public void genThrow(ValueNode exception) {
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.THROW);
        this.codeBuffer.emitWhiteSpace();
        this.lowerValue(exception);
    }

    public void genAssignment() {
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.Assignment);
    }

    public void genResolvedConstDeclPrefix(String name) {
        ((JSCodeBuffer)this.codeBuffer).emitConstDeclPrefix(name);
    }

    public void genResolvedVarDeclThisPrefix(String name) {
        this.genPropertyAccess((IEmitter)Emitter.of((String)"this"), (IEmitter)Emitter.of((String)name));
        this.genAssignment();
    }

    public void genResolvedVarDeclThisBracketPrefix(String name) {
        this.genPropertyBracketAccess((IEmitter)Emitter.of((String)"this"), name);
        this.genAssignment();
    }

    public void genNull() {
        this.codeBuffer.emitText(RuntimeConstants.NULL);
    }

    public void genObject(Map<String, IEmitter> map) {
        this.codeBuffer.emitScopeBegin();
        for (Map.Entry<String, IEmitter> entry : map.entrySet()) {
            this.codeBuffer.emitStringLiteral(entry.getKey());
            this.codeBuffer.emitText(" : ");
            this.lower(entry.getValue());
            this.codeBuffer.emitText(",");
            this.codeBuffer.emitNewLine();
        }
        this.genScopeEnd();
    }

    public void lowerFile(LowerableFile f) {
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitNewLine();
        this.genComment(f.getName(), WebImageOptions.CommentVerbosity.MINIMAL);
        f.lower(this);
    }

    public void genFieldName(ResolvedJavaField field) {
        this.codeBuffer.emitText(this.getJSProviders().typeControl().requestFieldName(field));
    }

    public void genFieldName(Field field) {
        this.genFieldName(this.getProviders().getMetaAccess().lookupJavaField(field));
    }

    public void genTypeName(ResolvedJavaType type) {
        this.codeBuffer.emitText(this.getJSProviders().typeControl().requestTypeName(type));
    }

    public void genTypeName(Class<?> type) {
        this.genTypeName(this.getProviders().getMetaAccess().lookupJavaType(type));
    }

    public void genMethodName(ResolvedJavaMethod method) {
        this.codeBuffer.emitText(this.getJSProviders().typeControl().requestMethodName(method));
    }

    public void genMethodName(Method method) {
        this.genMethodName(this.getProviders().getMetaAccess().lookupJavaMethod((Executable)method));
    }

    protected void genPropertyAccessInfix() {
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.DOT);
    }

    public void genPrototypePropertyAccess(IEmitter receiver, IEmitter prop) {
        assert (receiver != null);
        this.lower(receiver);
        this.codeBuffer.emitText(".prototype.");
        this.lower(prop);
    }

    public void genPropertyBracketAccess(IEmitter receiver, String prop) {
        this.lower(receiver);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LBRACK);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.SingleQuote);
        this.codeBuffer.emitText(prop);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.SingleQuote);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RBRACK);
    }

    public void genPropertyBracketAccessWithExpression(IEmitter receiver, IEmitter expression) {
        this.lower(receiver);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LBRACK);
        this.lower(expression);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RBRACK);
    }

    public void genFunctionCall(IEmitter receiver, IEmitter fun, IEmitter ... params) {
        this.genPropertyAccess(receiver, fun);
        this.genFunctionParameterInfix();
        this.genCommaList(params);
        this.genFunctionParameterPostfix();
    }

    protected void genFunctionParameterInfix() {
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LPAR);
    }

    protected void genFunctionParameterPostfix() {
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RPAR);
    }

    public void genPrototypeFunctionCall(IEmitter receiver, IEmitter fun, IEmitter ... params) {
        this.genPrototypePropertyAccess(receiver, fun);
        this.genFunctionParameterInfix();
        this.genCommaList(params);
        this.genFunctionParameterPostfix();
    }

    public void genStaticMethodReference(ResolvedJavaMethod m) {
        this.genPropertyAccess((IEmitter)Emitter.of((ResolvedJavaType)m.getDeclaringClass()), (IEmitter)Emitter.of((ResolvedJavaMethod)m));
    }

    public void genPrototypeMethodReference(ResolvedJavaMethod m) {
        this.genPrototypePropertyAccess((IEmitter)Emitter.of((ResolvedJavaType)m.getDeclaringClass()), (IEmitter)Emitter.of((ResolvedJavaMethod)m));
    }

    public void genStaticField(ResolvedJavaField m) {
        this.genPropertyAccess((IEmitter)Emitter.of((ResolvedJavaType)m.getDeclaringClass()), (IEmitter)Emitter.of((ResolvedJavaField)m));
    }

    public void genStaticCall(ResolvedJavaMethod m, IEmitter ... args) {
        assert (m.isStatic()) : m;
        assert (NumUtil.assertArrayLength((Object[])args, (int)m.getSignature().getParameterCount(!m.isStatic())));
        this.genFunctionCall((IEmitter)Emitter.of((ResolvedJavaType)m.getDeclaringClass()), (IEmitter)Emitter.of((ResolvedJavaMethod)m), args);
    }

    public void genPrototypeCall(ResolvedJavaMethod m, IEmitter ... args) {
        assert (NumUtil.assertArrayLength((Object[])args, (int)m.getSignature().getParameterCount(!m.isStatic())));
        this.genPrototypeFunctionCall((IEmitter)Emitter.of((ResolvedJavaType)m.getDeclaringClass()), (IEmitter)Emitter.of((ResolvedJavaMethod)m), args);
    }

    public void genIndirectCall(IEmitter address, IEmitter ... args) {
        this.codeBuffer.emitText("runtime.funtab[Long64.lowBits(");
        address.lower((CodeGenTool)this);
        this.codeBuffer.emitText(")].call");
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.LPAR);
        IEmitter[] callArgs = new IEmitter[args.length + 1];
        callArgs[0] = Emitter.ofNull();
        System.arraycopy(args, 0, callArgs, 1, args.length);
        this.genCommaList(callArgs);
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.RPAR);
    }

    public void genShouldNotReachHere(String msg) {
        this.codeBuffer.emitKeyword((Keyword)JSKeyword.THROW);
        this.codeBuffer.emitWhiteSpace();
        assert (msg != null);
        JSCallNode.SHOULD_NOT_REACH_HERE.emitCall((CodeGenTool)this, new IEmitter[]{Emitter.of((String)this.getStringLiteral(msg))});
    }

    public void genInitJsResources(ResolvedJavaType t) {
        String initFun = this.getJSProviders().typeControl().requestTypeName(t);
        Emitter target = Emitter.of((String)"runtime.jsResourceInits");
        this.codeBuffer.emitText("if (");
        this.codeBuffer.emitStringLiteral(initFun);
        this.codeBuffer.emitText(" in ");
        this.lower((IEmitter)target);
        this.codeBuffer.emitText(") ");
        this.genFunctionCall((IEmitter)target, (IEmitter)Emitter.of((String)initFun), new IEmitter[0]);
        this.codeBuffer.emitText(", delete ");
        this.genPropertyAccess((IEmitter)target, (IEmitter)Emitter.of((String)initFun));
        this.codeBuffer.emitInsEnd();
    }

    public String vmClassName() {
        String imageName = (String)WebImageOptions.VMClassName.getValue(HostedOptionValues.singleton());
        imageName = imageName.replaceAll("[^A-Za-z]", "_");
        return imageName;
    }

    public String getClosureCompilerAnnotation(ResolvedJavaType type, boolean allowsNull) {
        JavaKind kind = type.getJavaKind();
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Float: 
            case Double: {
                return "number";
            }
            case Long: 
            case Object: {
                return (allowsNull ? "?" : "!") + "Object";
            }
            case Void: {
                return "void";
            }
        }
        throw JVMCIError.shouldNotReachHere((String)kind.toString());
    }

    public static final class ExternClassDescriptor {
        private final String name;
        private final EconomicSet<String> properties;

        private ExternClassDescriptor(String name) {
            this.name = name;
            this.properties = EconomicSet.create();
        }

        public void addProperty(String p) {
            this.properties.add((Object)p);
        }

        public Iterable<String> getProperties() {
            return this.properties;
        }

        public String getName() {
            return this.name;
        }
    }
}

