/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.webimage.codegen.node.InterceptJSInvokeNode;
import com.oracle.svm.hosted.webimage.util.ReflectUtil;
import com.oracle.svm.webimage.platform.WebImagePlatform;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Set;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImagePlatform.class})
public class JSBodyTypeFlowFeature
implements InternalFeature {
    private Set<Method> jsOverridden;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        FeatureImpl.AfterRegistrationAccessImpl accessImpl = (FeatureImpl.AfterRegistrationAccessImpl)access;
        ImageClassLoader imageClassLoader = accessImpl.getImageClassLoader();
        this.jsOverridden = ReflectUtil.findBaseMethodsOfJSAnnotated(imageClassLoader);
    }

    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        plugins.appendNodePlugin(new NodePlugin(){

            public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                if (this.canBeJavaScriptCall((AnalysisMethod)method)) {
                    InterceptJSInvokeNode intercept = (InterceptJSInvokeNode)b.append((Node)new InterceptJSInvokeNode(method, b.bci()));
                    for (ValueNode arg : args) {
                        intercept.arguments().add((Object)arg);
                    }
                }
                return false;
            }

            private boolean canBeJavaScriptCall(AnalysisMethod method) {
                Executable executable;
                try {
                    executable = method.getJavaMethod();
                }
                catch (Throwable e) {
                    return false;
                }
                if (executable instanceof Method) {
                    return JSBodyTypeFlowFeature.this.jsOverridden.contains(executable);
                }
                return false;
            }
        });
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.jsOverridden = null;
    }
}

