/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.codegen.oop.ClassWithMirrorLowerer;
import com.oracle.svm.hosted.webimage.js.JSObjectAccessMethodSupport;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.webimage.api.Nothing;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.webimage.api.JS;
import org.graalvm.webimage.api.JSObject;
import org.graalvm.webimage.api.JSValue;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageJSPlatform.class})
public final class JSBodyFeature
implements InternalFeature {
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        plugins.appendNodePlugin(new NodePlugin(this){

            public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)method.getDeclaringClass(), JS.Import.class)) {
                    ((AnalysisType)method.getDeclaringClass()).registerAsInstantiated((Object)"JS.Import classes might be allocated in JavaScript. We need to tell the static analysis about that");
                }
                return false;
            }

            public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
                if (ClassWithMirrorLowerer.isFieldRepresentedInJavaScript(field)) {
                    1.genJSObjectFieldAccess(b, object, field, null);
                    return true;
                }
                return false;
            }

            public boolean handleStoreField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode value) {
                if (ClassWithMirrorLowerer.isFieldRepresentedInJavaScript(field)) {
                    1.genJSObjectFieldAccess(b, object, field, value);
                    return true;
                }
                return false;
            }

            private static void genJSObjectFieldAccess(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode valueForStore) {
                ValueNode[] arguments;
                AnalysisMethod accessMethod;
                boolean isLoad;
                AnalysisMetaAccess metaAccess = (AnalysisMetaAccess)b.getMetaAccess();
                AnalysisField analysisField = (AnalysisField)field;
                boolean bl = isLoad = valueForStore == null;
                if (isLoad) {
                    accessMethod = JSObjectAccessMethodSupport.singleton().lookupLoadMethod(metaAccess, analysisField);
                    arguments = new ValueNode[]{object};
                } else {
                    accessMethod = JSObjectAccessMethodSupport.singleton().lookupStoreMethod(metaAccess, analysisField);
                    arguments = new ValueNode[]{object, valueForStore};
                }
                JavaKind returnKind = ((AnalysisType)accessMethod.getSignature().getReturnType()).getJavaKind();
                StampPair returnStamp = StampPair.createSingle((Stamp)StampFactory.forKind((JavaKind)returnKind));
                SubstrateMethodCallTargetNode callTarget = new SubstrateMethodCallTargetNode(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)accessMethod, arguments, returnStamp);
                InvokeWithExceptionNode invoke = new InvokeWithExceptionNode((CallTargetNode)callTarget, null, b.bci());
                if (isLoad) {
                    b.addPush(returnKind, (ValueNode)invoke);
                } else {
                    b.add((Node)invoke);
                }
            }
        });
        plugins.prependInlineInvokePlugin(new InlineInvokePlugin(this){

            public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                ResolvedJavaType jsObjectType = b.getMetaAccess().lookupJavaType(JSObject.class);
                ResolvedJavaType declaringClass = method.getDeclaringClass();
                if (method.isConstructor() && jsObjectType.isAssignableFrom(declaringClass)) {
                    return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
                }
                return super.shouldInlineInvoke(b, method, args);
            }

            public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
                ResolvedJavaType jsObjectType = b.getMetaAccess().lookupJavaType(JSObject.class);
                ResolvedJavaType declaringClass = method.getDeclaringClass();
                if (method.isConstructor() && jsObjectType.isAssignableFrom(declaringClass)) {
                    invoke.setUseForInlining(false);
                }
            }
        });
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        BigBang bigbang = accessImpl.getBigBang();
        accessImpl.registerSubtypeReachabilityHandler((acc, clazz) -> {
            if (clazz.isAnnotationPresent(JS.Import.class)) {
                String reason = "@JS.import class " + String.valueOf(clazz) + " reachable, registered from " + String.valueOf(JSBodyFeature.class);
                AnalysisType cls = accessImpl.getMetaAccess().lookupJavaType(clazz);
                cls.registerAsInstantiated((Object)reason);
            }
        }, JSObject.class);
        for (Class subclass : accessImpl.findSubclasses(JSValue.class)) {
            if (!(Modifier.isAbstract(subclass.getModifiers()) || JSObject.class != subclass && JSObject.class.isAssignableFrom(subclass))) {
                accessImpl.registerAsInHeap(subclass);
            }
            if (!subclass.isAnnotationPresent(JS.Export.class)) continue;
            accessImpl.registerAsInHeap(subclass);
        }
        bigbang.addRootClass(Nothing.class, true, false);
        bigbang.addRootMethod((Executable)ReflectionUtil.lookupMethod(JSValue.class, (String)"as", (Class[])new Class[]{Class.class}), true, (Object)("JSValue.as, registered in " + String.valueOf(JSBodyFeature.class)), new MultiMethod.MultiMethodKey[0]);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        JSBodyFeature.findJSObjectSubtypes(accessImpl);
    }

    private static void findJSObjectSubtypes(FeatureImpl.DuringAnalysisAccessImpl access) {
        boolean requireAnalysisIteration = false;
        for (Class jsObjectClass : access.findSubclasses(JSObject.class)) {
            AnalysisType type;
            if (jsObjectClass.isAnnotationPresent(JS.Import.class) || !(type = access.getMetaAccess().lookupJavaType(jsObjectClass)).isReachable()) continue;
            for (AnalysisMethod analysisMethod : type.getDeclaredMethods(false)) {
                if (analysisMethod.isDirectRootMethod() || analysisMethod.isVirtualRootMethod()) continue;
                access.registerAsRoot(analysisMethod, false, "JSObject subtype method, registered in " + String.valueOf(JSBodyFeature.class), new MultiMethod.MultiMethodKey[0]);
                requireAnalysisIteration = true;
            }
            for (AnalysisMethod analysisMethod : type.getDeclaredConstructors(false)) {
                if (analysisMethod.isDirectRootMethod() || analysisMethod.isVirtualRootMethod()) continue;
                access.registerAsRoot(analysisMethod, true, "JSObject subtype constructor, registered in " + String.valueOf(JSBodyFeature.class), new MultiMethod.MultiMethodKey[0]);
                requireAnalysisIteration = true;
            }
            for (AnalysisMethod analysisMethod : type.getInstanceFields(false)) {
                AnalysisField field = (AnalysisField)analysisMethod;
                requireAnalysisIteration |= field.registerAsAccessed((Object)"used from web-image");
                requireAnalysisIteration |= field.registerAsWritten((Object)"used from web-image");
                if (field.isUnsafeAccessed()) continue;
                field.registerAsUnsafeAccessed((Object)"used from web-image");
                requireAnalysisIteration = true;
            }
        }
        if (requireAnalysisIteration) {
            access.requireAnalysisIteration();
        }
    }
}

