/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.hosted.DeadlockWatchdog;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.util.Objects;

public interface ClosureCompilerSupport {
    public static boolean isAvailable() {
        return ModuleLayer.boot().findModule("org.graalvm.wrapped.google.closure").isPresent();
    }

    public static ClosureCompilerSupport getClosureSupport(String className, DeadlockWatchdog watchdog, JSCodeGenTool codeGenTool, String imageName) {
        if (!1.$assertionsDisabled && !ClosureCompilerSupport.isAvailable()) {
            throw new AssertionError((Object)"Tried to get closure compiler even though it is not available");
        }
        Class clazz = ReflectionUtil.lookupClass((String)className);
        ClosureCompilerSupport.exportModulePackagesToImplementations(clazz);
        Constructor constructor = ReflectionUtil.lookupConstructor((Class)clazz, (Class[])new Class[]{DeadlockWatchdog.class, JSCodeGenTool.class, String.class});
        return (ClosureCompilerSupport)ReflectionUtil.newInstance((Constructor)constructor, (Object[])new Object[]{watchdog, codeGenTool, imageName});
    }

    private static void exportModulePackagesToImplementations(Class<?> baseClass) {
        Class<?> clazz = baseClass;
        while (!Objects.equals(clazz.getModule(), Object.class.getModule())) {
            for (String systemModule : ModuleSupport.SYSTEM_MODULES) {
                ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.EXPORT, clazz, (boolean)true, (String)systemModule, (String[])new String[0]);
            }
            clazz = clazz.getSuperclass();
        }
    }

    public String applyClosureCompiler(String var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

