/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.Runtime;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionDefinition;
import com.oracle.svm.webimage.functionintrinsics.JSGenericFunctionDefinition;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

public class Array {
    public static void lowerArrrayVTable(JSCodeGenTool jsLTools) {
        JSGenericFunctionDefinition[] constructors = new JSGenericFunctionDefinition[]{Runtime.JsArray, Runtime.Int8Array, Runtime.Uint8Array, Runtime.Int16Array, Runtime.Uint16Array, Runtime.Int32Array, Runtime.BigInt64Array, Runtime.Float32Array, Runtime.Float64Array};
        jsLTools.getCodeBuffer().emitNewLine();
        for (JSGenericFunctionDefinition constructor : constructors) {
            jsLTools.getCodeBuffer().emitNewLine();
            Runtime.arrayVTableInitialization.emitCall((CodeGenTool)jsLTools, new IEmitter[]{Emitter.of((String)constructor.getFunctionName()), Emitter.of((String)"\"vt\""), Emitter.of(Object.class)});
        }
        jsLTools.getCodeBuffer().emitNewLine();
    }

    public static JSFunctionDefinition getInitializer(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return Runtime.ArrayCreateUint8;
            }
            case Byte: {
                return Runtime.ArrayCreateInt8;
            }
            case Short: {
                return Runtime.ArrayCreateInt16;
            }
            case Char: {
                return Runtime.ArrayCreateUint16;
            }
            case Int: {
                return Runtime.ArrayCreateInt32;
            }
            case Float: {
                return Runtime.ArrayCreateFloat32;
            }
            case Double: {
                return Runtime.ArrayCreateFloat64;
            }
            case Long: {
                return Runtime.ArrayCreateLong64;
            }
            case Object: {
                return Runtime.ArrayCreateObject;
            }
        }
        throw VMError.shouldNotReachHere((String)kind.toString());
    }

    public static JSFunctionDefinition getConstructor(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return Runtime.Uint8Array;
            }
            case Byte: {
                return Runtime.Int8Array;
            }
            case Short: {
                return Runtime.Int16Array;
            }
            case Char: {
                return Runtime.Uint16Array;
            }
            case Int: {
                return Runtime.Int32Array;
            }
            case Long: {
                return Runtime.BigInt64Array;
            }
            case Double: {
                return Runtime.Float64Array;
            }
            case Float: {
                return Runtime.Float32Array;
            }
        }
        return Runtime.JsArray;
    }

    public static void lowerNewArray(HostedType elementType, IEmitter length, JSCodeGenTool jsLTools) {
        JavaKind kind = elementType.getJavaKind();
        JSFunctionDefinition init = Array.getInitializer(kind);
        HostedArrayClass arrayClass = elementType.getArrayClass();
        String hubName = jsLTools.getJSProviders().typeControl().requestHubName((ResolvedJavaType)arrayClass);
        init.emitCall((CodeGenTool)jsLTools, new IEmitter[]{length, Emitter.of((String)hubName)});
    }

    public static void lowerNewArray(ValueNode elementType, IEmitter length, JSCodeGenTool jsLTools) {
        Runtime.ArrayCreateHub.emitCall((CodeGenTool)jsLTools, new IEmitter[]{length, Emitter.of((ValueNode)elementType)});
    }

    public static void lowerArrayConstructor(JavaKind kind, int length, JSCodeGenTool jsLTools) {
        Array.getConstructor(kind).emitCall((CodeGenTool)jsLTools, new IEmitter[]{Emitter.of((Integer)length)});
    }
}

