/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.code;

import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.code.WebImageCompileQueue;
import com.oracle.svm.hosted.webimage.compiletasks.Long64PreparationTask;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.spi.CoreProviders;

public class WebImageJSCompileQueue
extends WebImageCompileQueue {
    private final DebugContext debug;

    public WebImageJSCompileQueue(FeatureHandler featureHandler, HostedUniverse hUniverse, RuntimeConfiguration runtimeConfiguration, DebugContext debug) {
        super(featureHandler, hUniverse, runtimeConfiguration, debug);
        this.debug = debug;
    }

    private void prepareLong64Methods() throws InterruptedException {
        this.executor.init();
        this.universe.getMethods().stream().filter(method -> method.compilationInfo.getCompilationGraph() != null).forEach(method -> this.executor.execute((CompletionExecutor.DebugContextRunnable)new Long64PreparationTask((HostedMethod)method, (CoreProviders)this.providers, this.getCustomizedOptions((HostedMethod)method, this.debug))));
        this.executor.start();
        this.executor.complete();
        this.executor.shutdown();
    }

    protected void checkRestrictHeapAnnotations(DebugContext debugParam) {
    }

    @Override
    protected void compileAll() throws InterruptedException {
        try (Timer.StopTimer t = TimerCollection.createTimerAndStart((String)"(prep. long64)");){
            this.prepareLong64Methods();
        }
        super.compileAll();
    }

    protected void checkUninterruptibleAnnotations() {
    }

    public void scheduleEntryPoints() {
        this.universe.getMethods().stream().filter(method -> method.compilationInfo.getCompilationGraph() != null).forEach(method -> this.ensureCompiled((HostedMethod)method, new WebImageCompileQueue.WebImageReason()));
    }
}

