/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.code;

import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import com.oracle.svm.hosted.webimage.metrickeys.UniverseMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.util.Collections;
import java.util.Set;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.MetricKey;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.webimage.api.JSObject;

public abstract class WebImageCompileQueue
extends CompileQueue {
    protected final Providers providers;

    public WebImageCompileQueue(FeatureHandler featureHandler, HostedUniverse hUniverse, RuntimeConfiguration runtimeConfiguration, DebugContext debug) {
        super(debug, featureHandler, hUniverse, runtimeConfiguration, Boolean.valueOf(false), Collections.emptyList());
        this.providers = runtimeConfiguration.getProviders();
    }

    public static void saveCompilationCounters(LoggerScope scope, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
        LoggerContext.currentContext().saveCounters(scope, UniverseMetricKeys.COMPILED_TYPES, UniverseMetricKeys.COMPILED_METHODS);
    }

    protected boolean canBeUsedForInlining(Invoke invoke) {
        HostedMethod method = (HostedMethod)invoke.callTarget().targetMethod();
        if (method.isConstructor() && JSObject.class.isAssignableFrom(method.getDeclaringClass().getJavaClass())) {
            return false;
        }
        return super.canBeUsedForInlining(invoke);
    }

    protected CompileQueue.CompileTask createCompileTask(HostedMethod method, CompileQueue.CompileReason reason) {
        return new WebImageCompileTask(this, method, reason);
    }

    protected void compileAll() throws InterruptedException {
        try (LoggerScope loggerScope = LoggerContext.currentContext().scope("Compile-Queue", WebImageCompileQueue::saveCompilationCounters);){
            super.compileAll();
            for (CompileQueue.CompileTask task : this.compilations.values()) {
                LoggerContext.currentContext().mergeSavedCounters(((WebImageCompileTask)task).getMetrics());
            }
            Set methods = this.getCompilations().keySet();
            LoggerContext.counter(UniverseMetricKeys.COMPILED_TYPES).add(methods.stream().map(ResolvedJavaMethod::getDeclaringClass).distinct().count());
            LoggerContext.counter(UniverseMetricKeys.COMPILED_METHODS).add(methods.size());
        }
    }

    protected Suites createRegularSuites() {
        return GraalConfiguration.hostedInstance().createSuites(HostedOptionValues.singleton(), true, null);
    }

    protected Suites createDeoptTargetSuites() {
        return null;
    }

    protected LIRSuites createLIRSuites() {
        return null;
    }

    protected LIRSuites createDeoptTargetLIRSuites() {
        return null;
    }

    protected void modifyRegularSuites(Suites suites) {
    }

    protected void removeDeoptTargetOptimizations(Suites suites) {
    }

    protected void removeDeoptTargetOptimizations(LIRSuites lirSuites) {
    }

    public class WebImageCompileTask
    extends CompileQueue.CompileTask
    implements CompletionExecutor.DebugContextRunnable {
        public static final String COMPILE_TASK_SCOPE_NAME = "WebImage-Compilation";
        public UnmodifiableEconomicMap<MetricKey, Number> metrics;

        public WebImageCompileTask(WebImageCompileQueue this$0, HostedMethod method, CompileQueue.CompileReason reason) {
            super((CompileQueue)this$0, method, reason);
        }

        public DebugContext.Description getDescription() {
            return new DebugContext.Description((Object)this.method, this.method.getName());
        }

        public void run(DebugContext debug) {
            try (LoggerContext loggerContext = new LoggerContext.Builder(HostedOptionValues.singleton()).stream(WebImageOptions.compilerPrinter(HostedOptionValues.singleton())).deleteMetricFile(false).onCloseHandler(this::saveHighTierCounters).build();){
                try (LoggerScope scope = loggerContext.scope(COMPILE_TASK_SCOPE_NAME);
                     DebugContext.Scope s = debug.scope((Object)"(compilation)", (Object)this.method.compilationInfo.getCompilationGraph(), (Object)this.method, (Object)this);){
                    super.run(debug);
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
            }
        }

        private void saveHighTierCounters(LoggerScope scope, UnmodifiableEconomicMap<MetricKey, LoggableMetric> scopeMetrics) {
            this.metrics = scope.getExtractedMetrics();
        }

        public UnmodifiableEconomicMap<MetricKey, Number> getMetrics() {
            return this.metrics;
        }
    }

    public static class WebImageReason
    extends CompileQueue.CompileReason {
        public WebImageReason() {
            super(null);
        }

        public String toString() {
            return "web-image-entry-point";
        }
    }
}

