/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class WebImageKnownOffsetsFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(KnownOffsets.class, (Object)new KnownOffsets());
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        int vtableBaseOffset = dynamicHubLayout.vTableOffset();
        int vtableEntrySize = dynamicHubLayout.vTableSlotSize;
        int typeIDSlotsOffset = dynamicHubLayout.getClosedTypeWorldTypeCheckSlotsOffset();
        KnownOffsets.singleton().setLazyState(vtableBaseOffset, vtableEntrySize, typeIDSlotsOffset, -1, -1, -1, -1);
    }
}

