/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import java.util.HashMap;
import org.graalvm.nativeimage.ImageSingletons;

public class WebImageJSHeapBreakdownProvider
extends HeapBreakdownProvider {
    protected void calculate(FeatureImpl.BeforeImageWriteAccessImpl access, boolean resourcesAreReachable) {
        long totalByteSize = 0L;
        WebImageJSProviders providers = (WebImageJSProviders)((Object)ImageSingletons.lookup(WebImageProviders.class));
        ConstantIdentityMapping identityMapping = providers.typeControl().getConstantMap().identityMapping;
        HashMap<HostedClass, HeapBreakdownProvider.HeapBreakdownEntry> objectTypeEntries = new HashMap<HostedClass, HeapBreakdownProvider.HeapBreakdownEntry>();
        for (ConstantIdentityMapping.IdentityNode node : identityMapping.identityNodes()) {
            HostedClass type = (HostedClass)providers.getMetaAccess().lookupJavaType(node.getDefinition().getConstant());
            long size = node.getDefinition().getSize();
            objectTypeEntries.computeIfAbsent(type, HeapBreakdownProvider.HeapBreakdownEntry::new).add(size);
            totalByteSize += size;
        }
        this.setTotalHeapSize(totalByteSize);
        this.setBreakdownEntries(objectTypeEntries.values().stream().toList());
    }
}

