/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.svm.core.GCRelatedMXBeans;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.code.SubstrateSuitesCreatorProvider;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.webimage.JSGraphBuilderPlugins;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSBackend;
import com.oracle.svm.hosted.webimage.codegen.WebImageNoRegisterConfig;
import com.oracle.svm.hosted.webimage.codegen.phase.WebImageJSSuitesCreatorProvider;
import com.oracle.svm.hosted.webimage.js.WebImageJSLoweringProvider;
import com.oracle.svm.hosted.webimage.snippets.WebImageIdentityHashCodeSnippets;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageJSPlatform.class})
public class WebImageJSFeature
implements InternalFeature {
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{WebImageIdentityHashCodeSnippets.COMPUTE_IDENTITY_HASH_CODE});
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateRegisterConfigFactory.class, (config, metaAccess, target, preserveFramePointer) -> new WebImageNoRegisterConfig());
        ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(this){

            public SubstrateBackend newBackend(Providers newProviders) {
                return new WebImageJSBackend(newProviders);
            }
        });
        ImageSingletons.add(SubstrateLoweringProviderFactory.class, WebImageJSLoweringProvider::new);
        ImageSingletons.add(TargetGraphBuilderPlugins.class, (Object)new JSGraphBuilderPlugins());
        ImageSingletons.add(SubstrateSuitesCreatorProvider.class, (Object)((Object)new WebImageJSSuitesCreatorProvider()));
        ImageSingletons.add(GCRelatedMXBeans.class, (Object)new GCRelatedMXBeans());
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        SubstrateAllocationSnippets allocationSnippets = (SubstrateAllocationSnippets)ImageSingletons.lookup(SubstrateAllocationSnippets.class);
        SubstrateAllocationSnippets.Templates templates = new SubstrateAllocationSnippets.Templates(options, providers, allocationSnippets);
        templates.registerLowering(lowerings);
    }
}

