/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.svm.core.MissingRegistrationSupport;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.config.HybridLayoutSupport;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.WebImageHost;
import com.oracle.svm.hosted.webimage.WebImageJSHeapBreakdownProvider;
import com.oracle.svm.hosted.webimage.code.WebImageJSCompileQueue;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.LowerableResource;
import com.oracle.svm.hosted.webimage.codegen.LowerableResources;
import com.oracle.svm.hosted.webimage.codegen.WebImageCodeGen;
import com.oracle.svm.hosted.webimage.codegen.WebImageEntryFunctionLowerer;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSCodeGen;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSNodeLowerer;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.codegen.heap.JSBootImageHeapLowerer;
import com.oracle.svm.hosted.webimage.codegen.type.InvokeLoweringUtil;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.pointsto.WebImageMethodTypeFlowBuilder;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmCodeCache;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmHeapBreakdownProvider;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmLMCompileQueue;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmEntryFunctionLowerer;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmLMCodeGen;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.hosted.webimage.wasmgc.WebImageWasmGCCodeCache;
import com.oracle.svm.hosted.webimage.wasmgc.WebImageWasmGCCompileQueue;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCCodeGen;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public class WebImageHostedConfiguration
extends HostedConfiguration {
    public static void setDefaultIfEmpty() {
        if (!ImageSingletons.contains(HostedConfiguration.class)) {
            ImageSingletons.add(HostedConfiguration.class, (Object)((Object)new WebImageHostedConfiguration()));
            CompressEncoding compressEncoding = new CompressEncoding(0L, 0);
            ImageSingletons.add(CompressEncoding.class, (Object)compressEncoding);
            ObjectLayout objectLayout = WebImageHostedConfiguration.createObjectLayout((ObjectLayout.IdentityHashMode)ObjectLayout.IdentityHashMode.OBJECT_HEADER);
            ImageSingletons.add(ObjectLayout.class, (Object)objectLayout);
            ImageSingletons.add(HybridLayoutSupport.class, (Object)new HybridLayoutSupport());
        }
    }

    public SVMHost createHostVM(OptionValues options, ImageClassLoader loader, ClassInitializationSupport classInitializationSupport, AnnotationSubstitutionProcessor annotationSubstitutions, MissingRegistrationSupport missingRegistrationSupport) {
        return new WebImageHost(options, loader, classInitializationSupport, annotationSubstitutions, missingRegistrationSupport);
    }

    public static WebImageHostedConfiguration get() {
        return (WebImageHostedConfiguration)((Object)ImageSingletons.lookup(HostedConfiguration.class));
    }

    public JSCodeBuffer createCodeBuffer(OptionValues options) {
        return new JSCodeBuffer(options);
    }

    public JSBootImageHeapLowerer createBootImageHeapLowerer(WebImageJSProviders providers, JSCodeGenTool jsLTools, ConstantIdentityMapping identityMapping) {
        return new JSBootImageHeapLowerer(providers, jsLTools, identityMapping);
    }

    public WebImageCodeGen createCodeGen(WebImageCodeCache codeCache, List<HostedMethod> hostedEntryPoints, HostedMethod mainEntryPoint, WebImageProviders providers, DebugContext debug, ImageClassLoader imageClassLoader) {
        return switch (WebImageOptions.getBackend()) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> new WebImageJSCodeGen(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, this, imageClassLoader);
            case WebImageOptions.CompilerBackend.WASM -> new WebImageWasmLMCodeGen(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, this);
            case WebImageOptions.CompilerBackend.WASMGC -> new WebImageWasmGCCodeGen(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, this);
        };
    }

    public WebImageJSNodeLowerer createNodeLowerer(JSCodeGenTool jsCodeGenTool) {
        return new WebImageJSNodeLowerer(jsCodeGenTool);
    }

    public WebImageEntryFunctionLowerer getEntryFunctionLowerer() {
        return switch (WebImageOptions.getBackend()) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> new WebImageEntryFunctionLowerer();
            case WebImageOptions.CompilerBackend.WASM, WebImageOptions.CompilerBackend.WASMGC -> new WebImageWasmEntryFunctionLowerer();
        };
    }

    public List<LowerableResource> getAnalysisResources() {
        return Stream.concat(Arrays.stream(LowerableResources.bootstrap), this.getJavaRelatedResources().stream()).collect(Collectors.toList());
    }

    public List<LowerableResource> getJavaRelatedResources() {
        if (WebImageOptions.getBackend() == WebImageOptions.CompilerBackend.JS) {
            return Stream.concat(Stream.concat(Stream.concat(Arrays.stream(LowerableResources.runtime), Arrays.stream(LowerableResources.extra)), LowerableResources.optional.stream()), LowerableResources.thirdParty.stream()).collect(Collectors.toList());
        }
        return List.of();
    }

    public List<LowerableResource> getBootstrapResources() {
        return Arrays.stream(LowerableResources.bootstrap).collect(Collectors.toList());
    }

    public InvokeLoweringUtil getInvokeLoweringUtil() {
        return new InvokeLoweringUtil();
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        return new WebImageMethodTypeFlowBuilder(bb, method, flowsGraph, graphKind);
    }

    public void collectMonitorFieldInfo(BigBang bb, HostedUniverse hUniverse, Set<AnalysisType> immutableTypes) {
    }

    public NativeImageCodeCacheFactory newCodeCacheFactory() {
        return new NativeImageCodeCacheFactory(this){

            public NativeImageCodeCache newCodeCache(CompileQueue compileQueue, NativeImageHeap heap, Platform targetPlatform, Path tempDir) {
                return switch (WebImageOptions.getBackend()) {
                    default -> throw new MatchException(null, null);
                    case WebImageOptions.CompilerBackend.JS -> new WebImageCodeCache(compileQueue.getCompilationResults(), heap);
                    case WebImageOptions.CompilerBackend.WASM -> new WebImageWasmCodeCache(compileQueue.getCompilationResults(), heap);
                    case WebImageOptions.CompilerBackend.WASMGC -> new WebImageWasmGCCodeCache(compileQueue.getCompilationResults(), heap);
                };
            }
        };
    }

    public HeapBreakdownProvider createHeapBreakdownProvider() {
        return switch (WebImageOptions.getBackend()) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> new WebImageJSHeapBreakdownProvider();
            case WebImageOptions.CompilerBackend.WASM, WebImageOptions.CompilerBackend.WASMGC -> new WebImageWasmHeapBreakdownProvider();
        };
    }

    public WebImageProviders createProviders(RuntimeConfiguration runtimeConfig, PrintStream compilerPrinter, DebugContext debug) {
        return switch (WebImageOptions.getBackend()) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> new WebImageJSProviders((CoreProviders)runtimeConfig.getProviders(), compilerPrinter, debug);
            case WebImageOptions.CompilerBackend.WASM -> new WebImageWasmProviders(runtimeConfig, (CoreProviders)runtimeConfig.getProviders(), compilerPrinter, debug);
            case WebImageOptions.CompilerBackend.WASMGC -> new WebImageWasmGCProviders(runtimeConfig, (CoreProviders)runtimeConfig.getProviders(), compilerPrinter, debug);
        };
    }

    public CompileQueue createCompileQueue(DebugContext debug, FeatureHandler featureHandler, HostedUniverse hostedUniverse, RuntimeConfiguration runtimeConfiguration, boolean deoptimizeAll) {
        return switch (WebImageOptions.getBackend()) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> new WebImageJSCompileQueue(featureHandler, hostedUniverse, runtimeConfiguration, debug);
            case WebImageOptions.CompilerBackend.WASM -> new WebImageWasmLMCompileQueue(featureHandler, hostedUniverse, runtimeConfiguration, debug);
            case WebImageOptions.CompilerBackend.WASMGC -> new WebImageWasmGCCompileQueue(featureHandler, hostedUniverse, runtimeConfiguration, debug);
        };
    }
}

