/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.graal.code.SubstratePlatformConfigurationProvider;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import com.oracle.svm.hosted.webimage.NativeImageWasmGeneratorRunner;
import com.oracle.svm.hosted.webimage.WebImageEntryPointData;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.WebImage;
import com.oracle.svm.hosted.webimage.js.JSSubstitutionProcessor;
import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import com.oracle.svm.hosted.webimage.logging.visualization.VisualizationSupport;
import com.oracle.svm.hosted.webimage.metrickeys.UniverseMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.wasm.annotation.WasmStartFunction;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmWebImage;
import com.oracle.svm.webimage.platform.WebImagePlatformConfigurationProvider;
import com.oracle.svm.webimage.wasmgc.annotation.WasmExport;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.MetricKey;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.webimage.api.JS;

public class WebImageGenerator
extends NativeImageGenerator {
    public static final String UNIVERSE_BUILD_SCOPE_NAME = "Universe-Build";
    public static final String COMPILE_QUEUE_SCOPE_NAME = "Compile-Queue";
    public static final String WebImageTotalTime = "total-WebImage";
    public static final String CodegenTimer = "codegen";
    private final Method libraryInit;
    private AbstractImage.NativeImageKind imageKind;

    public WebImageGenerator(ImageClassLoader loader, HostedOptionProvider optionProvider, Pair<Method, CEntryPointData> mainEntryPoint, ProgressReporter reporter) {
        super(loader, optionProvider, mainEntryPoint, reporter);
        this.libraryInit = NativeImageWasmGeneratorRunner.getLibraryEntyPointMethod(loader);
    }

    private static void saveUniverseCounters(LoggerScope scope, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
        LoggerContext.currentContext().saveCounters(scope, UniverseMetricKeys.ANALYSIS_TYPES, UniverseMetricKeys.HOSTED_TYPES, UniverseMetricKeys.ANALYSIS_METHODS, UniverseMetricKeys.HOSTED_METHODS);
    }

    protected void doRun(Map<Method, CEntryPointData> entryPoints, JavaMainWrapper.JavaMainSupport javaMainSupport, String imageName, AbstractImage.NativeImageKind k, SubstitutionProcessor harnessSubstitutions) {
        OptionValues options = HostedOptionValues.singleton();
        WebImageGenerator.setWebImageSystemProperties();
        try (LoggerContext loggerContext = new LoggerContext.Builder(options).stream(WebImageOptions.compilerPrinter(options)).build();){
            try (Timer.StopTimer ignoredTimer = TimerCollection.createTimerAndStart((String)WebImageTotalTime);){
                this.imageKind = k;
                super.doRun(entryPoints, javaMainSupport, imageName, k, (SubstitutionProcessor)new JSSubstitutionProcessor());
                try (LoggerScope universeScope = LoggerContext.currentContext().scope(UNIVERSE_BUILD_SCOPE_NAME, WebImageGenerator::saveUniverseCounters);){
                    LoggerContext.counter(UniverseMetricKeys.ANALYSIS_TYPES).add(this.bb.getUniverse().getTypes().size());
                    LoggerContext.counter(UniverseMetricKeys.ANALYSIS_METHODS).add(this.bb.getUniverse().getMethods().size());
                    LoggerContext.counter(UniverseMetricKeys.HOSTED_TYPES).add(this.hUniverse.getTypes().size());
                    LoggerContext.counter(UniverseMetricKeys.HOSTED_METHODS).add(this.hUniverse.getMethods().size());
                }
            }
            VisualizationSupport.get().visualize(WebImageOptions.compilerPrinter(options));
        }
    }

    protected boolean isStubBasedPluginsSupported() {
        return false;
    }

    protected SubstratePlatformConfigurationProvider getPlatformConfig(MetaAccessProvider aMetaAcess) {
        BarrierSet barrierSet = ((BarrierSetProvider)ImageSingletons.lookup(BarrierSetProvider.class)).createBarrierSet(aMetaAcess);
        return new WebImagePlatformConfigurationProvider(barrierSet);
    }

    protected void createAbstractImage(AbstractImage.NativeImageKind k, List<HostedMethod> hostedEntryPoints, NativeImageHeap heap, HostedMetaAccess hMetaAccess, NativeImageCodeCache codeCache) {
        HostedMethod mainEntryPointMethod = hMetaAccess.lookupJavaMethod(k.isExecutable ? (Executable)this.mainEntryPoint.getLeft() : this.libraryInit);
        this.image = switch (WebImageOptions.getBackend()) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> new WebImage(k, this.hUniverse, hMetaAccess, this.nativeLibraries, heap, codeCache, hostedEntryPoints, this.loader, mainEntryPointMethod);
            case WebImageOptions.CompilerBackend.WASM, WebImageOptions.CompilerBackend.WASMGC -> new WasmWebImage(k, this.hUniverse, hMetaAccess, this.nativeLibraries, heap, codeCache, hostedEntryPoints, this.loader, mainEntryPointMethod);
        };
    }

    private static void setWebImageSystemProperties() {
        System.setProperty("svm.targetName", "Browser");
        System.setProperty("svm.targetArch", "ECMAScript 2015");
        System.setProperty("org.graalvm.nativeimage.kind", "executable");
    }

    protected void setDefaultConfiguration() {
        WebImageHostedConfiguration.setDefaultIfEmpty();
        super.setDefaultConfiguration();
    }

    protected void registerEntryPoints(Map<Method, CEntryPointData> entryPoints) {
        if (WebImageOptions.getBackend() == WebImageOptions.CompilerBackend.WASM || WebImageOptions.getBackend() == WebImageOptions.CompilerBackend.WASMGC) {
            List startFunctions = this.loader.findAnnotatedMethods(WasmStartFunction.class);
            GraalError.guarantee((startFunctions.size() <= 1 ? 1 : 0) != 0, (String)"Only a single start function must exist: %s", (Object)startFunctions);
            if (!startFunctions.isEmpty()) {
                Method startFunction = (Method)startFunctions.getFirst();
                GraalError.guarantee((boolean)Modifier.isStatic(startFunction.getModifiers()), (String)"Start function %s.%s is not static.", (Object)startFunction.getDeclaringClass().getName(), (Object)startFunction.getName());
                GraalError.guarantee((startFunction.getParameterCount() == 0 && startFunction.getReturnType() == Void.TYPE ? 1 : 0) != 0, (String)"Start function %s.%s must not have arguments or a return value.", (Object)startFunction.getDeclaringClass().getName(), (Object)startFunction.getName());
                entryPoints.put(startFunction, null);
            }
            for (Method m : this.loader.findAnnotatedMethods(WasmExport.class)) {
                GraalError.guarantee((boolean)Modifier.isStatic(m.getModifiers()), (String)"Exported method %s.%s is not static. Add a static modifier to the method.", (Object)m.getDeclaringClass().getName(), (Object)m.getName());
                entryPoints.put(m, null);
            }
        }
        if (!this.imageKind.isExecutable) {
            entryPoints.put(this.libraryInit, null);
        }
        for (Class c : this.loader.findAnnotatedClasses(JS.Export.class, false)) {
            for (Method m : c.getDeclaredMethods()) {
                if (!Modifier.isAbstract(m.getModifiers())) continue;
                entryPoints.put(m, null);
            }
        }
    }

    protected void registerEntryPointStubs(Map<Method, CEntryPointData> entryPoints) {
        entryPoints.forEach((method, entryPointData) -> this.bb.addRootMethod((Executable)method, true, (Object)("Entry point, registered in " + String.valueOf(WebImageGenerator.class)), new MultiMethod.MultiMethodKey[0]).registerAsNativeEntryPoint((Object)new WebImageEntryPointData()));
    }

    protected void buildNativeImageHeap(NativeImageHeap heap, NativeImageCodeCache codeCache) {
        if (WebImageOptions.getBackend() != WebImageOptions.CompilerBackend.JS) {
            super.buildNativeImageHeap(heap, codeCache);
        }
    }

    protected void checkForInvalidCallsToEntryPoints() {
    }

    protected SubstrateTargetDescription createTarget() {
        Architecture architecture = GraalAccess.getOriginalTarget().arch;
        return new SubstrateTargetDescription(architecture, false, 16, 0, null);
    }
}

