/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.configure.ReflectionConfigurationParser;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.core.c.ProjectHeaderFile;
import com.oracle.svm.core.c.ProjectHeaderFileHeaderResolversRegistryFeature;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.SystemInOutErrSupport;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.jdk.buildtimeinit.FileSystemProviderBuildTimeInitSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.RealLog;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.reflect.NativeImageConditionResolver;
import com.oracle.svm.hosted.webimage.JSEntryPointRegistry;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.WebImageRuntimeJNIAccessSupport;
import com.oracle.svm.hosted.webimage.codegen.LowerableResources;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.snippets.WebImageNonSnippetLowerings;
import com.oracle.svm.hosted.webimage.wasm.WasmLogHandler;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.webimage.WebImageJSLog;
import com.oracle.svm.webimage.WebImageSystemPropertiesSupport;
import com.oracle.svm.webimage.api.Nothing;
import com.oracle.svm.webimage.fs.FileSystemInitializer;
import com.oracle.svm.webimage.fs.WebImageNIOFileSystemProvider;
import com.oracle.svm.webimage.functionintrinsics.ImplicitExceptions;
import com.oracle.svm.webimage.jni.WebImageNativeLibrarySupport;
import com.oracle.svm.webimage.longemulation.Long64;
import com.oracle.svm.webimage.platform.WebImagePlatform;
import com.oracle.svm.webimage.print.WebImageOutErrPrinters;
import com.oracle.svm.webimage.print.WebImagePrintStream;
import com.oracle.svm.webimage.substitute.WebImageHttpHandlerSubstitutions;
import com.oracle.svm.webimage.substitute.system.WebImageFileSystem;
import com.oracle.svm.webimage.substitute.system.WebImageTempFileHelper;
import com.oracle.svm.webimage.substitute.system.WebImageTempFileHelperSupport;
import com.oracle.svm.webimage.substitute.system.WebImageTempFileHelperSupportWithoutSecureRandom;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;
import org.graalvm.nativeimage.impl.RuntimeSystemPropertiesSupport;
import org.graalvm.webimage.api.JS;
import org.graalvm.webimage.api.JSBigInt;
import org.graalvm.webimage.api.JSBoolean;
import org.graalvm.webimage.api.JSNumber;
import org.graalvm.webimage.api.JSObject;
import org.graalvm.webimage.api.JSString;
import org.graalvm.webimage.api.JSSymbol;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImagePlatform.class})
public class WebImageFeature
implements InternalFeature {
    private final JSEntryPointRegistry entryPointsData = new JSEntryPointRegistry();

    public List<Class<? extends Feature>> getRequiredFeatures() {
        ArrayList<Class<? extends Feature>> result = new ArrayList<Class<? extends Feature>>(1);
        result.add(ProjectHeaderFileHeaderResolversRegistryFeature.class);
        return result;
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        ImplicitExceptions.registerForeignCalls(foreignCalls);
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        Predicate<ResolvedJavaMethod> mustNotAllocatePredicate = null;
        if (hosted) {
            mustNotAllocatePredicate = method -> ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(method);
        }
        WebImageNonSnippetLowerings.registerLowerings(runtimeConfig, mustNotAllocatePredicate, options, providers, lowerings, hosted);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        BigBang bigbang = accessImpl.getBigBang();
        bigbang.addRootField(DynamicHub.class, "companion");
        bigbang.addRootField(DynamicHubCompanion.class, "arrayHub");
        bigbang.addRootClass(Nothing.class, true, false);
        Field codeStart = ReflectionUtil.lookupField(ImageCodeInfo.class, (String)"codeStart");
        access.registerAsAccessed(codeStart);
        if (WebImageOptions.getBackend() == WebImageOptions.CompilerBackend.JS) {
            for (Method method : Long64.class.getDeclaredMethods()) {
                assert (Modifier.isStatic(method.getModifiers())) : method;
                accessImpl.registerAsRoot((Executable)method, true, "Long64 support, registered in " + String.valueOf(WebImageFeature.class), new MultiMethod.MultiMethodKey[0]);
            }
        }
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((String)"org.graalvm.shadowed.com.google.common.jimfs.JimfsFileSystem"), (String)"toPath", (Class[])new Class[]{URI.class})});
        for (GenericDeclaration genericDeclaration : new Class[]{JSNumber.class, JSBigInt.class, JSSymbol.class, JSBoolean.class, JSObject.class, JSString.class}) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor((Class)genericDeclaration, (Class[])new Class[0])});
        }
        LowerableResources.processResources(access, WebImageHostedConfiguration.get());
        Field baseLocaleCacheField = accessImpl.findField("sun.util.locale.BaseLocale$1InterningCache", "CACHE");
        Field localeCacheField = accessImpl.findField("java.util.Locale$LocaleCache", "LOCALE_CACHE");
        access.registerFieldValueTransformer(baseLocaleCacheField, (receiver, originalValue) -> {
            Class referencedKeySetClazz = ReflectionUtil.lookupClass((String)"jdk.internal.util.ReferencedKeySet");
            Method createMethod = ReflectionUtil.lookupMethod((Class)referencedKeySetClazz, (String)"create", (Class[])new Class[]{Boolean.TYPE, Supplier.class});
            Method concurrentHashMapSupplierMethod = ReflectionUtil.lookupMethod((Class)referencedKeySetClazz, (String)"concurrentHashMapSupplier", (Class[])new Class[0]);
            return ReflectionUtil.invokeMethod((Method)createMethod, null, (Object[])new Object[]{true, ReflectionUtil.invokeMethod((Method)concurrentHashMapSupplierMethod, null, (Object[])new Object[0])});
        });
        access.registerFieldValueTransformer(localeCacheField, (receiver, originalValue) -> {
            Class referencedKeyMapClazz = ReflectionUtil.lookupClass((String)"jdk.internal.util.ReferencedKeyMap");
            Method createMethod = ReflectionUtil.lookupMethod((Class)referencedKeyMapClazz, (String)"create", (Class[])new Class[]{Boolean.TYPE, Supplier.class});
            Method concurrentHashMapSupplierMethod = ReflectionUtil.lookupMethod((Class)referencedKeyMapClazz, (String)"concurrentHashMapSupplier", (Class[])new Class[0]);
            return ReflectionUtil.invokeMethod((Method)createMethod, null, (Object[])new Object[]{true, ReflectionUtil.invokeMethod((Method)concurrentHashMapSupplierMethod, null, (Object[])new Object[0])});
        });
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        String entryPointConfig = (String)WebImageOptions.EntryPointsConfig.getValue((OptionValues)ImageSingletons.lookup(HostedOptionValues.class));
        if (entryPointConfig != null) {
            NativeImageConditionResolver conditionResolver = new NativeImageConditionResolver(access.getImageClassLoader(), ClassInitializationSupport.singleton());
            ReflectionConfigurationParser parser = ConfigurationParserUtils.create((ConfigurationFile)ConfigurationFile.REFLECTION, (boolean)false, (ConfigurationConditionResolver)conditionResolver, (ReflectionRegistry)this.entryPointsData, null, null, null, (ImageClassLoader)access.getImageClassLoader());
            try {
                parser.parseAndRegister(Path.of(entryPointConfig, new String[0]).toUri());
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere((String)"Error reading the entry points configuration file: ", (Throwable)ex);
            }
            for (Executable m : this.entryPointsData.entryPoints) {
                AnalysisMethod am = access.getBigBang().addRootMethod(m, true, (Object)("Entry points from " + entryPointConfig + ", registered in " + String.valueOf(WebImageFeature.class)), new MultiMethod.MultiMethodKey[0]);
                SubstrateCompilationDirectives.singleton().registerForcedCompilation((ResolvedJavaMethod)am);
            }
        }
        access.getHostVM().registerNeverInlineTrivialHandler(this::neverInlineTrivial);
        SystemInOutErrSupport.setOut((PrintStream)new WebImagePrintStream(WebImageOutErrPrinters.out));
        SystemInOutErrSupport.setErr((PrintStream)new WebImagePrintStream(WebImageOutErrPrinters.err));
        ImageSingletons.add(RuntimeSystemPropertiesSupport.class, (Object)((Object)new WebImageSystemPropertiesSupport()));
        ImageSingletons.add(SystemPropertiesSupport.class, (Object)((SystemPropertiesSupport)ImageSingletons.lookup(RuntimeSystemPropertiesSupport.class)));
        ImageSingletons.add(NativeImageCodeCacheFactory.class, (Object)HostedConfiguration.instance().newCodeCacheFactory());
        WebImageNamingConvention.initialize();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        FeatureImpl.AfterRegistrationAccessImpl accessImpl = (FeatureImpl.AfterRegistrationAccessImpl)access;
        if (WebImageOptions.supportRuntime(WebImageOptions.VMType.Browser)) {
            ImageSingletons.add(WebImageHttpHandlerSubstitutions.class, (Object)new WebImageHttpHandlerSubstitutions());
        }
        if (((Boolean)WebImageOptions.UseRandomForTempFiles.getValue(HostedOptionValues.singleton())).booleanValue()) {
            ImageSingletons.add(WebImageTempFileHelperSupport.class, (Object)new WebImageTempFileHelperSupportWithoutSecureRandom());
        } else {
            ImageSingletons.add(WebImageTempFileHelperSupport.class, (Object)new WebImageTempFileHelperSupport());
        }
        ProjectHeaderFile.HeaderResolversRegistry.registerAdditionalResolver((ProjectHeaderFile.HeaderResolver)new ProjectHeaderFile.FallbackHeaderResolver("../graal/substratevm/src"));
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.jimfs.SystemJimfsFileSystemProvider", "service provider");
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.collect.MapMakerInternalMap", "service provider");
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.collect.MapMakerInternalMap$1", "service provider");
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.collect.MapMakerInternalMap$EntrySet", "service provider");
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.collect.MapMakerInternalMap$StrongKeyWeakValueSegment", "service provider");
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.collect.MapMakerInternalMap$StrongKeyWeakValueEntry$Helper", "service provider");
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.base.Equivalence$Equals", "service provider");
        rci.initializeAtBuildTime("org.graalvm.shadowed.com.google.common.jimfs.Jimfs", "looks for service provider");
        rci.initializeAtRunTime(WebImageTempFileHelper.class, "instances of Random are not allowed in the image heap");
        rci.initializeAtRunTime(WebImageFileSystem.class, "Static fields need to read system properties at runtime");
        rci.initializeAtRunTime(FileSystemInitializer.class, "Static fields need to read system properties at runtime");
        rci.initializeAtRunTime("java.nio.file.FileSystems$DefaultFileSystemHolder", "Parts of static initializer is substituted to inject custom FileSystemProvider");
        for (Class jsObjectSubclass : accessImpl.findSubclasses(JSObject.class)) {
            rci.initializeAtRunTime(jsObjectSubclass, "Initialize JSObject subclasses at runtime, since their custom constructors create mirrors and set up fields for the mirrors.");
        }
        ImageSingletons.add(PlatformNativeLibrarySupport.class, (Object)((Object)new WebImageNativeLibrarySupport()));
        switch (WebImageOptions.getBackend()) {
            case JS: 
            case WASMGC: {
                Log.setLog((RealLog)new WebImageJSLog());
                break;
            }
            case WASM: {
                Log.finalizeDefaultLogHandler((LogHandler)new WasmLogHandler());
            }
        }
        ImageSingletons.add(JNIAccessFeature.class, (Object)new JNIAccessFeature());
        ImageSingletons.add(RuntimeJNIAccessSupport.class, (Object)new WebImageRuntimeJNIAccessSupport());
        FileSystemProviderBuildTimeInitSupport.register((FileSystemProvider)WebImageNIOFileSystemProvider.INSTANCE);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl accessImpl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        DebugContext debugContext = accessImpl.getDebugContext();
        OptionValues options = debugContext.getOptions();
        ImageSingletons.add(WebImageProviders.class, (Object)((Object)WebImageHostedConfiguration.get().createProviders(accessImpl.getRuntimeConfiguration(), WebImageOptions.compilerPrinter(options), debugContext)));
    }

    private boolean neverInlineTrivial(AnalysisMethod caller, AnalysisMethod callee) {
        return AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, JS.class);
    }
}

