/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.reflect.RuntimeMetadataDecoder;
import com.oracle.svm.hosted.DeadlockWatchdog;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.codegen.WebImageCompilationResult;
import com.oracle.svm.webimage.reflect.WebImageMetadataAccessor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.UnsignedWord;

public class WebImageCodeCache
extends NativeImageCodeCache {
    public final Map<HostedMethod, WebImageCompilationResult> webImageCompilationResults;
    public final NativeImageHeap nativeImageHeap;

    public WebImageCodeCache(Map<HostedMethod, CompilationResult> compilationResultMap, NativeImageHeap imageHeap) {
        super(compilationResultMap, imageHeap);
        this.webImageCompilationResults = compilationResultMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> (WebImageCompilationResult)((Object)((Object)entry.getValue()))));
        this.nativeImageHeap = imageHeap;
    }

    public int getCodeCacheSize() {
        return 0;
    }

    public int codeSizeFor(HostedMethod method) {
        return 0;
    }

    public void layoutMethods(DebugContext debug, BigBang bb) {
    }

    public void buildRuntimeMetadata(DebugContext debug, SnippetReflectionProvider snippetReflectionProvider) {
        this.buildRuntimeMetadata(debug, snippetReflectionProvider, null, null);
    }

    protected ImageCodeInfo.HostedImageCodeInfo installCodeInfo(SnippetReflectionProvider snippetReflection, CFunctionPointer firstMethod, UnsignedWord codeSize, CodeInfoEncoder codeInfoEncoder, NativeImageCodeCache.RuntimeMetadataEncoder runtimeMetadataEncoder, DeadlockWatchdog watchdog) {
        CodeInfoEncoder.Encoders encoders = codeInfoEncoder.getEncoders();
        JavaConstant[] constants = (JavaConstant[])encoders.objectConstants.encodeAll((Object[])new JavaConstant[encoders.objectConstants.getLength()]);
        Class[] classes = (Class[])encoders.classes.encodeAll((Object[])new Class[encoders.classes.getLength()]);
        String[] memberNames = (String[])encoders.memberNames.encodeAll((Object[])new String[encoders.memberNames.getLength()]);
        String[] otherStrings = (String[])encoders.otherStrings.encodeAll((Object[])new String[encoders.otherStrings.getLength()]);
        WebImageMetadataAccessor metadataAccessor = (WebImageMetadataAccessor)RuntimeMetadataDecoder.MetadataAccessor.singleton();
        metadataAccessor.installMetadata(constants, classes, memberNames, otherStrings, codeInfoEncoder);
        runtimeMetadataEncoder.encodeAllAndInstall();
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = CodeInfoTable.getCurrentLayerImageCodeCache().getHostedImageCodeInfo();
        NonmovableArray emptyBytes = NonmovableArrays.createByteArray((int)0, (NmtCategory)NmtCategory.Code);
        CodeInfoAccess.setCodeInfo((CodeInfo)imageCodeInfo, (NonmovableArray)emptyBytes, (NonmovableArray)emptyBytes, (NonmovableArray)emptyBytes);
        CodeInfoAccess.setFrameInfo((CodeInfo)imageCodeInfo, (NonmovableArray)emptyBytes);
        imageCodeInfo.setMethodTable(NonmovableArrays.createByteArray((int)0, (NmtCategory)NmtCategory.Code));
        return null;
    }

    protected boolean verifyMethods(DebugContext debug, HostedUniverse hUniverse, CodeInfoEncoder codeInfoEncoder, CodeInfo codeInfo, FrameInfoDecoder.ConstantAccess constantAccess) {
        return true;
    }

    protected void encodeMethod(CodeInfoEncoder codeInfoEncoder, Pair<HostedMethod, CompilationResult> pair) {
    }

    public void patchMethods(DebugContext debug, RelocatableBuffer relocs, ObjectFile objectFile) {
    }

    public void writeCode(RelocatableBuffer buffer) {
    }

    public NativeImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer buffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
        return null;
    }

    public List<ObjectFile.Symbol> getSymbols(ObjectFile objectFile) {
        return null;
    }
}

