/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import jdk.graal.compiler.core.common.NumUtil;

public final class SourceMapBuilder {
    private static final int VERSION = 3;
    private final String sourceRoot;
    private final LinkedHashMap<String, Integer> sources = new LinkedHashMap();
    private final LinkedHashMap<String, Integer> names = new LinkedHashMap();
    private final Base64VlqListBuilder mappings = new Base64VlqListBuilder();
    private int lastColumn = 0;
    private int lastSrcFileIndex = 0;
    private int lastSrcLine = 0;
    private int lastSrcColumn = 0;
    private int lastSrcNameIndex = 0;
    private boolean shouldAddComma = false;
    private boolean canExtendItem = false;

    public SourceMapBuilder(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public void printTo(PrintWriter out) {
        out.println("{");
        out.printf("\t\"version\": %d,", 3).println();
        out.printf("\t\"sourceRoot\": \"%s\",", this.sourceRoot).println();
        out.printf("\t\"sources\": %s,", SourceMapBuilder.makeJsonStringList(this.sources)).println();
        out.printf("\t\"names\": %s,", SourceMapBuilder.makeJsonStringList(this.names)).println();
        out.printf("\t\"mappings\": \"%s\"", this.mappings).println();
        out.println("}");
    }

    private static String makeJsonStringList(LinkedHashMap<String, ?> map) {
        return map.isEmpty() ? "[]" : map.keySet().stream().collect(Collectors.joining("\", \"", "[\"", "\"]"));
    }

    public void endLine() {
        this.mappings.append(';');
        this.lastColumn = 0;
        this.shouldAddComma = false;
        this.canExtendItem = false;
    }

    public void markSourceLocation(int column, String srcFile, int srcLine, int srcColumn) {
        int srcFileIndex = SourceMapBuilder.addAndGetIndex(this.sources, srcFile);
        if (this.shouldAddComma) {
            this.mappings.append(',');
        } else {
            this.shouldAddComma = true;
        }
        this.mappings.append(column - this.lastColumn);
        this.mappings.append(srcFileIndex - this.lastSrcFileIndex);
        this.mappings.append(srcLine - this.lastSrcLine);
        this.mappings.append(srcColumn - this.lastSrcColumn);
        this.lastColumn = column;
        this.lastSrcFileIndex = srcFileIndex;
        this.lastSrcLine = srcLine;
        this.lastSrcColumn = srcColumn;
        this.canExtendItem = true;
    }

    public void endMark(int column) {
        if (this.shouldAddComma) {
            this.mappings.append(',');
        } else {
            this.shouldAddComma = true;
        }
        this.mappings.append(column - this.lastColumn);
        this.lastColumn = column;
        this.canExtendItem = false;
    }

    public void markSymbol(int column, String srcName) {
        int srcNameIndex = SourceMapBuilder.addAndGetIndex(this.names, srcName);
        if (this.canExtendItem && column == this.lastColumn) {
            this.mappings.append(srcNameIndex - this.lastSrcNameIndex);
            this.lastSrcNameIndex = srcNameIndex;
            this.canExtendItem = false;
            return;
        }
        if (this.shouldAddComma) {
            this.mappings.append(',');
        } else {
            this.shouldAddComma = true;
        }
        this.mappings.append(column - this.lastColumn);
        this.mappings.append(0);
        this.mappings.append(0);
        this.mappings.append(0);
        this.mappings.append(srcNameIndex - this.lastSrcNameIndex);
        this.lastColumn = column;
        this.lastSrcNameIndex = srcNameIndex;
        this.canExtendItem = false;
    }

    private static int addAndGetIndex(LinkedHashMap<String, Integer> map, String element) {
        int newIndex = map.size();
        Integer oldIndex = map.putIfAbsent(element, newIndex);
        return oldIndex != null ? oldIndex : newIndex;
    }

    public static final class Base64VlqListBuilder {
        private static final String BASE64_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        private static final int BITS_PER_DIGIT = 5;
        private static final int DIGIT_MASK = 31;
        private static final int BITS_IN_FIRST_DIGIT = 4;
        private static final int FIRST_DIGIT_MASK = 15;
        private static final int CONTINUATION = 32;
        private final StringBuilder content = new StringBuilder();

        public void append(int i) {
            assert (i != Integer.MIN_VALUE) : "Integer.MIN_VALUE cannot be appended";
            int signBit = -(i >> 31);
            int r = NumUtil.unsafeAbs((int)i);
            int digit = (r & 0xF) << 1 | signBit;
            r >>= 4;
            while (r != 0) {
                this.appendDigit(digit | 0x20);
                digit = r & 0x1F;
                r >>= 5;
            }
            this.appendDigit(digit);
        }

        public void append(char c) {
            this.content.append(c);
        }

        private void appendDigit(int digitValue) {
            this.content.append(BASE64_DIGITS.charAt(digitValue));
        }

        public String toString() {
            return this.content.toString();
        }
    }
}

