/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.ReplacingLocatableMultiOptionValue;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.c.CAnnotationProcessorCache;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import com.oracle.svm.hosted.webimage.WebImageGenerator;
import com.oracle.svm.hosted.webimage.logging.visualization.VisualizationSupport;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.util.BenchmarkLogger;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmLMJavaMainSupport;
import com.oracle.svm.hosted.webimage.wasm.codegen.BinaryenCompat;
import com.oracle.svm.hosted.webimage.wasmgc.WebImageWasmGCJavaMainSupport;
import com.oracle.svm.webimage.WebImageJSJavaMainSupport;
import com.oracle.svm.webimage.WebImageJavaMainSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;

public class NativeImageWasmGeneratorRunner
extends NativeImageGeneratorRunner {
    public static void main(String[] args) {
        new NativeImageWasmGeneratorRunner().start(args);
    }

    private static void dumpProvidedHostedOptions(HostedOptionParser optionParser) {
        EconomicMap allHostedOptions = optionParser.getAllHostedOptions();
        ArrayList<Object> names = new ArrayList<Object>();
        for (OptionDescriptor optionDescriptor : allHostedOptions.getValues()) {
            if (!optionDescriptor.getDeclaringClass().getPackageName().contains("webimage") || WebImageOptions.DebugOptions.DumpProvidedHostedOptionsAndExit == optionDescriptor.getOptionKey() || WebImageOptions.Backend == optionDescriptor.getOptionKey()) continue;
            String name = optionDescriptor.getName();
            if (optionDescriptor.getOptionValueType().equals(Boolean.class)) {
                names.add(name);
                continue;
            }
            names.add(name + "=");
        }
        names.sort(Comparator.naturalOrder());
        for (String string : names) {
            System.out.println(string);
        }
    }

    public int build(ImageClassLoader classLoader) {
        HostedOptionParser optionProvider = classLoader.classLoaderSupport.getHostedOptionParser();
        if (Boolean.TRUE.equals(optionProvider.getHostedValues().get(WebImageOptions.DebugOptions.DumpProvidedHostedOptionsAndExit))) {
            NativeImageWasmGeneratorRunner.dumpProvidedHostedOptions(optionProvider);
            return ExitStatus.OK.getValue();
        }
        optionProvider.getHostedValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
        optionProvider.getHostedValues().put((Object)SubstrateOptions.FallbackThreshold, (Object)0);
        optionProvider.getRuntimeValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
        optionProvider.getHostedValues().put((Object)SubstrateOptions.SupportedGCs, (Object)ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter());
        optionProvider.getHostedValues().put((Object)CAnnotationProcessorCache.Options.UseCAPCache, (Object)false);
        optionProvider.getHostedValues().put((Object)SubstrateOptions.CompilerBackend, (Object)"webImage");
        optionProvider.getHostedValues().put((Object)LocalizationFeature.Options.LocalizationOptimizedMode, (Object)true);
        optionProvider.getHostedValues().put((Object)SubstrateOptions.IncludeMethodData, (Object)false);
        if (!optionProvider.getHostedValues().containsKey((Object)SubstrateOptions.ParseRuntimeOptions)) {
            optionProvider.getHostedValues().put((Object)SubstrateOptions.ParseRuntimeOptions, (Object)false);
        }
        optionProvider.getHostedValues().put((Object)SubstrateOptions.ClosedTypeWorld, (Object)true);
        WebImageOptions.CompilerBackend backend = WebImageOptions.getBackend(classLoader);
        if (backend == WebImageOptions.CompilerBackend.WASM || backend == WebImageOptions.CompilerBackend.WASMGC) {
            optionProvider.getHostedValues().put(WebImageOptions.ClosureCompiler, (Object)false);
            if (backend == WebImageOptions.CompilerBackend.WASMGC && !optionProvider.getHostedValues().containsKey(BinaryenCompat.Options.UseBinaryen)) {
                optionProvider.getHostedValues().put(BinaryenCompat.Options.UseBinaryen, (Object)true);
            }
            if (!optionProvider.getHostedValues().containsKey(WebImageOptions.NamingConvention)) {
                optionProvider.getHostedValues().put(WebImageOptions.NamingConvention, (Object)WebImageNamingConvention.NamingMode.REDUCED);
            }
        }
        if (WebImageOptions.isNativeImageBackend()) {
            optionProvider.getHostedValues().put(VisualizationSupport.Options.Visualization, (Object)"");
        }
        return super.build(classLoader);
    }

    protected void reportEpilog(String imageName, ProgressReporter reporter, ImageClassLoader classLoader, NativeImageGeneratorRunner.BuildOutcome buildOutcome, Throwable vmError, OptionValues parsedHostedOptions) {
        super.reportEpilog(imageName, reporter, classLoader, buildOutcome, vmError, parsedHostedOptions);
        if (buildOutcome.successful()) {
            BenchmarkLogger.printBuildTime((int)TimerCollection.singleton().get(TimerCollection.Registry.TOTAL).getTotalTime(), parsedHostedOptions);
        }
    }

    protected NativeImageGenerator createImageGenerator(ImageClassLoader classLoader, HostedOptionParser optionParser, Pair<Method, CEntryPointData> mainEntryPointData, ProgressReporter reporter) {
        return new WebImageGenerator(classLoader, (HostedOptionProvider)optionParser, mainEntryPointData, reporter);
    }

    protected Pair<Method, CEntryPointData> createMainEntryPointData(AbstractImage.NativeImageKind imageKind, Method mainEntryPoint) {
        return Pair.createLeft((Object)mainEntryPoint);
    }

    protected Method getMainEntryMethod(ImageClassLoader classLoader) throws NoSuchMethodException {
        return switch (WebImageOptions.getBackend(classLoader)) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> WebImageJavaMainSupport.class.getDeclaredMethod("run", String[].class);
            case WebImageOptions.CompilerBackend.WASM -> WebImageWasmLMJavaMainSupport.class.getDeclaredMethod("run", Integer.TYPE, CIntPointer.class, CShortPointer.class);
            case WebImageOptions.CompilerBackend.WASMGC -> WebImageWasmGCJavaMainSupport.class.getDeclaredMethod("run", String[].class);
        };
    }

    protected static Method getLibraryEntyPointMethod(ImageClassLoader classLoader) {
        try {
            return switch (WebImageOptions.getBackend(classLoader)) {
                default -> throw new MatchException(null, null);
                case WebImageOptions.CompilerBackend.JS -> WebImageJavaMainSupport.class.getDeclaredMethod("initializeLibrary", String[].class);
                case WebImageOptions.CompilerBackend.WASM -> WebImageWasmLMJavaMainSupport.class.getDeclaredMethod("initializeLibrary", Integer.TYPE, CIntPointer.class, CShortPointer.class);
                case WebImageOptions.CompilerBackend.WASMGC -> WebImageWasmGCJavaMainSupport.class.getDeclaredMethod("initializeLibrary", String[].class);
            };
        }
        catch (NoSuchMethodException e) {
            throw GraalError.shouldNotReachHere((Throwable)e, (String)"Could not reflectively lookup internal library entry point.");
        }
    }

    protected JavaMainWrapper.JavaMainSupport createJavaMainSupport(Method javaMainMethod, ImageClassLoader classLoader) throws IllegalAccessException {
        return switch (WebImageOptions.getBackend(classLoader)) {
            default -> throw new MatchException(null, null);
            case WebImageOptions.CompilerBackend.JS -> new WebImageJSJavaMainSupport(javaMainMethod);
            case WebImageOptions.CompilerBackend.WASM -> new WebImageWasmLMJavaMainSupport(javaMainMethod);
            case WebImageOptions.CompilerBackend.WASMGC -> new WebImageWasmGCJavaMainSupport(javaMainMethod);
        };
    }

    protected void verifyMainEntryPoint(Method mainEntryPoint) {
    }
}

