/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.hosted.webimage.wasm.WasmLMGraphBuilderPlugins;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.IndexAddressNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.BigIntegerSnippets;
import jdk.graal.compiler.replacements.SnippetSubstitutionInvocationPlugin;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.StringUTF16Snippets;
import jdk.graal.compiler.replacements.TargetGraphBuilderPlugins;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.CurrentIsolate;

public class JSGraphBuilderPlugins
implements TargetGraphBuilderPlugins {
    private static final Word SINGLE_THREAD_SENTINEL = (Word)Word.unsigned((long)94598687557486455L);

    public void registerPlugins(GraphBuilderConfiguration.Plugins plugins, OptionValues options) {
        InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(() -> {
            JSGraphBuilderPlugins.registerCharacterPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerShortPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Int);
            JSGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Long);
            JSGraphBuilderPlugins.registerStringPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerJSCopyOfPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerMathPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerThreadPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerCurrentIsolatePlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.unregisterArrayFillPlugins(invocationPlugins);
        });
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, JavaKind kind) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)declaringClass).setAllowOverwrite(true);
        r.register(new InvocationPlugin("reverseBytes", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
        r.register(new InvocationPlugin("divideUnsigned", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode dividend, ValueNode divisor) {
                return false;
            }
        });
        r.register(new InvocationPlugin("remainderUnsigned", new Type[]{type, type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode dividend, ValueNode divisor) {
                return false;
            }
        });
        r.register(new InvocationPlugin("reverse", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                return false;
            }
        });
        r.register(new InvocationPlugin("bitCount", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
        r.register(new InvocationPlugin("numberOfLeadingZeros", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
        r.register(new InvocationPlugin("numberOfTrailingZeros", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
    }

    private static void registerCharacterPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Character.class).setAllowOverwrite(true);
        r.register(new InvocationPlugin("reverseBytes", new Type[]{Character.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
    }

    private static void registerShortPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Short.class).setAllowOverwrite(true);
        r.register(new InvocationPlugin("reverseBytes", new Type[]{Short.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
    }

    public static void registerStringPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16");
        utf16r.setAllowOverwrite(true);
        utf16r.register(new InvocationPlugin("getChar", new Type[]{byte[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                return false;
            }
        });
        utf16r.register(new InvocationPlugin("putChar", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3) {
                return false;
            }
        });
        InvocationPlugins.Registration r2 = new InvocationPlugins.Registration(plugins, StringUTF16Snippets.class);
        r2.register(new InvocationPlugin("getChar", new Type[]{byte[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.addPush(JavaKind.Char, (ValueNode)new JavaReadNode(JavaKind.Char, (AddressNode)new IndexAddressNode(arg1, (ValueNode)new LeftShiftNode(arg2, (ValueNode)ConstantNode.forInt((int)1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation((JavaKind)JavaKind.Byte), BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                return true;
            }
        });
    }

    private static void registerMathPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Math.class).setAllowOverwrite(true);
        JSGraphBuilderPlugins.unregisterRound(r, "rint");
        JSGraphBuilderPlugins.unregisterMultiplyHigh(r);
    }

    private static void unregisterRound(InvocationPlugins.Registration r, String name) {
        r.register(new InvocationPlugin(name, new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                return false;
            }
        });
    }

    private static void unregisterMultiplyHigh(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin("multiplyHigh", new Type[]{Long.TYPE, Long.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                return false;
            }
        });
        r.register(new InvocationPlugin("unsignedMultiplyHigh", new Type[]{Long.TYPE, Long.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                return false;
            }
        });
    }

    private static void registerJSCopyOfPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Arrays.class).setAllowOverwrite(true);
        r.register(new InvocationPlugin("copyOf", new Type[]{Object[].class, Integer.TYPE, Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3) {
                JavaConstant constant = JavaConstant.defaultForKind((JavaKind)arg3.stamp(NodeView.DEFAULT).getStackKind());
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)b.getMetaAccess()));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_1.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_1, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(Object[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, arg3, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{Object[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forConstant((JavaConstant)JavaConstant.NULL_POINTER, (MetaAccessProvider)b.getMetaAccess()));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(Object[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{byte[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forInt((int)0));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(byte[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{short[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forInt((int)0));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(short[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{int[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forInt((int)0));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(int[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{long[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forLong((long)0L));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(long[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{char[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forInt((int)0));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(char[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{float[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forInt((int)0));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(float[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{double[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forInt((int)0));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(double[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyOf", new Type[]{boolean[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode c = (ConstantNode)b.add((Node)ConstantNode.forBoolean((boolean)false));
                b.addPush(JSCallNode.ARRAYS_COPY_OF_0.stamp().getStackKind(), (ValueNode)new JSCallNode(JSCallNode.ARRAYS_COPY_OF_0, StampFactory.forDeclaredType(null, (JavaType)b.getMetaAccess().lookupJavaType(boolean[].class), (boolean)false).getTrustedStamp(), new ValueNode[]{arg1, arg2, c}));
                return true;
            }
        });
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, BigInteger.class).setAllowOverwrite(true);
        r.register((InvocationPlugin)new SnippetSubstitutionInvocationPlugin<BigIntegerSnippets.Templates>(BigIntegerSnippets.Templates.class, "implMultiplyToLen", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class}){

            public SnippetTemplate.SnippetInfo getSnippet(BigIntegerSnippets.Templates templates) {
                return null;
            }

            public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode[] args) {
                return false;
            }
        });
    }

    public static void registerThreadPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Thread.class).setAllowOverwrite(true);
        r.register(new InvocationPlugin("onSpinWait", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return false;
            }
        });
    }

    public static void registerCurrentIsolatePlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CurrentIsolate.class).setAllowOverwrite(true);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getCurrentThread", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)SINGLE_THREAD_SENTINEL.rawValue()));
                return true;
            }
        });
    }
}

