/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.svm.hosted.webimage.SourceMapBuilder;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSNodeLowerer;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.webimage.JSKeyword;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class JSCodeBuffer
extends CodeBuffer {
    private static final byte SOURCE_MAP_EXPECTED_LINE_SEPARATOR = 10;
    private final SourceMapBuilder sourceMapBuilder;
    private int column;

    public JSCodeBuffer(OptionValues options) {
        this.sourceMapBuilder = (Boolean)WebImageOptions.GenerateSourceMap.getValue(options) != false ? new SourceMapBuilder((String)WebImageOptions.SourceMapSourceRoot.getValue(options)) : null;
        this.column = 0;
    }

    public void emitSourceMap(Path f) {
        try (PrintWriter ps = new PrintWriter(f.toFile(), "UTF-8");){
            this.sourceMapBuilder.printTo(ps);
        }
        catch (Exception e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    private void updateSourceMapPosition(byte[] b) {
        if (this.sourceMapBuilder == null) {
            return;
        }
        for (byte bi : b) {
            if (bi == 10) {
                this.column = 0;
                this.sourceMapBuilder.endLine();
                continue;
            }
            ++this.column;
        }
    }

    protected void emitMultLineCommentStart() {
        this.emitKeyword(JSKeyword.MultiLineCommentStart);
    }

    protected void emitMultLineCommentEnd() {
        this.emitKeyword(JSKeyword.MultiLineCommentEnd);
    }

    public void emitCode(byte[] b) {
        this.updateSourceMapPosition(b);
        super.emitCode(b);
    }

    public void emitBoolLiteral(boolean b) {
        this.emitText(b ? "1" : "0");
    }

    public void emitDeclarationPrefix() {
        this.emitKeyword(JSKeyword.VAR);
        this.emitWhiteSpace();
    }

    public void emitLetDeclarationPrefix() {
        this.emitKeyword(JSKeyword.LET);
        this.emitWhiteSpace();
    }

    public void emitConstDeclarationPrefix() {
        this.emitKeyword(JSKeyword.CONST);
        this.emitWhiteSpace();
    }

    public void emitLetDeclPrefix(String name) {
        this.emitLetDeclarationPrefix();
        this.emitDeclarationName(name);
        this.emitWhiteSpace();
        this.emitAssignmentSymbol();
        this.emitWhiteSpace();
    }

    public void emitConstDeclPrefix(String name) {
        this.emitConstDeclarationPrefix();
        this.emitDeclarationName(name);
        this.emitWhiteSpace();
        this.emitAssignmentSymbol();
        this.emitWhiteSpace();
    }

    public void emitAnonymousClassHeader(String superClass) {
        this.emitKeyword(JSKeyword.CLASS);
        this.emitWhiteSpace();
        if (superClass != null && !superClass.isEmpty()) {
            this.emitKeyword(JSKeyword.EXTENDS);
            this.emitWhiteSpace();
            this.emitText(superClass);
            this.emitWhiteSpace();
        }
        this.emitScopeBegin();
    }

    public void emitEscapedStringLiteral(Reader r) throws IOException {
        int newlineChar = 10;
        int backslashChar = 92;
        int quoteChar = 34;
        int minAsciiNonControl = 32;
        int maxAsciiNonControl = 126;
        int xEscapeMax = 255;
        byte[] quote = new byte[]{34};
        byte[] newlineEscape = "\\n\" +".getBytes();
        byte[] backslashEscape = "\\\\".getBytes();
        byte[] quoteEscape = "\\\"".getBytes();
        byte[] xEscape = "\\x##".getBytes();
        byte[] uEscape = "\\u####".getBytes();
        byte[] noEscape = new byte[1];
        this.emitCode(quote);
        block6: while (true) {
            int c = r.read();
            switch (c) {
                case -1: {
                    this.emitCode(quote);
                    return;
                }
                case 10: {
                    this.emitCode(newlineEscape);
                    this.emitNewLine();
                    this.emitCode(quote);
                    continue block6;
                }
                case 92: {
                    this.emitCode(backslashEscape);
                    continue block6;
                }
                case 34: {
                    this.emitCode(quoteEscape);
                    continue block6;
                }
            }
            if (c >= 32 && c <= 126) {
                noEscape[0] = (byte)c;
                this.emitCode(noEscape);
                continue;
            }
            if (c <= 255) {
                xEscape[2] = JSCodeBuffer.hexDigit(c >> 4);
                xEscape[3] = JSCodeBuffer.hexDigit(c);
                this.emitCode(xEscape);
                continue;
            }
            uEscape[2] = JSCodeBuffer.hexDigit(c >> 12);
            uEscape[3] = JSCodeBuffer.hexDigit(c >> 8);
            uEscape[4] = JSCodeBuffer.hexDigit(c >> 4);
            uEscape[5] = JSCodeBuffer.hexDigit(c);
            this.emitCode(uEscape);
        }
    }

    private static byte hexDigit(int value) {
        return (byte)Character.forDigit(value & 0xF, 16);
    }

    public void infoDump(WebImageProviders providers) {
        long numBytes = LoggerContext.counter(ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE).get();
        providers.stdout().println("---------------------------------------------------------------------");
        providers.stdout().println("\t Image Size is: " + JSCodeBuffer.bytesToString(numBytes, true) + " (" + numBytes + "B)");
        providers.stdout().println("---------------------------------------------------------------------");
    }

    public static String bytesToString(long bytes, boolean si) {
        int u;
        int n = u = si ? 1000 : 1024;
        if (bytes < (long)u) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(u));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(u, exp), pre);
    }

    private void emitParameterDeclaration(String name, ResolvedJavaType type) {
        this.emitText(name);
    }

    public static String getParamName(int i) {
        return "p" + i;
    }

    public void emitMethodHeader(ResolvedJavaMethod method, String name, Signature sig, List<ParameterNode> parameters) {
        String file;
        assert (this.scopeIndent == 1) : "Scope indent must be 1 for method lowering: " + name + ", current = " + this.scopeIndent;
        this.emitNewLine();
        if (method != null) {
            if (WebImageOptions.genJSComments(WebImageOptions.CommentVerbosity.VERBOSE)) {
                this.emitComment(method.toString());
                this.emitNewLine();
            } else if (WebImageOptions.genJSComments(WebImageOptions.CommentVerbosity.MINIMAL)) {
                this.emitComment(method.format("%H.%n(%P)%R"));
                this.emitNewLine();
            }
        }
        if (method != null && method.isStatic()) {
            this.emitText("static ");
        }
        if (this.sourceMapBuilder != null && method != null && (file = method.getDeclaringClass().getSourceFileName()) != null) {
            LineNumberTable lineNumberTable = method.getLineNumberTable();
            int line = lineNumberTable == null ? 0 : lineNumberTable.getLineNumbers()[0] - 1;
            this.markSourceLocation(file, line, 0);
            this.markSymbol(method.getName());
        }
        this.emitText(name);
        this.emitKeyword(JSKeyword.LPAR);
        boolean useReceiver = method == null || !method.isStatic();
        int psize = sig.getParameterCount(useReceiver);
        for (int i = 0; i < psize; ++i) {
            String pname = JSCodeBuffer.getParamName(i);
            if (this.sourceMapBuilder != null && method != null) {
                if (!method.hasBytecodes() || method.getParameters() == null) {
                    if (method.hasBytecodes()) {
                        LogUtils.warning((String)("The method " + method.format("%H.%n(%R)") + " is not compiled with -parameters. No parameter mapping in source map."));
                    }
                } else {
                    this.markSymbol(JSCodeBuffer.getOrigParamName(method, i));
                }
            }
            this.emitParameterDeclaration(pname, null);
            if (i >= psize - 1) continue;
            this.emitKeyword(JSKeyword.COMMA);
        }
        this.emitKeyword(JSKeyword.RPAR);
        this.emitWhiteSpace();
        this.emitScopeBegin();
    }

    protected String stripCommentMultiline(String s) {
        char[] b = s.toCharArray();
        for (int i = 0; i < b.length; ++i) {
            char c = b[i];
            if (c == '\n' || c >= ' ' && c <= '~' && c != '\\') continue;
            b[i] = 46;
        }
        return new String(b).replace(JSKeyword.MultiLineCommentStart.toString(), "..").replace(JSKeyword.MultiLineCommentEnd.toString(), "..");
    }

    public void emitIfHeaderLeft() {
        this.emitKeyword(JSKeyword.IF);
        this.emitKeyword(JSKeyword.LPAR);
    }

    public void emitIfHeaderRight() {
        this.emitKeyword(JSKeyword.RPAR);
        this.emitScopeBegin();
    }

    public void emitScopeBegin() {
        this.emitKeyword(JSKeyword.LBRACE);
        this.scopeBegin();
        this.emitNewLine();
    }

    public void emitScopeEnd() {
        this.scopeEnd();
        this.emitKeyword(JSKeyword.RBRACE);
    }

    public void emitElse() {
        this.scopeEnd();
        this.emitKeyword(JSKeyword.RBRACE);
        this.emitKeyword(JSKeyword.ELSE);
        this.emitScopeBegin();
    }

    public void emitWhileTrueHeader() {
        this.emitKeyword(JSKeyword.WHILE);
        this.emitKeyword(JSKeyword.LPAR);
        this.emitKeyword(JSKeyword.TRUE);
        this.emitKeyword(JSKeyword.RPAR);
        this.emitScopeBegin();
    }

    protected void emitBreakSymbol() {
        this.emitKeyword(JSKeyword.BREAK);
    }

    public void emitBreakLabel(String labelName) {
        this.emitKeyword(JSKeyword.BREAK);
        this.emitWhiteSpace();
        this.emitText(labelName);
        this.emitInsEnd();
    }

    protected void emitContinueSymbol() {
        this.emitKeyword(JSKeyword.CONTINUE);
    }

    public void emitReturnSymbol() {
        this.emitKeyword(JSKeyword.RETURN);
    }

    public void emitSwitchHeaderLeft() {
        this.emitKeyword(JSKeyword.SWITCH);
        this.emitKeyword(JSKeyword.LPAR);
    }

    public void emitLabel(String labelName) {
        this.emitText(labelName);
        this.emitKeyword(JSKeyword.COLON);
    }

    public void emitIntCaseChain(int[] val) {
        for (int j : val) {
            this.emitKeyword(JSKeyword.CASE);
            this.emitWhiteSpace();
            this.emitIntLiteral(j);
            this.emitKeyword(JSKeyword.COLON);
        }
        this.emitScopeBegin();
    }

    public void emitDefaultCase() {
        this.emitKeyword(JSKeyword.DEFAULT);
        this.emitKeyword(JSKeyword.COLON);
        this.emitScopeBegin();
    }

    public void emitAssignmentSymbol() {
        this.emitKeyword(JSKeyword.Assignment);
    }

    protected void emitNewSymbol() {
        this.emitKeyword(JSKeyword.NEW);
    }

    protected void emitTrySymbol() {
        this.emitKeyword(JSKeyword.TRY);
    }

    public void emitCatch(String expName) {
        this.emitScopeEnd();
        this.emitKeyword(JSKeyword.CATCH);
        this.emitKeyword(JSKeyword.LPAR);
        this.emitWhiteSpace();
        this.emitText(expName);
        this.emitWhiteSpace();
        this.emitKeyword(JSKeyword.RPAR);
        this.emitWhiteSpace();
        this.emitScopeBegin();
    }

    public void emitCatch(String expName, ResolvedJavaType type) {
        this.emitCatch(expName);
    }

    public void emitInsEnd() {
        this.emitKeyword(JSKeyword.Semicolon);
        this.emitNewLine();
    }

    private static String getOrigParamName(ResolvedJavaMethod method, int index) {
        int i = index;
        if (!method.isStatic()) {
            if (i == 0) {
                return "this?";
            }
            --i;
        }
        return method.getParameters()[i].getName() + "?";
    }

    public void emitFunctionEnd() {
        super.emitFunctionEnd();
        if (this.sourceMapBuilder != null) {
            this.sourceMapBuilder.endMark(this.column);
        }
    }

    public void markSourceLocation(String srcFile, int srcLine, int srcColumn) {
        this.checkSourceMapsEnabled();
        this.sourceMapBuilder.markSourceLocation(this.column, srcFile, srcLine, srcColumn);
    }

    public void markSymbol(String srcName) {
        this.checkSourceMapsEnabled();
        this.sourceMapBuilder.markSymbol(this.column, srcName);
    }

    private void checkSourceMapsEnabled() {
        if (this.sourceMapBuilder == null) {
            throw new IllegalStateException("Source maps are not enabled");
        }
    }

    public String getStringLiteral(String s) {
        return WebImageJSNodeLowerer.getStringLiteral(s);
    }
}

