/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.CodeSizeDiagnostics;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class CodeSizeDiagnosticsFeature
implements InternalFeature {
    CodeSizeDiagnosticsFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return (Boolean)CodeSizeDiagnostics.Options.CodeSizeDiagnostics.getValue();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        CodeSizeDiagnostics data = new CodeSizeDiagnostics();
        ImageSingletons.add(CodeSizeDiagnostics.class, (Object)data);
        FeatureImpl.AfterAnalysisAccessImpl config = (FeatureImpl.AfterAnalysisAccessImpl)access;
        for (AnalysisMethod method : config.getUniverse().getMethods()) {
            if (!method.isReachable()) continue;
            EconomicSet callees = (EconomicSet)data.calleesMap.get((Object)method);
            if (callees == null) {
                callees = EconomicSet.create((int)8);
                data.calleesMap.put((Object)method, (Object)callees);
            }
            for (InvokeInfo invokeInfo : method.getInvokes()) {
                callees.addAll((Iterable)invokeInfo.getAllCallees());
            }
        }
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        CodeSizeDiagnostics.write(access);
    }
}

