/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class CodeSizeDiagnostics {
    final EconomicMap<AnalysisMethod, EconomicSet<AnalysisMethod>> calleesMap = EconomicMap.create((int)1024);
    private Function<HostedMethod, Integer> methodSizeProvider;

    public static void installMethodSizeProvider(Function<HostedMethod, Integer> methodSizeProvider) {
        if (!((Boolean)Options.CodeSizeDiagnostics.getValue()).booleanValue()) {
            return;
        }
        CodeSizeDiagnostics self = (CodeSizeDiagnostics)ImageSingletons.lookup(CodeSizeDiagnostics.class);
        self.methodSizeProvider = methodSizeProvider;
    }

    public static void write(Feature.AfterImageWriteAccess access) {
        HostedUniverse universe = ((FeatureImpl.AfterImageWriteAccessImpl)access).getUniverse();
        CodeSizeDiagnostics self = (CodeSizeDiagnostics)ImageSingletons.lookup(CodeSizeDiagnostics.class);
        ReportUtils.report((String)"Dependency and code size", (Path)CodeSizeDiagnostics.getFile().toPath(), (boolean)false, os -> {
            try (PrintWriter pw = new PrintWriter((OutputStream)os);){
                self.dumpMethods(pw, universe);
            }
        });
    }

    private static File getFile() {
        return ReportUtils.reportFile((String)SubstrateOptions.reportsPath(), (String)"dependencies", (String)"csv");
    }

    private void dumpMethods(PrintWriter out, HostedUniverse universe) {
        for (HostedMethod method : universe.getMethods()) {
            if (!method.wrapped.isReachable()) continue;
            out.print(method.format("%H.%n(%p)").replaceAll(",", ";"));
            out.print(", ");
            out.print(method.wrapped.getId());
            out.print(", ");
            Integer size = this.methodSizeProvider.apply(method);
            out.print(size == null ? 0 : size);
            out.print(",");
            for (AnalysisMethod callee : (EconomicSet)this.calleesMap.get((Object)method.wrapped)) {
                out.print(' ');
                out.print(callee.getId());
            }
            out.println();
        }
    }

    static class Options {
        public static final HostedOptionKey<Boolean> CodeSizeDiagnostics = new HostedOptionKey((Object)false);

        Options() {
        }
    }
}

