/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.codegen.JSIntrinsifyFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.ResolvedJavaField;

public class AnalysisUtil {
    public static boolean processFileData(FeatureImpl.BeforeAnalysisAccessImpl access, JSIntrinsifyFile.FileData data) {
        boolean didRegister = false;
        block0: for (JSIntrinsifyFile.JSIntrinsification i : data.intrinsics) {
            AnalysisType t;
            Class clazz;
            if (i instanceof JSIntrinsifyFile.MethodIntrinsification) {
                JSIntrinsifyFile.MethodIntrinsification mi = (JSIntrinsifyFile.MethodIntrinsification)i;
                clazz = access.findClassByName(mi.precedingType.name);
                if (clazz == null) continue;
                for (Class c : access.reachableSubtypes(clazz)) {
                    if (!AnalysisUtil.registerAccessToMethods(access, c, mi)) continue;
                    didRegister = true;
                }
                continue;
            }
            if (i instanceof JSIntrinsifyFile.TypeIntrinsification) {
                JSIntrinsifyFile.TypeIntrinsification ti = (JSIntrinsifyFile.TypeIntrinsification)i;
                clazz = access.findClassByName(ti.name);
                t = access.getMetaAccess().lookupJavaType(clazz);
                if (!t.registerAsReachable((Object)"is used by TypeIntrinsifications in Web Image")) continue;
                didRegister = true;
                continue;
            }
            if (i instanceof JSIntrinsifyFile.FieldIntrinsification) {
                JSIntrinsifyFile.FieldIntrinsification fi = (JSIntrinsifyFile.FieldIntrinsification)i;
                clazz = access.findClassByName(fi.precedingType.name);
                t = access.getMetaAccess().lookupJavaType(clazz);
                ResolvedJavaField[] instanceFields = t.getInstanceFields(false);
                ResolvedJavaField[] staticFields = t.getStaticFields();
                List fields = Stream.concat(Arrays.stream(instanceFields), Arrays.stream(staticFields)).collect(Collectors.toList());
                for (ResolvedJavaField field : fields) {
                    if (!field.getName().equals(fi.name)) continue;
                    if (!((AnalysisField)field).registerAsAccessed((Object)"is used by FieldIntrinsification in Web Image")) continue block0;
                    didRegister = true;
                    continue block0;
                }
                continue;
            }
            GraalError.shouldNotReachHere((String)i.toString());
        }
        return didRegister;
    }

    private static boolean registerAccessToMethods(FeatureImpl.BeforeAnalysisAccessImpl access, Class<?> clazz, JSIntrinsifyFile.MethodIntrinsification mi) {
        AnalysisMetaAccess meta = access.getMetaAccess();
        boolean didRegister = false;
        if (mi.name.equals("<init>")) {
            Constructor<?>[] constructors;
            assert (mi.sig != null);
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                String signature = AnalysisUtil.getSignatureString(constructor);
                if (!signature.equals(mi.sig)) continue;
                AnalysisMethod analysisMethod = meta.lookupJavaMethod(constructor);
                if (analysisMethod.isInvoked()) break;
                access.registerAsRoot(constructor, false, "Constructor accessed reflectively from JS, registered in " + String.valueOf(AnalysisUtil.class), new MultiMethod.MultiMethodKey[0]);
                didRegister = true;
                break;
            }
        } else {
            for (Method candidate : clazz.getDeclaredMethods()) {
                AnalysisMethod aMethod;
                if (!candidate.getName().equals(mi.name) || Modifier.isAbstract((aMethod = meta.lookupJavaMethod((Executable)candidate)).getModifiers()) || aMethod.isInvoked()) continue;
                access.registerAsRoot(aMethod, false, "Methods accessed reflectively from JS, registered in " + String.valueOf(AnalysisUtil.class), new MultiMethod.MultiMethodKey[0]);
                didRegister = true;
            }
        }
        return didRegister;
    }

    private static String getSignatureString(Constructor<?> constructor) {
        Class<?>[] parameters;
        StringBuilder sb = new StringBuilder();
        for (Class<?> parameter : parameters = constructor.getParameterTypes()) {
            sb.append(parameter.getName());
        }
        return sb.toString();
    }
}

