// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: VMInspectionOptions.java
package com.oracle.svm.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class VMInspectionOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AllowVMInspection": {
            return OptionDescriptor.create(
                /*name*/ "AllowVMInspection",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables features that allow the VM to be inspected during run time.",
                /*declaringClass*/ VMInspectionOptions.DeprecatedOptions.class,
                /*fieldName*/ "AllowVMInspection",
                /*option*/ VMInspectionOptions.DeprecatedOptions.AllowVMInspection,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--enable-monitoring'");
        }
        case "DumpRuntimeCompilationOnSignal": {
            return OptionDescriptor.create(
                /*name*/ "DumpRuntimeCompilationOnSignal",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dumps all runtime compiled methods on SIGUSR2.",
                /*declaringClass*/ VMInspectionOptions.class,
                /*fieldName*/ "DumpRuntimeCompilationOnSignal",
                /*option*/ VMInspectionOptions.DumpRuntimeCompilationOnSignal,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpThreadStacksOnSignal": {
            return OptionDescriptor.create(
                /*name*/ "DumpThreadStacksOnSignal",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dumps all thread stacktraces on SIGQUIT/SIGBREAK.",
                /*declaringClass*/ VMInspectionOptions.DeprecatedOptions.class,
                /*fieldName*/ "DumpThreadStacksOnSignal",
                /*option*/ VMInspectionOptions.DeprecatedOptions.DumpThreadStacksOnSignal,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--enable-monitoring=threaddump'");
        }
        case "EnableMonitoringFeatures": {
            return OptionDescriptor.create(
                /*name*/ "EnableMonitoringFeatures",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Enable monitoring features that allow the VM to be inspected at run time. Comma-separated list can contain 'heapdump', 'jfr', 'jvmstat', 'jmxserver' (experimental), 'jmxclient' (experimental), 'threaddump', 'nmt' (experimental), 'jcmd' (experimental), or 'all' (deprecated behavior: defaults to 'all' if no argument is provided). For example: '--enable-monitoring=heapdump,jfr'.",
                /*declaringClass*/ VMInspectionOptions.class,
                /*fieldName*/ "EnableMonitoringFeatures",
                /*option*/ VMInspectionOptions.EnableMonitoringFeatures,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintNMTStatistics": {
            return OptionDescriptor.create(
                /*name*/ "PrintNMTStatistics",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print native memory tracking statistics on shutdown if native memory tracking is enabled.",
                /*declaringClass*/ VMInspectionOptions.class,
                /*fieldName*/ "PrintNMTStatistics",
                /*option*/ VMInspectionOptions.PrintNMTStatistics,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 5;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllowVMInspection");
                    case 1: return get("DumpRuntimeCompilationOnSignal");
                    case 2: return get("DumpThreadStacksOnSignal");
                    case 3: return get("EnableMonitoringFeatures");
                    case 4: return get("PrintNMTStatistics");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
