/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.util.GraalAccess;
import java.util.Objects;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public interface OriginalClassProvider {
    public static ResolvedJavaType getOriginalType(JavaType type) {
        JavaType cur = type;
        while (cur instanceof OriginalClassProvider) {
            OriginalClassProvider originalClassProvider = (OriginalClassProvider)cur;
            cur = originalClassProvider.unwrapTowardsOriginalType();
        }
        return Objects.requireNonNull((ResolvedJavaType)cur);
    }

    public static Class<?> getJavaClass(JavaType type) {
        Class result = GraalAccess.getOriginalSnippetReflection().originalClass(OriginalClassProvider.getOriginalType(type));
        return Objects.requireNonNull(result);
    }

    public ResolvedJavaType unwrapTowardsOriginalType();
}

