/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.builder;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AlwaysEnabledPredicateFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.nodes.ParameterNode;

public class TypeFlowGraphBuilder {
    private final PointsToAnalysis bb;
    private final List<TypeFlowBuilder<?>> dataFlowSinkBuilders;
    private static final List<String> waitNotifyHashCodeMethods = new ArrayList<String>();

    public TypeFlowGraphBuilder(PointsToAnalysis bb) {
        this.bb = bb;
        this.dataFlowSinkBuilders = new ArrayList();
    }

    public void registerSinkBuilder(TypeFlowBuilder<?> sinkBuilder) {
        this.dataFlowSinkBuilders.add(sinkBuilder);
    }

    private static String format(Method m) {
        return m.getDeclaringClass().getName() + "." + m.getName() + "(" + Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", ")) + ")";
    }

    public void checkFormalParameterBuilder(TypeFlowBuilder<?> paramBuilder) {
        AnalysisMethod method = (AnalysisMethod)((ParameterNode)paramBuilder.getSource()).graph().method();
        String methodFormat = method.getQualifiedName();
        for (String specialMethodFormat : waitNotifyHashCodeMethods) {
            if (!methodFormat.equals(specialMethodFormat)) continue;
            this.dataFlowSinkBuilders.add(paramBuilder);
        }
    }

    public List<TypeFlow<?>> build() {
        ArrayList postInitFlows = new ArrayList();
        HashSet<TypeFlowBuilder> processed = new HashSet<TypeFlowBuilder>();
        ArrayDeque workQueue = new ArrayDeque();
        for (TypeFlowBuilder<?> sinkBuilder : this.dataFlowSinkBuilders) {
            if (processed.contains(sinkBuilder)) continue;
            workQueue.addLast(sinkBuilder);
            while (!workQueue.isEmpty()) {
                TypeFlowBuilder builder = (TypeFlowBuilder)workQueue.removeFirst();
                if (!processed.add(builder)) continue;
                Object flow = builder.get();
                Object predicate = builder.getPredicate();
                if (predicate != null) {
                    assert (this.bb.usePredicates()) : "Predicates should only be used with -H:+UsePredicates.";
                    if (predicate instanceof TypeFlowBuilder) {
                        TypeFlowBuilder singlePredicate = (TypeFlowBuilder)predicate;
                        ((TypeFlow)singlePredicate.get()).addPredicated(this.bb, (TypeFlow<?>)flow);
                        if (!processed.contains(singlePredicate)) {
                            workQueue.addLast(singlePredicate);
                        }
                    } else {
                        List predicateList = (List)predicate;
                        for (TypeFlowBuilder p : predicateList) {
                            ((TypeFlow)p.get()).addPredicated(this.bb, (TypeFlow<?>)flow);
                            if (processed.contains(p)) continue;
                            workQueue.addLast(p);
                        }
                    }
                } else {
                    assert (!this.bb.usePredicates() || flow instanceof AlwaysEnabledPredicateFlow) : "Flow " + String.valueOf(flow) + " does not have a predicate.";
                    ((TypeFlow)flow).enableFlow(this.bb.analysisPolicy().isContextSensitiveAnalysis() ? null : this.bb);
                }
                if (this.bb.isBaseLayerAnalysisEnabled()) {
                    ((TypeFlow)flow).enableFlow(this.bb.analysisPolicy().isContextSensitiveAnalysis() ? null : this.bb);
                }
                if (((TypeFlow)flow).needsInitialization()) {
                    postInitFlows.add((TypeFlow<?>)flow);
                }
                PointsToStats.registerTypeFlowRetainReason(this.bb, flow, (sinkBuilder.isBuildingAnActualParameter() ? "ActualParam=" : "") + ClassUtil.getUnqualifiedName(sinkBuilder.getFlowClass()));
                for (TypeFlowBuilder<?> useDependency : builder.getUseDependencies()) {
                    if (!processed.contains(useDependency)) {
                        workQueue.addLast(useDependency);
                    }
                    this.bb.analysisPolicy().addOriginalUse(this.bb, (TypeFlow<?>)useDependency.get(), (TypeFlow<?>)flow);
                }
                for (TypeFlowBuilder<?> observerDependency : builder.getObserverDependencies()) {
                    if (!processed.contains(observerDependency)) {
                        workQueue.addLast(observerDependency);
                    }
                    this.bb.analysisPolicy().addOriginalObserver(this.bb, (TypeFlow<?>)observerDependency.get(), (TypeFlow<?>)flow);
                }
            }
        }
        return postInitFlows;
    }

    static {
        try {
            Method wait = Object.class.getMethod("wait", Long.TYPE);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(wait));
            Method notify = Object.class.getMethod("notify", new Class[0]);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(notify));
            Method notifyAll = Object.class.getMethod("notifyAll", new Class[0]);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(notifyAll));
            Method hashCode = System.class.getMethod("identityHashCode", Object.class);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(hashCode));
        }
        catch (NoSuchMethodException e) {
            throw AnalysisError.shouldNotReachHere(e);
        }
    }
}

