/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.diagnosticsagent;

import com.oracle.svm.core.util.VMError;
import java.util.HashSet;
import java.util.Set;

public class TracingAdvisor {
    private final Set<String> classesForInitializationTracing = new HashSet<String>();
    private final Set<String> classesForObjectInstantiationTracing = new HashSet<String>();

    public TracingAdvisor(String options) {
        String[] optionPairs;
        for (String option : optionPairs = options.split(",")) {
            String[] optionKeyValue = option.split("=");
            if (optionKeyValue.length != 2) {
                throw VMError.shouldNotReachHere((String)("AgentTracingAdvisor: Option must be in format <option>=<val>: " + option));
            }
            if (optionKeyValue[0].equals("c")) {
                this.classesForInitializationTracing.add(optionKeyValue[1]);
                continue;
            }
            if (optionKeyValue[0].equals("o")) {
                this.classesForObjectInstantiationTracing.add(optionKeyValue[1]);
                continue;
            }
            throw VMError.shouldNotReachHere((String)("AgentTracingAdvisor: Unknown option: " + optionKeyValue[0]));
        }
    }

    public boolean shouldTraceClassInitialization(String className) {
        return className != null && this.classesForInitializationTracing.contains(className);
    }

    public boolean shouldTraceObjectInstantiation(String className) {
        return className != null && this.classesForObjectInstantiationTracing.contains(className);
    }
}

