/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.filters;

import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import com.oracle.svm.configure.filters.RegexFilter;
import java.io.IOException;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;

public class ComplexFilter
implements ConfigurationFilter {
    private HierarchyFilterNode hierarchyFilterNode;
    private final RegexFilter regexFilter = new RegexFilter();

    public ComplexFilter(HierarchyFilterNode hierarchyFilterNode) {
        this.hierarchyFilterNode = hierarchyFilterNode;
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{');
        writer.indent().newline();
        this.hierarchyFilterNode.printJson(writer);
        writer.append(",\n").newline();
        this.regexFilter.printJson(writer);
        writer.unindent().newline();
        writer.append('}').newline();
    }

    @Override
    public void parseFromJson(EconomicMap<String, Object> topJsonObject) {
        this.hierarchyFilterNode.parseFromJson(topJsonObject);
        this.regexFilter.parseFromJson(topJsonObject);
    }

    @Override
    public boolean includes(String qualifiedName) {
        return this.hierarchyFilterNode.includes(qualifiedName) && this.regexFilter.includes(qualifiedName);
    }

    public HierarchyFilterNode getHierarchyFilterNode() {
        return this.hierarchyFilterNode;
    }

    public void setHierarchyFilterNode(HierarchyFilterNode hierarchyFilterNode) {
        this.hierarchyFilterNode = hierarchyFilterNode;
    }
}

