/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

public final class ConfigurationMemberInfo {
    private static final ConfigurationMemberInfo[][] cache = new ConfigurationMemberInfo[ConfigurationMemberDeclaration.values().length][ConfigurationMemberAccessibility.values().length];
    private final ConfigurationMemberDeclaration declaration;
    private final ConfigurationMemberAccessibility accessibility;

    private ConfigurationMemberInfo(ConfigurationMemberDeclaration declaration, ConfigurationMemberAccessibility accessibility) {
        this.declaration = declaration;
        this.accessibility = accessibility;
    }

    public ConfigurationMemberDeclaration getDeclaration() {
        return this.declaration;
    }

    public ConfigurationMemberAccessibility getAccessibility() {
        return this.accessibility;
    }

    public static ConfigurationMemberInfo get(ConfigurationMemberDeclaration memberKind, ConfigurationMemberAccessibility accessKind) {
        return cache[memberKind.ordinal()][accessKind.ordinal()];
    }

    public ConfigurationMemberInfo intersect(ConfigurationMemberInfo other) {
        return ConfigurationMemberInfo.get(this.declaration.intersect(other.declaration), this.accessibility.combine(other.accessibility));
    }

    public ConfigurationMemberInfo union(ConfigurationMemberInfo other) {
        return ConfigurationMemberInfo.get(this.declaration.union(other.declaration), this.accessibility.combine(other.accessibility));
    }

    public boolean includes(ConfigurationMemberInfo other) {
        return this.declaration.includes(other.declaration) && this.accessibility.includes(other.accessibility);
    }

    static {
        for (ConfigurationMemberDeclaration memberKind : ConfigurationMemberDeclaration.values()) {
            for (ConfigurationMemberAccessibility accessKind : ConfigurationMemberAccessibility.values()) {
                ConfigurationMemberInfo.cache[memberKind.ordinal()][accessKind.ordinal()] = new ConfigurationMemberInfo(memberKind, accessKind);
            }
        }
    }

    public static enum ConfigurationMemberDeclaration {
        DECLARED_AND_PUBLIC,
        DECLARED,
        PUBLIC,
        PRESENT;


        private boolean isMoreSpecificThan(ConfigurationMemberDeclaration other) {
            return other == null || this.ordinal() < other.ordinal();
        }

        public ConfigurationMemberDeclaration intersect(ConfigurationMemberDeclaration other) {
            if (this.equals((Object)DECLARED) && PUBLIC.equals((Object)other) || this.equals((Object)PUBLIC) && DECLARED.equals((Object)other)) {
                return DECLARED_AND_PUBLIC;
            }
            return this.isMoreSpecificThan(other) ? this : other;
        }

        private ConfigurationMemberDeclaration union(ConfigurationMemberDeclaration other) {
            return this.equals((Object)other) ? this : PRESENT;
        }

        public boolean includes(ConfigurationMemberDeclaration other) {
            if (this.equals((Object)DECLARED_AND_PUBLIC)) {
                return DECLARED.equals((Object)other) || PUBLIC.equals((Object)other);
            }
            return this.equals((Object)other);
        }
    }

    public static enum ConfigurationMemberAccessibility {
        NONE,
        QUERIED,
        ACCESSED;


        public ConfigurationMemberAccessibility combine(ConfigurationMemberAccessibility other) {
            return this.ordinal() < other.ordinal() ? other : this;
        }

        public ConfigurationMemberAccessibility remove(ConfigurationMemberAccessibility other) {
            return other.includes(this) ? NONE : this;
        }

        public boolean includes(ConfigurationMemberAccessibility other) {
            return this.ordinal() >= other.ordinal();
        }
    }
}

