/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import jdk.graal.compiler.processor.AbstractProcessor;
import jdk.graal.compiler.replacements.processor.GeneratedPlugin;
import jdk.graal.compiler.replacements.processor.ReplacementsAnnotationProcessor;

public class PluginGenerator {
    private final Map<Element, List<GeneratedPlugin>> plugins = new HashMap<Element, List<GeneratedPlugin>>();
    private static final Map<String, String> SUPPORTED_JVMCI_ARCHITECTURES = Map.of("amd64", "AMD64", "aarch64", "aarch64", "riscv64", "riscv64");

    public void addPlugin(GeneratedPlugin plugin) {
        Element topLevel = PluginGenerator.getTopLevelClass(plugin.intrinsicMethod);
        List<GeneratedPlugin> list = this.plugins.get(topLevel);
        if (list == null) {
            list = new ArrayList<GeneratedPlugin>();
            this.plugins.put(topLevel, list);
        }
        list.add(plugin);
    }

    public void generateAll(AbstractProcessor processor) {
        for (Map.Entry<Element, List<GeneratedPlugin>> entry : this.plugins.entrySet()) {
            PluginGenerator.disambiguateNames(entry.getValue());
            PluginGenerator.createPluginFactory(processor, entry.getKey(), entry.getValue());
        }
    }

    private static Element getTopLevelClass(Element element) {
        Element prev = element;
        for (Element enclosing = element.getEnclosingElement(); enclosing != null && enclosing.getKind() != ElementKind.PACKAGE; enclosing = enclosing.getEnclosingElement()) {
            prev = enclosing;
        }
        return prev;
    }

    private static void disambiguateWith(List<GeneratedPlugin> plugins, Function<GeneratedPlugin, String> genName) {
        plugins.sort(Comparator.comparing(GeneratedPlugin::getPluginName));
        GeneratedPlugin current = plugins.get(0);
        String currentName = current.getPluginName();
        for (int i = 1; i < plugins.size(); ++i) {
            GeneratedPlugin next = plugins.get(i);
            if (currentName.equals(next.getPluginName())) {
                if (current != null) {
                    current.setPluginName(genName.apply(current));
                    current = null;
                }
                next.setPluginName(genName.apply(next));
                continue;
            }
            current = next;
            currentName = current.getPluginName();
        }
    }

    private static void disambiguateNames(List<GeneratedPlugin> plugins) {
        int[] nextId = new int[]{0};
        PluginGenerator.disambiguateWith(plugins, plugin -> {
            int n = nextId[0];
            nextId[0] = n + 1;
            return plugin.getPluginName() + "__" + n;
        });
    }

    private static void createPluginFactory(AbstractProcessor processor, Element topLevelClass, List<GeneratedPlugin> plugins) {
        PackageElement pkg = (PackageElement)topLevelClass.getEnclosingElement();
        String genClassName = "PluginFactory_" + String.valueOf(topLevelClass.getSimpleName());
        String arch = SUPPORTED_JVMCI_ARCHITECTURES.get(pkg.getSimpleName().toString());
        String qualifiedGenClassName = String.valueOf(pkg.getQualifiedName()) + "." + genClassName;
        try {
            JavaFileObject factory = processor.env().getFiler().createSourceFile(qualifiedGenClassName, topLevelClass);
            try (PrintWriter out = new PrintWriter(factory.openWriter());){
                out.printf("// CheckStyle: stop header check\n", new Object[0]);
                out.printf("// CheckStyle: stop line length check\n", new Object[0]);
                out.printf("// GENERATED CONTENT - DO NOT EDIT\n", new Object[0]);
                out.printf("// GENERATORS: %s, %s\n", ReplacementsAnnotationProcessor.class.getName(), PluginGenerator.class.getName());
                out.printf("package %s;\n", pkg.getQualifiedName());
                out.printf("\n", new Object[0]);
                PluginGenerator.createImports(out, processor, plugins, pkg.getQualifiedName().toString());
                out.printf("\n", new Object[0]);
                for (GeneratedPlugin plugin : plugins) {
                    plugin.generate(processor, out);
                    out.printf("\n", new Object[0]);
                }
                if (arch != null) {
                    out.printf("public class %s implements GeneratedPluginFactory, jdk.graal.compiler.core.ArchitectureSpecific {\n", genClassName);
                    out.printf("    @Override\n", new Object[0]);
                    out.printf("    public String getArchitecture() {\n", new Object[0]);
                    out.printf("        return \"%s\";\n", arch);
                    out.printf("    }\n", new Object[0]);
                } else {
                    out.printf("public class %s implements GeneratedPluginFactory {\n", genClassName);
                }
                PluginGenerator.createPluginFactoryMethod(out, plugins);
                out.printf("}\n", new Object[0]);
            }
        }
        catch (IOException e) {
            processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        processor.createProviderFile(qualifiedGenClassName, "jdk.graal.compiler.nodes.graphbuilderconf.GeneratedPluginFactory", topLevelClass);
    }

    protected static void createImports(PrintWriter out, AbstractProcessor processor, List<GeneratedPlugin> plugins, String importingPackage) {
        HashSet<String> extra = new HashSet<String>();
        extra.add("jdk.vm.ci.meta.ResolvedJavaMethod");
        extra.add("java.lang.annotation.Annotation");
        extra.add("jdk.graal.compiler.nodes.ValueNode");
        extra.add("jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext");
        extra.add("jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin");
        extra.add("jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins");
        extra.add("jdk.graal.compiler.nodes.graphbuilderconf.GeneratedPluginFactory");
        extra.add("jdk.graal.compiler.nodes.graphbuilderconf.GeneratedPluginInjectionProvider");
        for (GeneratedPlugin plugin : plugins) {
            plugin.extraImports(processor, extra);
            extra.add("jdk.graal.compiler.nodes.graphbuilderconf." + plugin.pluginSuperclass());
            if (!plugin.needsReplacement(processor)) continue;
            extra.add("jdk.graal.compiler.options.ExcludeFromJacocoGeneratedReport");
            extra.add("jdk.graal.compiler.graph.NodeInputList");
            extra.add("jdk.graal.compiler.nodes.spi.Replacements");
            if (plugin.isWithExceptionReplacement(processor)) {
                extra.add("jdk.graal.compiler.nodes.PluginReplacementWithExceptionNode");
                continue;
            }
            extra.add("jdk.graal.compiler.nodes.PluginReplacementNode");
        }
        Pattern packageClassBoundary = Pattern.compile("\\.([A-Z])");
        out.printf("\n", new Object[0]);
        Object[] imports = extra.toArray(new String[extra.size()]);
        Arrays.sort(imports);
        for (Object i : imports) {
            Matcher matcher = packageClassBoundary.matcher((CharSequence)i);
            if (matcher.find()) {
                String packageName = ((String)i).substring(0, matcher.start());
                String className = ((String)i).substring(matcher.start() + 1);
                if (packageName.equals(importingPackage) && className.indexOf(46) == -1) continue;
            }
            out.printf("import %s;\n", i);
        }
    }

    private static void createPluginFactoryMethod(PrintWriter out, List<GeneratedPlugin> plugins) {
        out.printf("    @Override\n", new Object[0]);
        out.printf("    public void registerPlugins(InvocationPlugins plugins, GeneratedPluginInjectionProvider injection) {\n", new Object[0]);
        for (GeneratedPlugin plugin : plugins) {
            plugin.register(out);
        }
        out.printf("    }\n", new Object[0]);
    }
}

