/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.graal.code.CustomCallingConventionMethod;
import com.oracle.svm.core.graal.code.ExplicitCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointUtilityNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.foreign.ForeignGraphKit;
import com.oracle.svm.hosted.foreign.HighLevelUpcallStub;
import com.oracle.svm.hosted.foreign.UpcallStub;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.replacements.nodes.WriteRegisterNode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;

final class LowLevelUpcallStub
extends UpcallStub
implements CustomCallingConventionMethod {
    private final ResolvedJavaMethod highLevelStub;
    private final RegisterArray savedRegisters;
    private final AssignedLocation[] parametersAssignment;
    private static final Method ANNOTATIONS_HOLDER = ReflectionUtil.lookupMethod(LowLevelUpcallStub.class, (String)"annotationsHolder", (Class[])new Class[0]);
    private static final AnnotationValue[] INJECTED_ANNOTATIONS = SubstrateAnnotationExtractor.prepareInjectedAnnotations((Annotation[])new Annotation[]{AnnotationAccess.getAnnotation((AnnotatedElement)ANNOTATIONS_HOLDER, ExplicitCallingConvention.class), Uninterruptible.Utils.getAnnotation((AnnotatedElement)ANNOTATIONS_HOLDER)});

    static LowLevelUpcallStub make(JavaEntryPointInfo jep, AnalysisUniverse universe, MetaAccessProvider metaAccess) {
        return new LowLevelUpcallStub(jep, AbiUtils.singleton().adapt(jep), universe, metaAccess);
    }

    private LowLevelUpcallStub(JavaEntryPointInfo jep, AbiUtils.Adapter.Result.TypeAdaptation adapted, AnalysisUniverse universe, MetaAccessProvider metaAccess) {
        super(jep, adapted.callType(), metaAccess, false);
        this.highLevelStub = universe.lookup((JavaMethod)new HighLevelUpcallStub(jep, adapted, metaAccess));
        this.savedRegisters = ((SubstrateRegisterConfigFactory)ImageSingletons.lookup(SubstrateRegisterConfigFactory.class)).newRegisterFactory(SubstrateRegisterConfig.ConfigKind.NATIVE_TO_JAVA, null, (TargetDescription)ConfigurationValues.getTarget(), (Boolean)SubstrateOptions.PreserveFramePointer.getValue()).getCalleeSaveRegisters();
        this.parametersAssignment = adapted.parametersAssignment().toArray(new AssignedLocation[0]);
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        assert (ExplicitCallingConvention.Util.getCallingConventionKind((ResolvedJavaMethod)method, (boolean)false) == SubstrateCallingConventionKind.Custom);
        assert (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method));
        ForeignGraphKit kit = new ForeignGraphKit(debug, providers, (ResolvedJavaMethod)method, purpose);
        AbiUtils.Registers registers = AbiUtils.singleton().upcallSpecialArgumentsRegisters();
        ValueNode mh = kit.bindRegister(registers.methodHandle(), JavaKind.Object);
        ValueNode isolate = (ValueNode)kit.append((Node)kit.bindRegister(registers.isolate(), JavaKind.Long));
        ArrayList<Object> arguments = new ArrayList<Object>(kit.getInitialArguments());
        assert (!this.savedRegisters.asList().contains(registers.methodHandle()));
        assert (!this.savedRegisters.asList().contains(registers.isolate()));
        Map<Register, ValueNode> save = kit.saveRegisters((Iterable<Register>)this.savedRegisters);
        ValueNode enterResult = (ValueNode)kit.append((Node)CEntryPointEnterNode.attachThread((ValueNode)isolate, (boolean)false, (boolean)true));
        kit.startIf(IntegerEqualsNode.create((ValueNode)enterResult, (ValueNode)ConstantNode.forInt((int)0, (StructuredGraph)kit.getGraph()), (NodeView)NodeView.DEFAULT), ProfileData.BranchProbabilityData.create((double)0.999, (ProfileData.ProfileSource)ProfileData.ProfileSource.UNKNOWN));
        kit.thenPart();
        kit.elsePart();
        CStringConstant cst = new CStringConstant("Could not enter isolate.");
        ConstantNode msg = ConstantNode.forConstant((Stamp)StampFactory.pointer(), (Constant)cst, (MetaAccessProvider)kit.getMetaAccess());
        kit.append((Node)new CEntryPointUtilityNode(CEntryPointUtilityNode.UtilityAction.FailFatally, enterResult, (ValueNode)msg));
        kit.append((Node)new DeadEndNode());
        kit.endIf();
        StackValueNode returnBuffer = null;
        if (this.jep.buffersReturn()) {
            assert (this.jep.handleType().returnType().equals(Void.TYPE)) : this.getName();
            returnBuffer = (StackValueNode)kit.append((Node)StackValueNode.create((int)this.jep.returnBufferSize(), (ResolvedJavaMethod)method, (int)-5, (boolean)true));
            FrameState frameState = new FrameState(-5);
            frameState.invalidateForDeoptimization();
            returnBuffer.setStateAfter((FrameState)kit.getGraph().add((Node)frameState));
            arguments.add(0, returnBuffer);
        }
        arguments.add(0, mh);
        InvokeWithExceptionNode returnValue = kit.createJavaCallWithException(CallTargetNode.InvokeKind.Static, this.highLevelStub, arguments.toArray(ValueNode.EMPTY_ARRAY));
        kit.exceptionPart();
        kit.append((Node)new DeadEndNode());
        kit.endInvokeWithException();
        if (this.jep.buffersReturn()) {
            assert (returnBuffer != null);
            long offset = 0L;
            block4: for (AssignedLocation loc : AbiUtils.create().toMemoryAssignment(this.jep.returnAssignment(), true)) {
                assert (loc.assignsToRegister());
                assert (!save.containsKey(loc.register()));
                OffsetAddressNode address = new OffsetAddressNode((ValueNode)returnBuffer, (ValueNode)ConstantNode.forLong((long)offset, (StructuredGraph)kit.getGraph()));
                ReadNode val = (ReadNode)kit.append((Node)new ReadNode((AddressNode)address, LocationIdentity.any(), StampFactory.forKind((JavaKind)loc.registerKind()), BarrierType.NONE, MemoryOrderMode.PLAIN));
                kit.append((Node)new WriteRegisterNode(loc.register(), (ValueNode)val));
                switch (loc.registerKind()) {
                    case Long: {
                        offset += 8L;
                        continue block4;
                    }
                    case Double: {
                        offset += 16L;
                        continue block4;
                    }
                    default: {
                        VMError.shouldNotReachHere((String)"Invalid kind");
                    }
                }
            }
            assert (offset == (long)this.jep.returnBufferSize());
        }
        kit.append((Node)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave));
        kit.restoreRegisters(save);
        kit.createReturn((ValueNode)returnValue, this.jep.cMethodType());
        return kit.finalizeGraph();
    }

    @Uninterruptible(reason="Directly accesses registers and IsolateThread might not be correctly set up", calleeMustBe=false)
    @ExplicitCallingConvention(value=SubstrateCallingConventionKind.Custom)
    private static void annotationsHolder() {
    }

    public AnnotationValue[] getInjectedAnnotations() {
        return INJECTED_ANNOTATIONS;
    }

    public SubstrateCallingConventionType getCallingConvention() {
        return SubstrateCallingConventionType.makeCustom((boolean)false, (AssignedLocation[])this.parametersAssignment, (AssignedLocation[])AbiUtils.singleton().toMemoryAssignment(this.jep.returnAssignment(), true));
    }
}

