/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.foreign.LookupNativeLibraries;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.internal.foreign.MemorySessionImpl;
import jdk.internal.foreign.Utils;
import org.graalvm.word.PointerBase;

final class Util_java_lang_foreign_SymbolLookup {
    Util_java_lang_foreign_SymbolLookup() {
    }

    @AlwaysInline(value="As in the JDK")
    static void ensureNativeAccess(Class<?> currentClass, Class<?> owner, String methodName) {
        Target_java_lang_Module module = (Target_java_lang_Module)SubstrateUtil.cast((Object)(currentClass != null ? currentClass.getModule() : ClassLoader.getSystemClassLoader().getUnnamedModule()), Target_java_lang_Module.class);
        if (JavaVersionUtil.JAVA_SPEC <= 21) {
            module.ensureNativeAccess(owner, methodName);
        } else {
            module.ensureNativeAccess(owner, methodName, currentClass, false);
        }
    }

    static <Z> LookupNativeLibraries createNativeLibraries(BiConsumer<LookupNativeLibraries, Z> loadLibraryFunc, List<Z> libDescs) {
        LookupNativeLibraries nativeLibraries = new LookupNativeLibraries();
        for (Z libDesc : libDescs) {
            Objects.requireNonNull(libDesc);
            try {
                loadLibraryFunc.accept(nativeLibraries, libDesc);
            }
            catch (UnsatisfiedLinkError e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return nativeLibraries;
    }

    static SymbolLookup createLookup(final LookupNativeLibraries nativeLibraries) {
        return new SymbolLookup(){

            @Override
            public Optional<MemorySegment> find(String name) {
                Objects.requireNonNull(name);
                if (Utils.containsNullChars(name)) {
                    return Optional.empty();
                }
                PointerBase addr = nativeLibraries.findSymbol(name);
                return addr.isNull() ? Optional.empty() : Optional.of(MemorySegment.ofAddress(addr.rawValue()));
            }
        };
    }

    static <Z> SymbolLookup libraryLookup(BiConsumer<LookupNativeLibraries, Z> loadLibraryFunc, List<Z> libDescs) {
        Objects.requireNonNull(libDescs);
        LookupNativeLibraries nativeLibraries = Util_java_lang_foreign_SymbolLookup.createNativeLibraries(loadLibraryFunc, libDescs);
        return Util_java_lang_foreign_SymbolLookup.createLookup(nativeLibraries);
    }

    static <Z> SymbolLookup libraryLookup(BiConsumer<LookupNativeLibraries, Z> loadLibraryFunc, final Arena libArena, List<Z> libDescs) {
        Objects.requireNonNull(libDescs);
        Objects.requireNonNull(libArena);
        final LookupNativeLibraries nativeLibraries = Util_java_lang_foreign_SymbolLookup.createNativeLibraries(loadLibraryFunc, libDescs);
        final SymbolLookup baseLookup = Util_java_lang_foreign_SymbolLookup.createLookup(nativeLibraries);
        MemorySessionImpl.toMemorySession(libArena).addOrCleanupIfFail(new MemorySessionImpl.ResourceList.ResourceCleanup(){

            @Override
            public void cleanup() {
                nativeLibraries.unloadAllLibraries();
            }
        });
        return new SymbolLookup(){

            @Override
            public Optional<MemorySegment> find(String name) {
                return baseLookup.find(name).map(seg -> seg.reinterpret(libArena, null));
            }
        };
    }
}

