/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.sbom.packageurl;

import com.oracle.svm.enterprise.sbom.packageurl.c;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class b {
    private final String Ex = b.an("pkg");
    private final String Ey;
    private final String Ez;
    private final String EA;
    private final String EB;
    private final Map<String, String> EC;
    private final String ED;

    public b(String string, String string2, String string3, String string4, TreeMap<String, String> treeMap, String string5) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        this.Ey = b.ao(string);
        this.Ez = this.ap(string2);
        this.EA = this.aq(string3);
        this.EB = b.ar(string4);
        this.EC = b.i(treeMap);
        this.ED = b.a(string5, true);
        b.b(this.Ey, this.Ez, this.EA);
    }

    private static String an(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if ("pkg".equals(string)) {
            return "pkg";
        }
        throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL scheme is invalid");
    }

    private static String ao(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL type cannot be null or empty");
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL type cannot start with a number");
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        if (string2.chars().anyMatch(n2 -> !(n2 == 46 || n2 == 43 || n2 == 45 || n2 >= 97 && n2 <= 122 || n2 >= 48 && n2 <= 57))) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL type contains invalid characters");
        }
        return string2;
    }

    private String ap(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return this.c(string.split("/"));
    }

    private String c(String[] stringArray) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string = b.a(stringArray, false);
        return switch (this.Ey) {
            case "bitbucket", "deb", "github", "golang", "rpm" -> string.toLowerCase(Locale.ROOT);
            default -> string;
        };
    }

    private String aq(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL name specified is invalid");
        }
        return switch (this.Ey) {
            case "bitbucket", "deb", "github", "golang" -> string.toLowerCase(Locale.ROOT);
            case "pypi" -> string.replaceAll("_", "-").toLowerCase(Locale.ROOT);
            default -> string;
        };
    }

    private static String ar(String string) {
        return string;
    }

    private static Map<String, String> i(Map<String, String> map) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            b.as(entry.getKey());
            String string = entry.getValue();
            if (string != null && !string.isEmpty()) continue;
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL specified contains a qualifier key with an empty or null value");
        }
        return map;
    }

    private static void as(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("Qualifier key is invalid: " + string);
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9' || !string.chars().allMatch(n2 -> n2 >= 97 && n2 <= 122 || n2 >= 48 && n2 <= 57 || n2 == 46 || n2 == 45 || n2 == 95)) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("Qualifier key is invalid: " + string);
        }
    }

    private static String a(String string, boolean bl2) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return b.a(string.split("/"), bl2);
    }

    private static String a(String[] stringArray, boolean bl2) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        try {
            return Arrays.stream(stringArray).peek(string -> {
                if (bl2 && ("..".equals(string) || ".".equals(string))) {
                    throw new c("Segments in the subpath may not be a period ('.') or repeated period ('..')");
                }
                if (string.contains("/")) {
                    throw new c("Segments in the namespace and subpath may not contain a forward slash ('/')");
                }
                if (string.isEmpty()) {
                    throw new c("Segments in the namespace and subpath may not be empty");
                }
            }).collect(Collectors.joining("/"));
        }
        catch (c c2) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a(c2.getMessage());
        }
    }

    public String toString() {
        return this.kJ();
    }

    public String kJ() {
        return this.g(false);
    }

    private String g(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.Ex).append(":");
        if (this.Ey != null) {
            stringBuilder.append(this.Ey);
        }
        stringBuilder.append("/");
        if (this.Ez != null) {
            stringBuilder.append(this.au(this.Ez));
            stringBuilder.append("/");
        }
        if (this.EA != null) {
            stringBuilder.append(this.at(this.EA));
        }
        if (this.EB != null) {
            stringBuilder.append("@").append(this.at(this.EB));
        }
        if (!bl2) {
            if (this.EC != null && !this.EC.isEmpty()) {
                stringBuilder.append("?");
                this.EC.entrySet().stream().forEachOrdered(entry -> {
                    stringBuilder.append(((String)entry.getKey()).toLowerCase(Locale.ROOT));
                    stringBuilder.append("=");
                    stringBuilder.append(this.at((String)entry.getValue()));
                    stringBuilder.append("&");
                });
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            if (this.ED != null) {
                stringBuilder.append("#").append(this.au(this.ED));
            }
        }
        return stringBuilder.toString();
    }

    private String at(String string) {
        return b.a(string, StandardCharsets.UTF_8);
    }

    private static String a(String string, Charset charset) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : string.getBytes(charset)) {
            if (b.ae(by)) {
                stringBuilder.append((char)by);
                continue;
            }
            stringBuilder.append('%');
            stringBuilder.append(Integer.toHexString(by).toUpperCase(Locale.ROOT));
        }
        return stringBuilder.toString();
    }

    private static boolean ae(int n2) {
        return b.af(n2) || b.ag(n2) || 45 == n2 || 46 == n2 || 95 == n2 || 126 == n2;
    }

    private static boolean af(int n2) {
        return n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90;
    }

    private static boolean ag(int n2) {
        return n2 >= 48 && n2 <= 57;
    }

    private static void b(String string, String string2, String string3) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if ("maven".equals(string) && (string2 == null || string2.isEmpty() || string3 == null || string3.isEmpty())) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL specified is invalid. Maven requires both a namespace and name.");
        }
    }

    private String au(String string) {
        return Arrays.stream(string.split("/")).map(this::at).collect(Collectors.joining("/"));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        b b2 = (b)object;
        return Objects.equals(this.Ex, b2.Ex) && Objects.equals(this.Ey, b2.Ey) && Objects.equals(this.Ez, b2.Ez) && Objects.equals(this.EA, b2.EA) && Objects.equals(this.EB, b2.EB) && Objects.equals(this.EC, b2.EC) && Objects.equals(this.ED, b2.ED);
    }

    public int hashCode() {
        return Objects.hash(this.Ex, this.Ey, this.Ez, this.EA, this.EB, this.EC, this.ED);
    }

    public static class a {
        public static final String EE = "bitbucket";
        public static final String EF = "deb";
        public static final String EG = "github";
        public static final String EH = "golang";
        public static final String EI = "maven";
        public static final String EJ = "pypi";
        public static final String EK = "rpm";
    }
}

