/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework.collection;

import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import java.util.List;
import java.util.function.BiConsumer;

public interface PrefixTree<T> {
    public List<Cursor<T>> roots();

    default public void topDown(BiConsumer<CallingContext, T> biConsumer) {
        for (Cursor<T> cursor : this.roots()) {
            cursor.topDown(CallingContext.withCallee(cursor.codePosition(), CallingContext.empty()), biConsumer);
        }
    }

    public static interface Cursor<T> {
        public CodePosition codePosition();

        public Iterable<Cursor<T>> children();

        public T value();

        default public void topDown(CallingContext callingContext, BiConsumer<CallingContext, T> biConsumer) {
            biConsumer.accept(callingContext, (CallingContext)this.value());
            for (Cursor<CallingContext> cursor : this.children()) {
                cursor.topDown(CallingContext.withCallee(cursor.codePosition(), callingContext), biConsumer);
            }
        }
    }
}

