/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.InstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.ProfilingMethod;
import com.oracle.svm.enterprise.profiling.framework.ProfilingType;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import com.oracle.svm.enterprise.profiling.framework.collection.PrefixTree;
import com.oracle.svm.util.LogUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;

public class ProfileDumper {
    public static final int CURRENT_MAJOR_VERSION = 1;
    public static final int CURRENT_MINOR_VERSION = 0;
    public static final int CURRENT_PATCH_VERSION = 0;
    public static final String VERSION_DELIMITER = ".";
    public static final String CURRENT_VERSION = "1.0.0";
    public static final String KEY_CHAIN_DELIMITER = "<";
    public static final String KEY_ELEM_DELIMITER = ":";
    public static final String RECORDS = "records";
    public static final String CTX = "ctx";
    public static final String VERSION = "version";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String SIGNATURE = "signature";
    public static final String TYPES = "types";
    public static final String METHODS = "methods";
    public static final String CALL_COUNT_PROFILES = "callCountProfiles";
    public static final String CONDITIONAL_PROFILES = "conditionalProfiles";
    public static final String VIRTUAL_INVOKE_PROFILES = "virtualInvokeProfiles";
    public static final String INSTANCE_OF_PROFILES = "instanceOfProfiles";
    public static final String MONITOR_PROFILES = "monitorProfiles";
    public static final String SAMPLING_PROFILES = "samplingProfiles";
    public static final String MONITOR_CONTEXT = "0:0";
    public static final String PROFILES_DUMP_FILE_EXTENSION = ".iprof";
    protected final DumpableData data;
    private final boolean serializeThrowable;
    private final Function<Integer, Integer> toAnalysisMethodId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dumpToFile(ProfileDumper profileDumper, Path path, boolean bl2) {
        Objects.requireNonNull(path);
        DumpingLock dumpingLock = DumpingLock.INSTANCE;
        synchronized (dumpingLock) {
            long l2 = System.nanoTime();
            String string = String.format("profile-%d", l2);
            try {
                Path path2 = Files.createTempFile(path.toAbsolutePath().getParent(), string, PROFILES_DUMP_FILE_EXTENSION, new FileAttribute[0]);
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(path2.toFile()));){
                    profileDumper.dumpIprof(outputStreamWriter);
                }
                ProfileDumper.tryAtomicMove(path2, path);
                if (!bl2) return;
            }
            catch (Exception exception) {
                try {
                    System.err.printf("[PGO] Error during profile writing: %s%n", exception.getMessage());
                    if (!bl2) return;
                }
                catch (Throwable throwable) {
                    if (!bl2) throw throwable;
                    System.err.printf("[PGO] dumped profile to %s in %dms%n", path, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2));
                    throw throwable;
                }
                System.err.printf("[PGO] dumped profile to %s in %dms%n", path, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2));
                {
                }
            }
            System.err.printf("[PGO] dumped profile to %s in %dms%n", path, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2));
            {
            }
            return;
        }
    }

    public static ProfileDumper createDefault(DumpableData dumpableData, Function<Integer, Integer> function, boolean bl2) {
        return new ProfileDumper(dumpableData, function, bl2);
    }

    private ProfileDumper(DumpableData dumpableData, Function<Integer, Integer> function, boolean bl2) {
        this.data = Objects.requireNonNull(dumpableData);
        this.toAnalysisMethodId = Objects.requireNonNull(function);
        this.serializeThrowable = bl2;
    }

    public void dumpIprof(OutputStreamWriter outputStreamWriter) throws IOException {
        try (JsonBuilder.ObjectBuilder objectBuilder = new JsonWriter((Writer)outputStreamWriter).objectBuilder();){
            this.dumpVersion(objectBuilder);
            this.dumpTypes(objectBuilder);
            this.dumpMethods(objectBuilder);
            this.dumpCounters(objectBuilder);
            this.dumpSamples(objectBuilder);
        }
        catch (Throwable throwable) {
            if (this.serializeThrowable) {
                ProfileDumper.dumpThrowable(throwable, outputStreamWriter);
            }
            throw throwable;
        }
    }

    private static void dumpThrowable(Throwable throwable, OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.append(System.lineSeparator());
        outputStreamWriter.append(System.lineSeparator());
        outputStreamWriter.append(throwable.getMessage());
        outputStreamWriter.append(String.valueOf(throwable.getClass()));
        outputStreamWriter.append(System.lineSeparator());
        outputStreamWriter.append(System.lineSeparator());
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            outputStreamWriter.append(stackTraceElement.toString());
            outputStreamWriter.append(System.lineSeparator());
        }
    }

    private void dumpSamples(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(SAMPLING_PROFILES).array();){
            this.data.samplingData().samples().topDown((callingContext, l2) -> {
                if (l2 > 0L) {
                    this.dumpSample(arrayBuilder, (CallingContext)callingContext, (long)l2);
                }
            });
        }
    }

    private void dumpSample(JsonBuilder.ArrayBuilder arrayBuilder, CallingContext callingContext, long l2) {
        try (JsonBuilder.ObjectBuilder objectBuilder = arrayBuilder.nextEntry().object();){
            objectBuilder.append(CTX, (Object)ProfileDumper.toString(callingContext, this.toAnalysisMethodId));
            try (JsonBuilder.ArrayBuilder arrayBuilder2 = objectBuilder.append(RECORDS).array();){
                arrayBuilder2.append((Object)l2);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static String toString(CallingContext callingContext, Function<Integer, Integer> function) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{""};
        callingContext.traverseFromCallee(codePosition -> {
            stringBuilder.append(stringArray[0]);
            stringBuilder.append(function.apply(codePosition.methodID()));
            stringBuilder.append(KEY_ELEM_DELIMITER);
            stringBuilder.append(codePosition.bci());
            stringArray[0] = KEY_CHAIN_DELIMITER;
        });
        return stringBuilder.toString();
    }

    protected void dumpCounters(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        this.dumpCallCounts(objectBuilder);
        this.dumpConditionalCounts(objectBuilder);
        this.dumpVirtualCallCounts(objectBuilder);
        this.dumpMonitorEnterCounts(objectBuilder);
    }

    private void dumpMonitorEnterCounts(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(MONITOR_PROFILES).array();
             JsonBuilder.ObjectBuilder objectBuilder2 = arrayBuilder.nextEntry().object();){
            objectBuilder2.append(CTX, (Object)MONITOR_CONTEXT);
            this.dumpMonitorCounts(objectBuilder2);
        }
    }

    private void dumpMonitorCounts(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(RECORDS).array();){
            Metadata metadata = this.data.metadata();
            CommonInstrumentationData commonInstrumentationData = this.data.commonInstrumentationData();
            metadata.forEachMonitorTypeID(n2 -> {
                long l2 = commonInstrumentationData.readTotalMonitorCount(n2);
                if (l2 == 0L) {
                    return;
                }
                try {
                    arrayBuilder.append((Object)n2).append((Object)l2);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            });
        }
    }

    private void dumpVirtualCallCounts(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(VIRTUAL_INVOKE_PROFILES).array();){
            this.data.metadata().forest().forEach((cursor, callingContext) -> this.dumpVirtualCallCount(arrayBuilder, cursor, callingContext));
        }
    }

    private void dumpVirtualCallCount(JsonBuilder.ArrayBuilder arrayBuilder, CallingContextForest.Cursor cursor, CallingContext callingContext) {
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        cursor.forEachPayload(payload -> {
            if (payload instanceof CommonInstrumentationData.VirtualCallPayload) {
                CommonInstrumentationData.VirtualCallPayload virtualCallPayload = (CommonInstrumentationData.VirtualCallPayload)payload;
                this.extractTypeIDsAndCountersFromPayloadToMap(virtualCallPayload, hashMap);
            }
        });
        if (!hashMap.isEmpty()) {
            ProfileDumper.dumpVirtualCallCount(arrayBuilder, callingContext, hashMap);
        }
    }

    private void extractTypeIDsAndCountersFromPayloadToMap(CommonInstrumentationData.VirtualCallPayload virtualCallPayload, Map<Integer, Long> map) {
        int n2;
        InstrumentationData.Storage storage = this.data.commonInstrumentationData().storage();
        for (int i2 = 0; i2 < virtualCallPayload.length() && !virtualCallPayload.isNoTypeID(n2 = virtualCallPayload.typeID(storage, i2)); ++i2) {
            long l2 = virtualCallPayload.readTotalCounterValue(storage, i2);
            if (l2 <= 0L) continue;
            map.merge(n2, l2, Long::sum);
        }
    }

    private static void dumpVirtualCallCount(JsonBuilder.ArrayBuilder arrayBuilder, CallingContext callingContext, Map<Integer, Long> map) {
        try (JsonBuilder.ObjectBuilder objectBuilder = arrayBuilder.nextEntry().object();){
            objectBuilder.append(CTX, (Object)ProfileDumper.toString(callingContext));
            try (JsonBuilder.ArrayBuilder arrayBuilder2 = objectBuilder.append(RECORDS).array();){
                for (Integer n2 : ProfileDumper.sortedTypeIDs(map)) {
                    arrayBuilder2.append((Object)n2).append((Object)map.get(n2));
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static List<Integer> sortedTypeIDs(Map<Integer, Long> map) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(map.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    private void dumpConditionalCounts(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(CONDITIONAL_PROFILES).array();){
            this.data.metadata().forest().forEach((cursor, callingContext) -> this.dumpConditionalCount(arrayBuilder, cursor, callingContext));
        }
    }

    private void dumpConditionalCount(JsonBuilder.ArrayBuilder arrayBuilder, CallingContextForest.Cursor cursor, CallingContext callingContext) {
        cursor.forEachPayload(payload -> {
            CommonInstrumentationData.ConditionalPayload conditionalPayload;
            if (payload instanceof CommonInstrumentationData.ConditionalPayload && this.shouldDump(conditionalPayload = (CommonInstrumentationData.ConditionalPayload)payload)) {
                this.dumpConditionalCount(arrayBuilder, callingContext, conditionalPayload);
            }
        });
    }

    private void dumpConditionalCount(JsonBuilder.ArrayBuilder arrayBuilder, CallingContext callingContext, CommonInstrumentationData.ConditionalPayload conditionalPayload) {
        try (JsonBuilder.ObjectBuilder objectBuilder = arrayBuilder.nextEntry().object();){
            objectBuilder.append(CTX, (Object)ProfileDumper.toString(callingContext));
            try (JsonBuilder.ArrayBuilder arrayBuilder2 = objectBuilder.append(RECORDS).array();){
                for (int i2 = 0; i2 < conditionalPayload.length(); ++i2) {
                    arrayBuilder2.append((Object)conditionalPayload.bciAt(i2));
                    arrayBuilder2.append((Object)conditionalPayload.successorAt(i2));
                    arrayBuilder2.append((Object)conditionalPayload.readTotalCounterValue(this.data.commonInstrumentationData().storage(), i2));
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private boolean shouldDump(CommonInstrumentationData.ConditionalPayload conditionalPayload) {
        for (int i2 = 0; i2 < conditionalPayload.length(); ++i2) {
            if (conditionalPayload.readTotalCounterValue(this.data.commonInstrumentationData().storage(), i2) == 0L) continue;
            return true;
        }
        return false;
    }

    private void dumpCallCounts(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(CALL_COUNT_PROFILES).array();){
            this.data.metadata().forest().forEach((cursor, callingContext) -> this.dumpCallCount(arrayBuilder, cursor, callingContext));
        }
    }

    void dumpCallCount(JsonBuilder.ArrayBuilder arrayBuilder, CallingContextForest.Cursor cursor, CallingContext callingContext) {
        long l2 = this.sumCallCountCounters(cursor);
        if (l2 == 0L) {
            return;
        }
        try (JsonBuilder.ObjectBuilder objectBuilder = arrayBuilder.nextEntry().object();){
            objectBuilder.append(CTX, (Object)ProfileDumper.toString(callingContext));
            try (JsonBuilder.ArrayBuilder arrayBuilder2 = objectBuilder.append(RECORDS).array();){
                arrayBuilder2.append((Object)l2);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private long sumCallCountCounters(CallingContextForest.Cursor cursor) {
        long[] lArray = new long[]{0L};
        cursor.forEachPayload(payload -> {
            if (payload instanceof CommonInstrumentationData.MethodEntryPayload) {
                CommonInstrumentationData.MethodEntryPayload methodEntryPayload = (CommonInstrumentationData.MethodEntryPayload)payload;
                lArray[0] = lArray[0] + methodEntryPayload.readTotalCounterValue(this.data.commonInstrumentationData().storage());
            }
        });
        return lArray[0];
    }

    private static String toString(CallingContext callingContext) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{""};
        callingContext.traverseFromCallee(codePosition -> {
            stringBuilder.append(stringArray[0]);
            stringBuilder.append(codePosition.methodID());
            stringBuilder.append(KEY_ELEM_DELIMITER);
            stringBuilder.append(codePosition.bci());
            stringArray[0] = KEY_CHAIN_DELIMITER;
        });
        return stringBuilder.toString();
    }

    private void dumpMethods(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        ProfileDumper.dumpMethods(objectBuilder, this.data.metadata().methods());
    }

    public static void dumpMethods(JsonBuilder.ObjectBuilder objectBuilder, ProfilingMethod[] profilingMethodArray) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(METHODS).array();){
            for (ProfilingMethod profilingMethod : profilingMethodArray) {
                ProfileDumper.dumpMethod(arrayBuilder, profilingMethod);
            }
        }
    }

    private static void dumpMethod(JsonBuilder.ArrayBuilder arrayBuilder, ProfilingMethod profilingMethod) throws IOException {
        try (JsonBuilder.ObjectBuilder objectBuilder = arrayBuilder.nextEntry().object();){
            objectBuilder.append(ID, (Object)profilingMethod.id());
            objectBuilder.append(NAME, (Object)profilingMethod.name());
            ProfileDumper.dumpSignature(profilingMethod, objectBuilder);
        }
    }

    private static void dumpSignature(ProfilingMethod profilingMethod, JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(SIGNATURE).array();){
            for (int n2 : profilingMethod.signature()) {
                arrayBuilder.append((Object)n2);
            }
        }
    }

    protected void dumpVersion(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        objectBuilder.append(VERSION, (Object)CURRENT_VERSION);
    }

    private void dumpTypes(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        ProfileDumper.dumpTypes(objectBuilder, this.data.metadata().types());
    }

    public static void dumpTypes(JsonBuilder.ObjectBuilder objectBuilder, ProfilingType[] profilingTypeArray) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(TYPES).array();){
            for (ProfilingType profilingType : profilingTypeArray) {
                ProfileDumper.dumpType(arrayBuilder, profilingType);
            }
        }
    }

    private static void dumpType(JsonBuilder.ArrayBuilder arrayBuilder, ProfilingType profilingType) throws IOException {
        try (JsonBuilder.ObjectBuilder objectBuilder = arrayBuilder.nextEntry().object();){
            objectBuilder.append(ID, (Object)profilingType.id());
            objectBuilder.append(NAME, (Object)profilingType.name());
        }
    }

    public static void tryAtomicMove(Path path, Path path2) throws IOException {
        try {
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            LogUtils.warning((String)("Could not move temporary PGO profile (" + String.valueOf(path.toAbsolutePath()) + ") to (" + String.valueOf(path2.toAbsolutePath()) + ") atomically. This might result in inconsistencies while reading the file."));
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static final class DumpingLock {
        private static final DumpingLock INSTANCE = new DumpingLock();

        private DumpingLock() {
        }
    }

    public static interface DumpableData {
        public SampleProvider samplingData();

        public Metadata metadata();

        public CommonInstrumentationData commonInstrumentationData();
    }

    public static interface SampleProvider {
        public PrefixTree<Long> samples();
    }

    public static final class Experimental {
        private Experimental() {
            throw new IllegalStateException("Experimental should never be instantiated");
        }

        public static final class WithInstanceOfProfiles
        extends ProfileDumper {
            public WithInstanceOfProfiles(DumpableData dumpableData, Function<Integer, Integer> function, boolean bl2) {
                super(dumpableData, function, bl2);
            }

            @Override
            protected void dumpCounters(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
                super.dumpCounters(objectBuilder);
                this.dumpInstanceOfCounts(objectBuilder);
            }

            @Override
            protected void dumpVersion(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
                objectBuilder.append(ProfileDumper.VERSION, (Object)"1.0.0-experimental:instanceof");
            }

            private void dumpInstanceOfCounts(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
                try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(ProfileDumper.INSTANCE_OF_PROFILES).array();){
                    this.data.metadata().forest().forEach((cursor, callingContext) -> this.dumpInstanceOfCount(arrayBuilder, cursor, callingContext));
                }
            }

            private void dumpInstanceOfCount(JsonBuilder.ArrayBuilder arrayBuilder, CallingContextForest.Cursor cursor, CallingContext callingContext) {
                HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
                cursor.forEachPayload(payload -> {
                    if (payload instanceof CommonInstrumentationData.InstanceOfPayload) {
                        int n2;
                        CommonInstrumentationData.InstanceOfPayload instanceOfPayload = (CommonInstrumentationData.InstanceOfPayload)payload;
                        InstrumentationData.Storage storage = this.data.commonInstrumentationData().storage();
                        for (int i2 = 0; i2 < instanceOfPayload.length() && !instanceOfPayload.isNoTypeID(n2 = instanceOfPayload.typeID(storage, i2)); ++i2) {
                            long l2 = instanceOfPayload.readTotalCounterValue(storage, i2);
                            if (l2 <= 0L) continue;
                            hashMap.merge(n2, l2, Long::sum);
                        }
                    }
                });
                if (!hashMap.isEmpty()) {
                    ProfileDumper.dumpVirtualCallCount(arrayBuilder, callingContext, hashMap);
                }
            }
        }
    }

    public static class Options {
        public static final RuntimeOptionKey<Boolean> ProfilesIncludeException = new RuntimeOptionKey((Object)false, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

